/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.GalleryActivity;
import com.gaadi.neon.adapter.FlashModeRecyclerHorizontalAdapter;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.DrawingView;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonUtils;
import com.gaadi.neon.util.PhotoParams;
import com.gaadi.neon.util.PrefsUtils;
import com.scanlibrary.R;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CameraFragment
extends Fragment
implements View.OnClickListener,
View.OnTouchListener,
Camera.PictureCallback {
    public static final int GALLERY_PICK = 99;
    private static final String TAG = "CameraFragment";
    private static final int REQUEST_REVIEW = 100;
    private PhotoParams mPhotoParams;
    private String imageName;
    private int maxNumberOfImages;
    private DrawingView drawingView;
    private ImageView buttonCapture;
    private ImageView buttonGallery;
    private ImageView buttonDone;
    private TextView tvImageName;
    private ImageView currentFlashMode;
    private ArrayList<String> supportedFlashModes;
    private RecyclerView rcvFlash;
    private LinearLayout scrollView;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private Camera mCamera;
    private CameraPreview mCameraPreview;
    private boolean readyToTakePicture;
    private FrameLayout mCameraLayout;
    private View fragmentView;
    private Activity mActivity;
    private PictureTakenListener mPictureTakenListener;
    private boolean permissionAlreadyRequested;
    private boolean useFrontFacingCamera;
    private boolean enableCapturedReview;
    private float mDist;
    private PhotoParams.CameraFacing cameraFacing;

    public static CameraFragment getInstance(PhotoParams photoParams) {
        CameraFragment fragment = new CameraFragment();
        Bundle extras = new Bundle();
        extras.putSerializable("photoParams", (Serializable)photoParams);
        fragment.setArguments(extras);
        return fragment;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.mPictureTakenListener = (PictureTakenListener)activity;
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.fragmentView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.camera_fragment, container, false);
        this.mPhotoParams = (PhotoParams)this.getArguments().getSerializable("photoParams");
        this.mActivity = this.getActivity();
        if (this.mPhotoParams != null) {
            this.imageName = this.mPhotoParams.getImageName();
            this.maxNumberOfImages = this.mPhotoParams.getNoOfPhotos();
            this.enableCapturedReview = this.mPhotoParams.isEnableCapturedReview();
            PhotoParams.CameraOrientation orientation = this.mPhotoParams.getOrientation();
            this.cameraFacing = this.mPhotoParams.getCameraFace();
            Log.d((String)TAG, (String)("onCreateView: " + (Object)((Object)this.cameraFacing)));
            boolean isGalleryEnabled = this.mPhotoParams.isGalleryFromCameraEnabled();
            this.drawingView = new DrawingView((Context)this.mActivity);
            this.setOrientation(this.mActivity, orientation);
            LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this.mActivity, 0, false);
            this.currentFlashMode = (ImageView)this.fragmentView.findViewById(R.id.currentFlashMode);
            this.rcvFlash = (RecyclerView)this.fragmentView.findViewById(R.id.flash_listview);
            this.rcvFlash.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
            this.buttonCapture = (ImageView)this.fragmentView.findViewById(R.id.buttonCapture);
            this.buttonGallery = (ImageView)this.fragmentView.findViewById(R.id.buttonGallery);
            this.buttonDone = (ImageView)this.fragmentView.findViewById(R.id.buttonDone);
            this.tvImageName = (TextView)this.fragmentView.findViewById(R.id.imageName);
            ImageView mSwitchCamera = (ImageView)this.fragmentView.findViewById(R.id.switchCamera);
            if (NeonUtils.isFrontCameraAvailable() != 1) {
                mSwitchCamera.setVisibility(8);
                this.useFrontFacingCamera = false;
            }
            if (!isGalleryEnabled) {
                this.buttonGallery.setVisibility(8);
            }
            mSwitchCamera.setOnClickListener((View.OnClickListener)this);
            this.scrollView = (LinearLayout)this.fragmentView.findViewById(R.id.imageHolderView);
            if (savedInstanceState != null) {
                Log.e((String)"Gallery", (String)"savedInstanceState not null");
                this.imagesList = (ArrayList)savedInstanceState.getSerializable("imagesSelected");
                this.addInScrollView(this.imagesList);
            }
            this.fragmentView.setOnTouchListener((View.OnTouchListener)this);
        } else {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(R.string.pass_params), (int)0).show();
        }
        return this.fragmentView;
    }

    public void onPause() {
        super.onPause();
        try {
            this.mCamera.setPreviewCallback(null);
            this.mCameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.mCameraPreview);
            this.mCamera.stopPreview();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ViewGroup.LayoutParams layoutParamsDrawing = new ViewGroup.LayoutParams(-1, -1);
        this.getActivity().addContentView((View)this.drawingView, layoutParamsDrawing);
    }

    private void setFlashLayoutAndMode() {
        this.currentFlashMode.setOnClickListener((View.OnClickListener)this);
        String flashMode = PrefsUtils.getStringSharedPreference((Context)this.getActivity(), "flashMode", "");
        if (flashMode.equals("")) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_off);
        } else if (this.supportedFlashModes != null && this.supportedFlashModes.size() > 0) {
            if (this.supportedFlashModes.contains(flashMode)) {
                this.setFlash(flashMode);
            } else {
                this.setFlash(this.supportedFlashModes.get(0));
            }
        }
    }

    public void setFlash(String mode) {
        Camera.Parameters parameters = this.mCamera.getParameters();
        parameters.setFlashMode(mode);
        if ("off".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_off);
        } else if ("on".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_on);
        } else if ("auto".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_auto);
        } else if ("red-eye".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_red_eye);
        } else if ("torch".equals(mode)) {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_torch);
        } else {
            this.currentFlashMode.setImageResource(R.drawable.ic_flash_off);
        }
        PrefsUtils.setStringSharedPreference((Context)this.getActivity(), "flashMode", mode);
        this.mCamera.setParameters(parameters);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 99) {
                this.imagesList = (ArrayList)data.getSerializableExtra("galleryPhotos");
                if (this.imagesList != null && this.imagesList.size() > 0) {
                    this.buttonCapture.setTag((Object)"done");
                    this.onClick((View)this.buttonCapture);
                    if (this.enableCapturedReview) {
                        this.mPictureTakenListener.onPicturesFinalized(this.imagesList);
                        this.imagesList.clear();
                    }
                }
            } else if (requestCode == 100) {
                String capturedFilePath = "";
                this.mPictureTakenListener.onPictureTaken(capturedFilePath);
            }
        } else if (requestCode == 100) {
            this.readyToTakePicture = true;
            this.buttonCapture.setEnabled(true);
        } else if (requestCode != 101) {
            this.mActivity.setResult(resultCode);
            this.mActivity.finish();
        }
    }

    public void onResume() {
        super.onResume();
        if (this.mCamera == null) {
            try {
                if (!this.permissionAlreadyRequested && Build.VERSION.SDK_INT >= 23 && !NeonUtils.checkForPermission((Context)this.mActivity, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 104, "Camera and Storage")) {
                    this.permissionAlreadyRequested = true;
                    return;
                }
                if (this.cameraFacing == PhotoParams.CameraFacing.FRONT && NeonUtils.isFrontCameraAvailable() == 1) {
                    Log.d((String)TAG, (String)"onResume: open front");
                    this.mCamera = Camera.open((int)1);
                } else {
                    this.mCamera = Camera.open();
                }
                this.setCameraRotation();
                Log.d((String)TAG, (String)"onResume: setRotation ");
                Camera.Parameters parameters = this.mCamera.getParameters();
                this.createSupportedFlashList(parameters);
                this.setFlashLayoutAndMode();
                this.mCameraPreview = new CameraPreview(this.mActivity, this.mCamera);
                this.mCameraPreview.setReadyListener(new CameraPreview.ReadyToTakePicture(){

                    @Override
                    public void readyToTakePicture(boolean ready) {
                        CameraFragment.this.readyToTakePicture = ready;
                    }
                });
                this.mCameraPreview.setOnTouchListener(this);
                this.mCameraLayout = (FrameLayout)this.fragmentView.findViewById(R.id.camera_preview);
                this.mCameraLayout.addView((View)this.mCameraPreview);
                this.mActivity.getWindow().setFlags(1024, 1024);
                this.buttonCapture.setOnClickListener((View.OnClickListener)this);
                this.enableDoneButton(false);
                this.buttonGallery.setOnClickListener((View.OnClickListener)this);
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (CameraFragment.this.maxNumberOfImages == 0) {
                        CameraFragment.this.buttonDone.setVisibility(0);
                        CameraFragment.this.buttonDone.setOnClickListener((View.OnClickListener)CameraFragment.this);
                    }
                    if (CameraFragment.this.mPhotoParams.getImageName() != null && !"".equals(CameraFragment.this.mPhotoParams.getImageName())) {
                        CameraFragment.this.tvImageName.setVisibility(0);
                        CameraFragment.this.tvImageName.setText((CharSequence)String.valueOf(CameraFragment.this.mPhotoParams.getImageName()));
                        CameraFragment.this.tvImageName.setOnClickListener((View.OnClickListener)CameraFragment.this);
                    }
                }
            }, 1000L);
        } else {
            this.enableDoneButton(false);
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private void createSupportedFlashList(Camera.Parameters parameters) {
        this.supportedFlashModes = (ArrayList)parameters.getSupportedFlashModes();
        if (this.supportedFlashModes == null) {
            this.currentFlashMode.setVisibility(8);
            this.rcvFlash.setVisibility(8);
        } else {
            this.currentFlashMode.setVisibility(0);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.buttonCapture) {
            if (v.getTag().equals("capture")) {
                if (this.readyToTakePicture) {
                    if (this.mCamera != null) {
                        this.mCamera.takePicture(null, null, (Camera.PictureCallback)this);
                    }
                    this.readyToTakePicture = false;
                    if (this.maxNumberOfImages == 1) {
                        this.buttonGallery.setEnabled(false);
                    }
                    if (this.maxNumberOfImages > 1 || this.maxNumberOfImages == 0) {
                        this.buttonDone.setOnClickListener((View.OnClickListener)this);
                    }
                }
            } else if (v.getTag().equals("done")) {
                if (this.imagesList.size() > 0) {
                    this.mPictureTakenListener.onPicturesFinalized(this.imagesList);
                } else {
                    Toast.makeText((Context)this.mActivity, (CharSequence)this.getString(R.string.please_select_atleast_one), (int)0).show();
                }
            }
        } else if (v.getId() == R.id.buttonGallery) {
            Intent intent = new Intent((Context)this.mActivity, GalleryActivity.class);
            intent.setFlags(0x4000000);
            intent.putExtra("maxCount", this.maxNumberOfImages);
            intent.putExtra("photoParams", (Serializable)this.mPhotoParams);
            this.startActivityForResult(intent, 99);
        } else if (v.getId() == R.id.buttonDone) {
            if (this.imagesList.size() == 0) {
                Toast.makeText((Context)this.mActivity, (CharSequence)this.getString(R.string.no_images), (int)0).show();
            } else {
                this.buttonCapture.setTag((Object)"done");
                this.onClick((View)this.buttonCapture);
            }
        } else if (v.getId() == R.id.switchCamera) {
            int cameraFacing = this.initCameraId();
            if (cameraFacing == 0) {
                this.stopCamera();
                this.useFrontFacingCamera = true;
                this.startCamera(1);
            } else {
                this.stopCamera();
                this.useFrontFacingCamera = false;
                this.startCamera(0);
            }
        } else if (v.getId() == R.id.currentFlashMode) {
            if (this.rcvFlash.getVisibility() == 8) {
                this.createFlashModesDropDown();
            } else {
                this.rcvFlash.setVisibility(8);
            }
        }
    }

    private void createFlashModesDropDown() {
        FlashModeRecyclerHorizontalAdapter flashModeAdapter = new FlashModeRecyclerHorizontalAdapter((Context)this.getActivity(), this.supportedFlashModes);
        this.rcvFlash.setAdapter((RecyclerView.Adapter)flashModeAdapter);
        this.rcvFlash.setVisibility(0);
        flashModeAdapter.setOnItemClickListener(new FlashModeRecyclerHorizontalAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(View view, int position) {
                CameraFragment.this.setFlash((String)CameraFragment.this.supportedFlashModes.get(position));
                CameraFragment.this.rcvFlash.setVisibility(8);
            }
        });
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.mCamera != null) {
            Camera.Parameters params = this.mCamera.getParameters();
            int action = event.getAction();
            if (event.getPointerCount() > 1) {
                if (action == 5) {
                    this.mDist = this.getFingerSpacing(event);
                } else if (action == 2 && params.isZoomSupported()) {
                    this.mCamera.cancelAutoFocus();
                    this.handleZoom(event, params);
                }
            } else if (action == 1) {
                this.handleFocus(event, params);
            }
            if (event.getPointerCount() > 1) {
                return true;
            }
            final Rect focusRect = this.calculateTapArea(event.getX(), event.getY(), 1.0f);
            try {
                this.mCamera.autoFocus(null);
                this.drawingView.setHaveTouch(true, focusRect);
                this.drawingView.invalidate();
                new Handler().postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        CameraFragment.this.drawingView.setHaveTouch(false, focusRect);
                        CameraFragment.this.drawingView.invalidate();
                    }
                }, 1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void onPictureTaken(byte[] data, Camera camera) {
        new ImagePostProcessing((Context)this.mActivity, data).execute(new Void[0]);
    }

    private void updateCapturedPhotos(File pictureFile) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(pictureFile.getAbsolutePath());
        fileInfo.setFileName(pictureFile.getAbsolutePath().substring(pictureFile.getAbsolutePath().lastIndexOf("/") + 1));
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        this.imagesList.add(fileInfo);
        if (this.maxNumberOfImages == 1) {
            this.buttonCapture.setTag((Object)"done");
            this.onClick((View)this.buttonCapture);
        } else {
            Log.e((String)"Gallery", (String)"updateCapturedPhotos");
            if (this.imagesList.size() >= 1) {
                this.scrollView.setVisibility(0);
            } else {
                this.scrollView.setVisibility(8);
            }
            this.addInScrollView(fileInfo);
            if (this.maxNumberOfImages > 0) {
                this.updateView(this.imagesList.size() < this.maxNumberOfImages);
            }
            this.mCamera.startPreview();
            this.readyToTakePicture = true;
            this.buttonCapture.setEnabled(true);
        }
    }

    private void setCameraRotation() {
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)info);
        int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        int rotate = (info.orientation - degrees + 360) % 360;
        Camera.Parameters params = this.mCamera.getParameters();
        params.setRotation(rotate);
        this.mCamera.setParameters(params);
    }

    private void addInScrollView(ArrayList<FileInfo> infos) {
        if (infos != null && infos.size() > 0) {
            for (FileInfo info : infos) {
                this.scrollView.addView(this.createImageView(info));
            }
            this.scrollView.setVisibility(0);
        }
        Log.e((String)"Gallery", (String)"Add multiple items in scroll ");
    }

    private void addInScrollView(FileInfo info) {
        Log.e((String)"Gallery", (String)" add in scroll View ");
        this.scrollView.addView(this.createImageView(info));
        this.scrollView.setVisibility(0);
    }

    private View createImageView(final FileInfo info) {
        File file = new File(info.getFilePath());
        if (!file.exists()) {
            return null;
        }
        final View outerView = View.inflate((Context)this.getContext(), (int)R.layout.camera_priority_overlay, null);
        outerView.findViewById(R.id.ivRemoveImage).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraFragment.this.scrollView.removeView(outerView);
                CameraFragment.this.imagesList.remove(info);
                if (CameraFragment.this.maxNumberOfImages > 0) {
                    CameraFragment.this.updateView(CameraFragment.this.imagesList.size() < CameraFragment.this.maxNumberOfImages);
                }
                if (CameraFragment.this.imagesList.size() < 1) {
                    CameraFragment.this.buttonDone.setVisibility(8);
                    CameraFragment.this.scrollView.setVisibility(8);
                }
            }
        });
        Glide.with((Fragment)this).load("file://" + info.getFilePath()).diskCacheStrategy(DiskCacheStrategy.ALL).crossFade().centerCrop().placeholder(R.drawable.image_load_default_small).into((ImageView)outerView.findViewById(R.id.ivCaptured));
        return outerView;
    }

    private void setOrientation(Activity activity, PhotoParams.CameraOrientation orientation) {
        if (orientation != null) {
            if (orientation.equals((Object)PhotoParams.CameraOrientation.LANDSCAPE)) {
                activity.setRequestedOrientation(0);
            } else if (orientation.equals((Object)PhotoParams.CameraOrientation.PORTRAIT)) {
                activity.setRequestedOrientation(1);
            }
        } else {
            Log.e((String)"Gallery", (String)"No orientation set");
        }
    }

    private void updateView(boolean status) {
        if (!status) {
            this.buttonCapture.setVisibility(8);
        } else {
            this.buttonCapture.setVisibility(0);
        }
        this.buttonDone.setVisibility(0);
        this.tvImageName.setText((CharSequence)(status ? this.imageName : "Press Done"));
    }

    private void enableDoneButton(boolean enable) {
        this.buttonCapture.setImageResource(enable ? R.drawable.ic_camera_switch : R.drawable.ic_camera);
        this.buttonCapture.setTag((Object)(enable ? "done" : "capture"));
    }

    private Rect calculateTapArea(float x, float y, float coefficient) {
        int FOCUS_AREA_SIZE = 200;
        int areaSize = Float.valueOf((float)FOCUS_AREA_SIZE * coefficient).intValue();
        int left = this.clamp((int)x - areaSize / 2, 0, this.mCameraPreview.getWidth() - areaSize);
        int top = this.clamp((int)y - areaSize / 2, 0, this.mCameraPreview.getHeight() - areaSize);
        RectF rectF = new RectF((float)left, (float)top, (float)(left + areaSize), (float)(top + areaSize));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private void handleZoom(MotionEvent event, Camera.Parameters params) {
        int maxZoom = params.getMaxZoom();
        int zoom = params.getZoom();
        float newDist = this.getFingerSpacing(event);
        if (newDist > this.mDist) {
            if (zoom < maxZoom) {
                ++zoom;
            }
        } else if (newDist < this.mDist && zoom > 0) {
            --zoom;
        }
        this.mDist = newDist;
        params.setZoom(zoom);
        this.mCamera.setParameters(params);
    }

    public void handleFocus(MotionEvent event, Camera.Parameters params) {
        Log.d((String)TAG, (String)("handleFocus: " + event));
        List supportedFocusModes = params.getSupportedFocusModes();
        if (supportedFocusModes != null && supportedFocusModes.contains("auto")) {
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean b, Camera camera) {
                }
            });
        }
    }

    private float getFingerSpacing(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)Math.sqrt(x * x + y * y);
    }

    public void stopCamera() {
        try {
            if (null == this.mCamera) {
                return;
            }
            this.mCamera.setPreviewCallback(null);
            this.mCameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.mCameraPreview);
            this.mCamera.stopPreview();
            this.mCameraLayout.removeAllViews();
            this.mCamera.release();
            this.mCamera = null;
            this.mCameraPreview = null;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.stopCamera();
    }

    private void startCamera(int cameraFacing) {
        if (this.mCamera == null) {
            try {
                this.mCamera = Camera.open((int)cameraFacing);
                this.setCameraRotation();
                this.mCameraPreview = new CameraPreview(this.mActivity, this.mCamera);
                this.mCameraPreview.setReadyListener(new CameraPreview.ReadyToTakePicture(){

                    @Override
                    public void readyToTakePicture(boolean ready) {
                        CameraFragment.this.readyToTakePicture = ready;
                    }
                });
                this.mCameraPreview.setOnTouchListener(this);
                this.mCameraLayout = (FrameLayout)this.fragmentView.findViewById(R.id.camera_preview);
                this.mCameraLayout.addView((View)this.mCameraPreview);
                this.mActivity.getWindow().setFlags(1024, 1024);
                this.buttonCapture.setOnClickListener((View.OnClickListener)this);
                this.enableDoneButton(false);
                this.buttonGallery.setOnClickListener((View.OnClickListener)this);
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
        } else {
            this.enableDoneButton(false);
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private int initCameraId() {
        int count = Camera.getNumberOfCameras();
        int result = -1;
        if (count > 0) {
            result = 0;
            Camera.CameraInfo info = new Camera.CameraInfo();
            for (int i = 0; i < count; ++i) {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                if (info.facing == 0 && !this.useFrontFacingCamera) {
                    result = i;
                    break;
                }
                if (info.facing != 1 || !this.useFrontFacingCamera) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    public int setPhotoOrientation(Activity activity, int cameraId) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    private int getBackFacingCameraId() {
        int cameraId = -1;
        int numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                cameraId = i;
                break;
            }
            if (info.facing != 0) continue;
            cameraId = i;
            break;
        }
        return cameraId;
    }

    private class ImagePostProcessing
    extends AsyncTask<Void, Void, File> {
        private Context context;
        private byte[] data;
        private ProgressDialog progressDialog;

        ImagePostProcessing(Context context, byte[] data) {
            this.context = context;
            this.data = data;
        }

        protected File doInBackground(Void ... params) {
            File pictureFile = Constants.getMediaOutputFile((Context)CameraFragment.this.getActivity(), 1);
            if (pictureFile == null) {
                return null;
            }
            try {
                Bitmap bm;
                FileOutputStream fos = new FileOutputStream(pictureFile);
                if (this.data != null) {
                    int screenWidth = CameraFragment.this.getResources().getDisplayMetrics().widthPixels;
                    int screenHeight = CameraFragment.this.getResources().getDisplayMetrics().heightPixels;
                    bm = BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)(this.data != null ? this.data.length : 0));
                    if (CameraFragment.this.getResources().getConfiguration().orientation == 1) {
                        Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                        int w = scaled.getWidth();
                        int h = scaled.getHeight();
                        Matrix mtx = new Matrix();
                        int cameraId = CameraFragment.this.cameraFacing == PhotoParams.CameraFacing.FRONT ? CameraFragment.this.getBackFacingCameraId() : CameraFragment.this.initCameraId();
                        int CameraEyeValue = CameraFragment.this.setPhotoOrientation((Activity)CameraFragment.this.getActivity(), cameraId);
                        if (cameraId == 1) {
                            if (CameraEyeValue == 270) {
                                mtx.postRotate(90.0f);
                            } else if (CameraEyeValue == 90) {
                                mtx.postRotate(270.0f);
                            }
                        } else {
                            mtx.postRotate((float)CameraEyeValue);
                        }
                        bm = Bitmap.createBitmap((Bitmap)scaled, (int)0, (int)0, (int)w, (int)h, (Matrix)mtx, (boolean)true);
                    } else {
                        bm = Bitmap.createScaledBitmap((Bitmap)bm, (int)screenWidth, (int)screenHeight, (boolean)true);
                    }
                } else {
                    return null;
                }
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
                byte[] byteArray = stream.toByteArray();
                fos.write(byteArray);
                fos.close();
                Uri pictureFileUri = Uri.parse((String)("file://" + pictureFile.getAbsolutePath()));
                CameraFragment.this.mActivity.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", pictureFileUri));
            }
            catch (FileNotFoundException e) {
                Log.d((String)CameraFragment.TAG, (String)("File not found: " + e.getMessage()));
            }
            catch (IOException e) {
                Log.d((String)CameraFragment.TAG, (String)("Error accessing file: " + e.getMessage()));
            }
            CameraFragment.this.mCamera.startPreview();
            return pictureFile;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.progressDialog = ProgressDialog.show((Context)this.context, null, (CharSequence)"Saving Picture", (boolean)true);
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            if (this.progressDialog != null) {
                this.progressDialog.dismiss();
            }
            if (file != null) {
                if (!CameraFragment.this.enableCapturedReview || CameraFragment.this.mPhotoParams.getMode() == PhotoParams.MODE.NEUTRAL) {
                    CameraFragment.this.updateCapturedPhotos(file);
                    return;
                }
                CameraFragment.this.mPictureTakenListener.sendPictureForCropping(file);
                CameraFragment.this.mCamera.startPreview();
            } else {
                Toast.makeText((Context)this.context, (CharSequence)"Camera Error. Kindly try again", (int)0).show();
                CameraFragment.this.readyToTakePicture = true;
                CameraFragment.this.buttonCapture.setEnabled(true);
                CameraFragment.this.mCamera.startPreview();
            }
        }
    }

    public static interface PictureTakenListener {
        public void onPictureTaken(String var1);

        public void onPicturesFinalized(ArrayList<FileInfo> var1);

        public void sendPictureForCropping(File var1);
    }
}

