/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.dynamicgrid;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.gaadi.neon.dynamicgrid.DynamicGridAdapterInterface;
import com.gaadi.neon.dynamicgrid.DynamicGridUtils;
import com.scanlibrary.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class DynamicGridView
extends GridView {
    private static final int INVALID_ID = -1;
    private static final int MOVE_DURATION = 300;
    private static final int SMOOTH_SCROLL_AMOUNT_AT_EDGE = 8;
    private BitmapDrawable mHoverCell;
    private Rect mHoverCellCurrentBounds;
    private Rect mHoverCellOriginalBounds;
    private int mTotalOffsetY = 0;
    private int mTotalOffsetX = 0;
    private int mDownX = -1;
    private int mDownY = -1;
    private int mLastEventY = -1;
    private int mLastEventX = -1;
    private int mOverlapIfSwitchStraightLine;
    private List<Long> idList = new ArrayList<Long>();
    private long mMobileItemId = -1L;
    private boolean mCellIsMobile = false;
    private int mActivePointerId = -1;
    private boolean mIsMobileScrolling;
    private int mSmoothScrollAmountAtEdge = 0;
    private boolean mIsWaitingForScrollFinish = false;
    private int mScrollState = 0;
    private boolean mIsEditMode = false;
    private List<ObjectAnimator> mWobbleAnimators = new LinkedList<ObjectAnimator>();
    private boolean mHoverAnimation;
    private boolean mReorderAnimation;
    private boolean mWobbleInEditMode = true;
    private boolean mIsEditModeEnabled = true;
    private AbsListView.OnScrollListener mUserScrollListener;
    private OnDropListener mDropListener;
    private OnDragListener mDragListener;
    private OnEditModeChangeListener mEditModeChangeListener;
    private AdapterView.OnItemClickListener mUserItemClickListener;
    private AdapterView.OnItemClickListener mLocalItemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            if (!DynamicGridView.this.isEditMode() && DynamicGridView.this.isEnabled() && DynamicGridView.this.mUserItemClickListener != null) {
                DynamicGridView.this.mUserItemClickListener.onItemClick(parent, view, position, id2);
            }
        }
    };
    private boolean mUndoSupportEnabled;
    private Stack<DynamicGridModification> mModificationStack;
    private DynamicGridModification mCurrentModification;
    private OnSelectedItemBitmapCreationListener mSelectedItemBitmapCreationListener;
    private View mMobileView;
    private AbsListView.OnScrollListener mScrollListener = new AbsListView.OnScrollListener(){
        private int mPreviousFirstVisibleItem = -1;
        private int mPreviousVisibleItemCount = -1;
        private int mCurrentFirstVisibleItem;
        private int mCurrentVisibleItemCount;
        private int mCurrentScrollState;

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            this.mCurrentFirstVisibleItem = firstVisibleItem;
            this.mCurrentVisibleItemCount = visibleItemCount;
            this.mPreviousFirstVisibleItem = this.mPreviousFirstVisibleItem == -1 ? this.mCurrentFirstVisibleItem : this.mPreviousFirstVisibleItem;
            this.mPreviousVisibleItemCount = this.mPreviousVisibleItemCount == -1 ? this.mCurrentVisibleItemCount : this.mPreviousVisibleItemCount;
            this.checkAndHandleFirstVisibleCellChange();
            this.checkAndHandleLastVisibleCellChange();
            this.mPreviousFirstVisibleItem = this.mCurrentFirstVisibleItem;
            this.mPreviousVisibleItemCount = this.mCurrentVisibleItemCount;
            if (DynamicGridView.this.isPostHoneycomb() && DynamicGridView.this.mWobbleInEditMode) {
                this.updateWobbleState(visibleItemCount);
            }
            if (DynamicGridView.this.mUserScrollListener != null) {
                DynamicGridView.this.mUserScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
        }

        @TargetApi(value=11)
        private void updateWobbleState(int visibleItemCount) {
            for (int i = 0; i < visibleItemCount; ++i) {
                View child = DynamicGridView.this.getChildAt(i);
                if (child == null) continue;
                if (DynamicGridView.this.mMobileItemId != -1L && Boolean.TRUE != child.getTag(R.id.dgv_wobble_tag)) {
                    if (i % 2 == 0) {
                        DynamicGridView.this.animateWobble(child);
                    } else {
                        DynamicGridView.this.animateWobbleInverse(child);
                    }
                    child.setTag(R.id.dgv_wobble_tag, (Object)true);
                    continue;
                }
                if (DynamicGridView.this.mMobileItemId != -1L || child.getRotation() == 0.0f) continue;
                child.setRotation(0.0f);
                child.setTag(R.id.dgv_wobble_tag, (Object)false);
            }
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            this.mCurrentScrollState = scrollState;
            DynamicGridView.this.mScrollState = scrollState;
            this.isScrollCompleted();
            if (DynamicGridView.this.mUserScrollListener != null) {
                DynamicGridView.this.mUserScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        private void isScrollCompleted() {
            if (this.mCurrentVisibleItemCount > 0 && this.mCurrentScrollState == 0) {
                if (DynamicGridView.this.mCellIsMobile && DynamicGridView.this.mIsMobileScrolling) {
                    DynamicGridView.this.handleMobileCellScroll();
                } else if (DynamicGridView.this.mIsWaitingForScrollFinish) {
                    DynamicGridView.this.touchEventsEnded();
                }
            }
        }

        public void checkAndHandleFirstVisibleCellChange() {
            if (this.mCurrentFirstVisibleItem != this.mPreviousFirstVisibleItem && DynamicGridView.this.mCellIsMobile && DynamicGridView.this.mMobileItemId != -1L) {
                DynamicGridView.this.updateNeighborViewsForId(DynamicGridView.this.mMobileItemId);
                DynamicGridView.this.handleCellSwitch();
            }
        }

        public void checkAndHandleLastVisibleCellChange() {
            int currentLastVisibleItem = this.mCurrentFirstVisibleItem + this.mCurrentVisibleItemCount;
            int previousLastVisibleItem = this.mPreviousFirstVisibleItem + this.mPreviousVisibleItemCount;
            if (currentLastVisibleItem != previousLastVisibleItem && DynamicGridView.this.mCellIsMobile && DynamicGridView.this.mMobileItemId != -1L) {
                DynamicGridView.this.updateNeighborViewsForId(DynamicGridView.this.mMobileItemId);
                DynamicGridView.this.handleCellSwitch();
            }
        }
    };

    public DynamicGridView(Context context) {
        super(context);
        this.init(context);
    }

    public DynamicGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public DynamicGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public static boolean isPreLollipop() {
        return Build.VERSION.SDK_INT < 21;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener scrollListener) {
        this.mUserScrollListener = scrollListener;
    }

    public void setOnDropListener(OnDropListener dropListener) {
        this.mDropListener = dropListener;
    }

    public void setOnDragListener(OnDragListener dragListener) {
        this.mDragListener = dragListener;
    }

    public void startEditMode() {
        this.startEditMode(-1);
    }

    public void startEditMode(int position) {
        if (!this.mIsEditModeEnabled) {
            return;
        }
        this.requestDisallowInterceptTouchEvent(true);
        if (this.isPostHoneycomb() && this.mWobbleInEditMode) {
            this.startWobbleAnimation();
        }
        if (position != -1) {
            this.startDragAtPosition(position);
        }
        this.mIsEditMode = true;
        if (this.mEditModeChangeListener != null) {
            this.mEditModeChangeListener.onEditModeChanged(true);
        }
    }

    public void stopEditMode() {
        this.mIsEditMode = false;
        this.requestDisallowInterceptTouchEvent(false);
        if (this.isPostHoneycomb() && this.mWobbleInEditMode) {
            this.stopWobble(true);
        }
        if (this.mEditModeChangeListener != null) {
            this.mEditModeChangeListener.onEditModeChanged(false);
        }
    }

    public boolean isEditModeEnabled() {
        return this.mIsEditModeEnabled;
    }

    public void setEditModeEnabled(boolean enabled) {
        this.mIsEditModeEnabled = enabled;
    }

    public void setOnEditModeChangeListener(OnEditModeChangeListener editModeChangeListener) {
        this.mEditModeChangeListener = editModeChangeListener;
    }

    public boolean isEditMode() {
        return this.mIsEditMode;
    }

    public boolean isWobbleInEditMode() {
        return this.mWobbleInEditMode;
    }

    public void setWobbleInEditMode(boolean wobbleInEditMode) {
        this.mWobbleInEditMode = wobbleInEditMode;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener listener) {
        this.mUserItemClickListener = listener;
        super.setOnItemClickListener(this.mLocalItemClickListener);
    }

    public boolean isUndoSupportEnabled() {
        return this.mUndoSupportEnabled;
    }

    public void setUndoSupportEnabled(boolean undoSupportEnabled) {
        if (this.mUndoSupportEnabled != undoSupportEnabled) {
            this.mModificationStack = undoSupportEnabled ? new Stack() : null;
        }
        this.mUndoSupportEnabled = undoSupportEnabled;
    }

    public void undoLastModification() {
        if (this.mUndoSupportEnabled && this.mModificationStack != null && !this.mModificationStack.isEmpty()) {
            DynamicGridModification modification = this.mModificationStack.pop();
            this.undoModification(modification);
        }
    }

    public void undoAllModifications() {
        if (this.mUndoSupportEnabled && this.mModificationStack != null && !this.mModificationStack.isEmpty()) {
            while (!this.mModificationStack.isEmpty()) {
                DynamicGridModification modification = this.mModificationStack.pop();
                this.undoModification(modification);
            }
        }
    }

    public boolean hasModificationHistory() {
        return this.mUndoSupportEnabled && this.mModificationStack != null && !this.mModificationStack.isEmpty();
    }

    public void clearModificationHistory() {
        this.mModificationStack.clear();
    }

    public void setOnSelectedItemBitmapCreationListener(OnSelectedItemBitmapCreationListener selectedItemBitmapCreationListener) {
        this.mSelectedItemBitmapCreationListener = selectedItemBitmapCreationListener;
    }

    private void undoModification(DynamicGridModification modification) {
        for (Pair<Integer, Integer> transition : modification.getTransitions()) {
            this.reorderElements((Integer)transition.second, (Integer)transition.first);
        }
    }

    @TargetApi(value=11)
    private void startWobbleAnimation() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            if (v == null || Boolean.TRUE == v.getTag(R.id.dgv_wobble_tag)) continue;
            if (i % 2 == 0) {
                this.animateWobble(v);
            } else {
                this.animateWobbleInverse(v);
            }
            v.setTag(R.id.dgv_wobble_tag, (Object)true);
        }
    }

    @TargetApi(value=11)
    private void stopWobble(boolean resetRotation) {
        for (Animator animator : this.mWobbleAnimators) {
            animator.cancel();
        }
        this.mWobbleAnimators.clear();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view == null) continue;
            if (resetRotation) {
                view.setRotation(0.0f);
            }
            view.setTag(R.id.dgv_wobble_tag, (Object)false);
        }
    }

    @TargetApi(value=11)
    private void restartWobble() {
        this.stopWobble(false);
        this.startWobbleAnimation();
    }

    public void init(Context context) {
        super.setOnScrollListener(this.mScrollListener);
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        this.mSmoothScrollAmountAtEdge = (int)(8.0f * metrics.density + 0.5f);
        this.mOverlapIfSwitchStraightLine = this.getResources().getDimensionPixelSize(R.dimen.dgv_overlap_if_switch_straight_line);
    }

    @TargetApi(value=11)
    private void animateWobble(View v) {
        ObjectAnimator animator = this.createBaseWobble(v);
        animator.setFloatValues(new float[]{-2.0f, 2.0f});
        animator.start();
        this.mWobbleAnimators.add(animator);
    }

    @TargetApi(value=11)
    private void animateWobbleInverse(View v) {
        ObjectAnimator animator = this.createBaseWobble(v);
        animator.setFloatValues(new float[]{2.0f, -2.0f});
        animator.start();
        this.mWobbleAnimators.add(animator);
    }

    @TargetApi(value=11)
    private ObjectAnimator createBaseWobble(final View v) {
        if (!DynamicGridView.isPreLollipop()) {
            v.setLayerType(1, null);
        }
        ObjectAnimator animator = new ObjectAnimator();
        animator.setDuration(180L);
        animator.setRepeatMode(2);
        animator.setRepeatCount(-1);
        animator.setPropertyName("rotation");
        animator.setTarget((Object)v);
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                v.setLayerType(0, null);
            }
        });
        return animator;
    }

    private void reorderElements(int originalPosition, int targetPosition) {
        if (this.mDragListener != null) {
            this.mDragListener.onDragPositionsChanged(originalPosition, targetPosition);
        }
        this.getAdapterInterface().reorderItems(originalPosition, targetPosition);
    }

    private int getColumnCount() {
        return this.getAdapterInterface().getColumnCount();
    }

    private DynamicGridAdapterInterface getAdapterInterface() {
        return (DynamicGridAdapterInterface)this.getAdapter();
    }

    private BitmapDrawable getAndAddHoverView(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        int top = v.getTop();
        int left = v.getLeft();
        Bitmap b = this.getBitmapFromView(v);
        BitmapDrawable drawable2 = new BitmapDrawable(this.getResources(), b);
        this.mHoverCellOriginalBounds = new Rect(left, top, left + w, top + h);
        this.mHoverCellCurrentBounds = new Rect(this.mHoverCellOriginalBounds);
        drawable2.setBounds(this.mHoverCellCurrentBounds);
        return drawable2;
    }

    private Bitmap getBitmapFromView(View v) {
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_4444);
            Canvas canvas = new Canvas(bitmap);
            v.draw(canvas);
            return bitmap;
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void updateNeighborViewsForId(long itemId) {
        this.idList.clear();
        int draggedPos = this.getPositionForID(itemId);
        for (int pos = this.getFirstVisiblePosition(); pos <= this.getLastVisiblePosition(); ++pos) {
            if (draggedPos == pos || !this.getAdapterInterface().canReorder(pos)) continue;
            this.idList.add(this.getId(pos));
        }
    }

    public int getPositionForID(long itemId) {
        View v = this.getViewForId(itemId);
        if (v == null) {
            return -1;
        }
        return this.getPositionForView(v);
    }

    public View getViewForId(long itemId) {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        ListAdapter adapter = this.getAdapter();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            int position = firstVisiblePosition + i;
            long id2 = adapter.getItemId(position);
            if (id2 != itemId) continue;
            return v;
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mDownX = (int)event.getX();
                this.mDownY = (int)event.getY();
                this.mActivePointerId = event.getPointerId(0);
                if (this.mIsEditMode && this.isEnabled()) {
                    this.layoutChildren();
                    int position = this.pointToPosition(this.mDownX, this.mDownY);
                    this.startDragAtPosition(position);
                    break;
                }
                if (this.isEnabled()) break;
                return false;
            }
            case 2: {
                if (this.mActivePointerId == -1) break;
                int pointerIndex = event.findPointerIndex(this.mActivePointerId);
                this.mLastEventY = (int)event.getY(pointerIndex);
                this.mLastEventX = (int)event.getX(pointerIndex);
                int deltaY = this.mLastEventY - this.mDownY;
                int deltaX = this.mLastEventX - this.mDownX;
                if (!this.mCellIsMobile) break;
                this.mHoverCellCurrentBounds.offsetTo(this.mHoverCellOriginalBounds.left + deltaX + this.mTotalOffsetX, this.mHoverCellOriginalBounds.top + deltaY + this.mTotalOffsetY);
                this.mHoverCell.setBounds(this.mHoverCellCurrentBounds);
                this.invalidate();
                this.handleCellSwitch();
                this.mIsMobileScrolling = false;
                this.handleMobileCellScroll();
                return false;
            }
            case 1: {
                this.touchEventsEnded();
                if (this.mUndoSupportEnabled && this.mCurrentModification != null && !this.mCurrentModification.getTransitions().isEmpty()) {
                    this.mModificationStack.push(this.mCurrentModification);
                    this.mCurrentModification = new DynamicGridModification();
                }
                if (this.mHoverCell == null || this.mDropListener == null) break;
                this.mDropListener.onActionDrop();
                break;
            }
            case 3: {
                this.touchEventsCancelled();
                if (this.mHoverCell == null || this.mDropListener == null) break;
                this.mDropListener.onActionDrop();
                break;
            }
            case 6: {
                int pointerIndex = (event.getAction() & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                this.touchEventsEnded();
                break;
            }
        }
        return super.onTouchEvent(event);
    }

    private void startDragAtPosition(int position) {
        this.mTotalOffsetY = 0;
        this.mTotalOffsetX = 0;
        int itemNum = position - this.getFirstVisiblePosition();
        View selectedView = this.getChildAt(itemNum);
        if (selectedView != null) {
            this.mMobileItemId = this.getAdapter().getItemId(position);
            if (this.mSelectedItemBitmapCreationListener != null) {
                this.mSelectedItemBitmapCreationListener.onPreSelectedItemBitmapCreation(selectedView, position, this.mMobileItemId);
            }
            this.mHoverCell = this.getAndAddHoverView(selectedView);
            if (this.mSelectedItemBitmapCreationListener != null) {
                this.mSelectedItemBitmapCreationListener.onPostSelectedItemBitmapCreation(selectedView, position, this.mMobileItemId);
            }
            if (this.isPostHoneycomb()) {
                selectedView.setVisibility(4);
            }
            this.mCellIsMobile = true;
            this.updateNeighborViewsForId(this.mMobileItemId);
            if (this.mDragListener != null) {
                this.mDragListener.onDragStarted(position);
            }
        }
    }

    private void handleMobileCellScroll() {
        this.mIsMobileScrolling = this.handleMobileCellScroll(this.mHoverCellCurrentBounds);
    }

    public boolean handleMobileCellScroll(Rect r) {
        int offset = this.computeVerticalScrollOffset();
        int height = this.getHeight();
        int extent = this.computeVerticalScrollExtent();
        int range = this.computeVerticalScrollRange();
        int hoverViewTop = r.top;
        int hoverHeight = r.height();
        if (hoverViewTop <= 0 && offset > 0) {
            this.smoothScrollBy(-this.mSmoothScrollAmountAtEdge, 0);
            return true;
        }
        if (hoverViewTop + hoverHeight >= height && offset + extent < range) {
            this.smoothScrollBy(this.mSmoothScrollAmountAtEdge, 0);
            return true;
        }
        return false;
    }

    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
    }

    private void touchEventsEnded() {
        View mobileView = this.getViewForId(this.mMobileItemId);
        if (mobileView != null && (this.mCellIsMobile || this.mIsWaitingForScrollFinish)) {
            this.mCellIsMobile = false;
            this.mIsWaitingForScrollFinish = false;
            this.mIsMobileScrolling = false;
            this.mActivePointerId = -1;
            if (this.mScrollState != 0) {
                this.mIsWaitingForScrollFinish = true;
                return;
            }
            this.mHoverCellCurrentBounds.offsetTo(mobileView.getLeft(), mobileView.getTop());
            if (Build.VERSION.SDK_INT > 11) {
                this.animateBounds(mobileView);
            } else {
                this.mHoverCell.setBounds(this.mHoverCellCurrentBounds);
                this.invalidate();
                this.reset(mobileView);
            }
        } else {
            this.touchEventsCancelled();
        }
    }

    @TargetApi(value=11)
    private void animateBounds(final View mobileView) {
        TypeEvaluator<Rect> sBoundEvaluator = new TypeEvaluator<Rect>(){

            public Rect evaluate(float fraction, Rect startValue, Rect endValue) {
                return new Rect(this.interpolate(startValue.left, endValue.left, fraction), this.interpolate(startValue.top, endValue.top, fraction), this.interpolate(startValue.right, endValue.right, fraction), this.interpolate(startValue.bottom, endValue.bottom, fraction));
            }

            public int interpolate(int start, int end, float fraction) {
                return (int)((float)start + fraction * (float)(end - start));
            }
        };
        ObjectAnimator hoverViewAnimator = ObjectAnimator.ofObject((Object)this.mHoverCell, (String)"bounds", (TypeEvaluator)sBoundEvaluator, (Object[])new Object[]{this.mHoverCellCurrentBounds});
        hoverViewAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                DynamicGridView.this.invalidate();
            }
        });
        hoverViewAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                DynamicGridView.this.mHoverAnimation = true;
                DynamicGridView.this.updateEnableState();
            }

            public void onAnimationEnd(Animator animation) {
                DynamicGridView.this.mHoverAnimation = false;
                DynamicGridView.this.updateEnableState();
                DynamicGridView.this.reset(mobileView);
            }
        });
        hoverViewAnimator.start();
    }

    private void reset(View mobileView) {
        this.idList.clear();
        this.mMobileItemId = -1L;
        mobileView.setVisibility(0);
        this.mHoverCell = null;
        if (this.isPostHoneycomb() && this.mWobbleInEditMode) {
            if (this.mIsEditMode) {
                this.restartWobble();
            } else {
                this.stopWobble(true);
            }
        }
        for (int i = 0; i < this.getLastVisiblePosition() - this.getFirstVisiblePosition(); ++i) {
            View child = this.getChildAt(i);
            if (child == null) continue;
            child.setVisibility(0);
        }
        this.invalidate();
    }

    private void updateEnableState() {
        this.setEnabled(!this.mHoverAnimation && !this.mReorderAnimation);
    }

    private boolean isPostHoneycomb() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private void touchEventsCancelled() {
        View mobileView = this.getViewForId(this.mMobileItemId);
        if (this.mCellIsMobile) {
            this.reset(mobileView);
        }
        this.mCellIsMobile = false;
        this.mIsMobileScrolling = false;
        this.mActivePointerId = -1;
    }

    private void handleCellSwitch() {
        int deltaY = this.mLastEventY - this.mDownY;
        int deltaX = this.mLastEventX - this.mDownX;
        int deltaYTotal = this.mHoverCellOriginalBounds.centerY() + this.mTotalOffsetY + deltaY;
        int deltaXTotal = this.mHoverCellOriginalBounds.centerX() + this.mTotalOffsetX + deltaX;
        this.mMobileView = this.getViewForId(this.mMobileItemId);
        View targetView = null;
        float vX = 0.0f;
        float vY = 0.0f;
        Point mobileColumnRowPair = this.getColumnAndRowForView(this.mMobileView);
        for (Long id2 : this.idList) {
            Point targetColumnRowPair;
            View view = this.getViewForId(id2);
            if (view == null || !(this.aboveRight(targetColumnRowPair = this.getColumnAndRowForView(view), mobileColumnRowPair) && deltaYTotal < view.getBottom() && deltaXTotal > view.getLeft() || this.aboveLeft(targetColumnRowPair, mobileColumnRowPair) && deltaYTotal < view.getBottom() && deltaXTotal < view.getRight() || this.belowRight(targetColumnRowPair, mobileColumnRowPair) && deltaYTotal > view.getTop() && deltaXTotal > view.getLeft() || this.belowLeft(targetColumnRowPair, mobileColumnRowPair) && deltaYTotal > view.getTop() && deltaXTotal < view.getRight() || this.above(targetColumnRowPair, mobileColumnRowPair) && deltaYTotal < view.getBottom() - this.mOverlapIfSwitchStraightLine || this.below(targetColumnRowPair, mobileColumnRowPair) && deltaYTotal > view.getTop() + this.mOverlapIfSwitchStraightLine || this.right(targetColumnRowPair, mobileColumnRowPair) && deltaXTotal > view.getLeft() + this.mOverlapIfSwitchStraightLine) && (!this.left(targetColumnRowPair, mobileColumnRowPair) || deltaXTotal >= view.getRight() - this.mOverlapIfSwitchStraightLine)) continue;
            float xDiff = Math.abs(DynamicGridUtils.getViewX(view) - DynamicGridUtils.getViewX(this.mMobileView));
            float yDiff = Math.abs(DynamicGridUtils.getViewY(view) - DynamicGridUtils.getViewY(this.mMobileView));
            if (!(xDiff >= vX) || !(yDiff >= vY)) continue;
            vX = xDiff;
            vY = yDiff;
            targetView = view;
        }
        if (targetView != null) {
            int originalPosition = this.getPositionForView(this.mMobileView);
            int targetPosition = this.getPositionForView(targetView);
            DynamicGridAdapterInterface adapter = this.getAdapterInterface();
            if (targetPosition == -1 || !adapter.canReorder(originalPosition) || !adapter.canReorder(targetPosition)) {
                this.updateNeighborViewsForId(this.mMobileItemId);
                return;
            }
            this.reorderElements(originalPosition, targetPosition);
            if (this.mUndoSupportEnabled) {
                this.mCurrentModification.addTransition(originalPosition, targetPosition);
            }
            this.mDownY = this.mLastEventY;
            this.mDownX = this.mLastEventX;
            SwitchCellAnimator switchCellAnimator = this.isPostHoneycomb() && DynamicGridView.isPreLollipop() ? new KitKatSwitchCellAnimator(deltaX, deltaY) : (DynamicGridView.isPreLollipop() ? new PreHoneycombCellAnimator(deltaX, deltaY) : new LSwitchCellAnimator(deltaX, deltaY));
            this.updateNeighborViewsForId(this.mMobileItemId);
            switchCellAnimator.animateSwitchCell(originalPosition, targetPosition);
        }
    }

    private boolean belowLeft(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y > mobileColumnRowPair.y && targetColumnRowPair.x < mobileColumnRowPair.x;
    }

    private boolean belowRight(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y > mobileColumnRowPair.y && targetColumnRowPair.x > mobileColumnRowPair.x;
    }

    private boolean aboveLeft(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y < mobileColumnRowPair.y && targetColumnRowPair.x < mobileColumnRowPair.x;
    }

    private boolean aboveRight(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y < mobileColumnRowPair.y && targetColumnRowPair.x > mobileColumnRowPair.x;
    }

    private boolean above(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y < mobileColumnRowPair.y && targetColumnRowPair.x == mobileColumnRowPair.x;
    }

    private boolean below(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y > mobileColumnRowPair.y && targetColumnRowPair.x == mobileColumnRowPair.x;
    }

    private boolean right(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y == mobileColumnRowPair.y && targetColumnRowPair.x > mobileColumnRowPair.x;
    }

    private boolean left(Point targetColumnRowPair, Point mobileColumnRowPair) {
        return targetColumnRowPair.y == mobileColumnRowPair.y && targetColumnRowPair.x < mobileColumnRowPair.x;
    }

    private Point getColumnAndRowForView(View view) {
        int pos = this.getPositionForView(view);
        int columns = this.getColumnCount();
        int column = pos % columns;
        int row = pos / columns;
        return new Point(column, row);
    }

    private long getId(int position) {
        return this.getAdapter().getItemId(position);
    }

    @TargetApi(value=11)
    private void animateReorder(int oldPosition, int newPosition) {
        int pos;
        boolean isForward = newPosition > oldPosition;
        LinkedList<AnimatorSet> resultList = new LinkedList<AnimatorSet>();
        if (isForward) {
            for (pos = Math.min(oldPosition, newPosition); pos < Math.max(oldPosition, newPosition); ++pos) {
                View view = this.getViewForId(this.getId(pos));
                if ((pos + 1) % this.getColumnCount() == 0) {
                    resultList.add(this.createTranslationAnimations(view, -view.getWidth() * (this.getColumnCount() - 1), 0.0f, view.getHeight(), 0.0f));
                    continue;
                }
                resultList.add(this.createTranslationAnimations(view, view.getWidth(), 0.0f, 0.0f, 0.0f));
            }
        } else {
            for (pos = Math.max(oldPosition, newPosition); pos > Math.min(oldPosition, newPosition); --pos) {
                View view = this.getViewForId(this.getId(pos));
                if ((pos + this.getColumnCount()) % this.getColumnCount() == 0) {
                    resultList.add(this.createTranslationAnimations(view, view.getWidth() * (this.getColumnCount() - 1), 0.0f, -view.getHeight(), 0.0f));
                    continue;
                }
                resultList.add(this.createTranslationAnimations(view, -view.getWidth(), 0.0f, 0.0f, 0.0f));
            }
        }
        AnimatorSet resultSet = new AnimatorSet();
        resultSet.playTogether(resultList);
        resultSet.setDuration(300L);
        resultSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        resultSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                DynamicGridView.this.mReorderAnimation = true;
                DynamicGridView.this.updateEnableState();
            }

            public void onAnimationEnd(Animator animation) {
                DynamicGridView.this.mReorderAnimation = false;
                DynamicGridView.this.updateEnableState();
            }
        });
        resultSet.start();
    }

    @TargetApi(value=11)
    private AnimatorSet createTranslationAnimations(View view, float startX, float endX, float startY, float endY) {
        ObjectAnimator animX = ObjectAnimator.ofFloat((Object)view, (String)"translationX", (float[])new float[]{startX, endX});
        ObjectAnimator animY = ObjectAnimator.ofFloat((Object)view, (String)"translationY", (float[])new float[]{startY, endY});
        AnimatorSet animSetXY = new AnimatorSet();
        animSetXY.playTogether(new Animator[]{animX, animY});
        return animSetXY;
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHoverCell != null) {
            this.mHoverCell.draw(canvas);
        }
    }

    private class LSwitchCellAnimator
    implements SwitchCellAnimator {
        private int mDeltaY;
        private int mDeltaX;

        public LSwitchCellAnimator(int deltaX, int deltaY) {
            this.mDeltaX = deltaX;
            this.mDeltaY = deltaY;
        }

        @Override
        public void animateSwitchCell(int originalPosition, int targetPosition) {
            DynamicGridView.this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new AnimateSwitchViewOnPreDrawListener(originalPosition, targetPosition));
        }

        private class AnimateSwitchViewOnPreDrawListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final int mOriginalPosition;
            private final int mTargetPosition;

            AnimateSwitchViewOnPreDrawListener(int originalPosition, int targetPosition) {
                this.mOriginalPosition = originalPosition;
                this.mTargetPosition = targetPosition;
            }

            public boolean onPreDraw() {
                DynamicGridView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                DynamicGridView.this.mTotalOffsetY = DynamicGridView.this.mTotalOffsetY + LSwitchCellAnimator.this.mDeltaY;
                DynamicGridView.this.mTotalOffsetX = DynamicGridView.this.mTotalOffsetX + LSwitchCellAnimator.this.mDeltaX;
                DynamicGridView.this.animateReorder(this.mOriginalPosition, this.mTargetPosition);
                assert (DynamicGridView.this.mMobileView != null);
                DynamicGridView.this.mMobileView.setVisibility(0);
                DynamicGridView.this.mMobileView = DynamicGridView.this.getViewForId(DynamicGridView.this.mMobileItemId);
                assert (DynamicGridView.this.mMobileView != null);
                DynamicGridView.this.mMobileView.setVisibility(4);
                return true;
            }
        }
    }

    private class KitKatSwitchCellAnimator
    implements SwitchCellAnimator {
        private int mDeltaY;
        private int mDeltaX;

        public KitKatSwitchCellAnimator(int deltaX, int deltaY) {
            this.mDeltaX = deltaX;
            this.mDeltaY = deltaY;
        }

        @Override
        public void animateSwitchCell(int originalPosition, int targetPosition) {
            assert (DynamicGridView.this.mMobileView != null);
            DynamicGridView.this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)new AnimateSwitchViewOnPreDrawListener(DynamicGridView.this.mMobileView, originalPosition, targetPosition));
            DynamicGridView.this.mMobileView = DynamicGridView.this.getViewForId(DynamicGridView.this.mMobileItemId);
        }

        private class AnimateSwitchViewOnPreDrawListener
        implements ViewTreeObserver.OnPreDrawListener {
            private final View mPreviousMobileView;
            private final int mOriginalPosition;
            private final int mTargetPosition;

            AnimateSwitchViewOnPreDrawListener(View previousMobileView, int originalPosition, int targetPosition) {
                this.mPreviousMobileView = previousMobileView;
                this.mOriginalPosition = originalPosition;
                this.mTargetPosition = targetPosition;
            }

            public boolean onPreDraw() {
                DynamicGridView.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                DynamicGridView.this.mTotalOffsetY = DynamicGridView.this.mTotalOffsetY + KitKatSwitchCellAnimator.this.mDeltaY;
                DynamicGridView.this.mTotalOffsetX = DynamicGridView.this.mTotalOffsetX + KitKatSwitchCellAnimator.this.mDeltaX;
                DynamicGridView.this.animateReorder(this.mOriginalPosition, this.mTargetPosition);
                this.mPreviousMobileView.setVisibility(0);
                if (DynamicGridView.this.mMobileView != null) {
                    DynamicGridView.this.mMobileView.setVisibility(4);
                }
                return true;
            }
        }
    }

    private class PreHoneycombCellAnimator
    implements SwitchCellAnimator {
        private int mDeltaY;
        private int mDeltaX;

        public PreHoneycombCellAnimator(int deltaX, int deltaY) {
            this.mDeltaX = deltaX;
            this.mDeltaY = deltaY;
        }

        @Override
        public void animateSwitchCell(int originalPosition, int targetPosition) {
            DynamicGridView.this.mTotalOffsetY = DynamicGridView.this.mTotalOffsetY + this.mDeltaY;
            DynamicGridView.this.mTotalOffsetX = DynamicGridView.this.mTotalOffsetX + this.mDeltaX;
        }
    }

    private static class DynamicGridModification {
        private List<Pair<Integer, Integer>> transitions = new Stack<Pair<Integer, Integer>>();

        DynamicGridModification() {
        }

        public boolean hasTransitions() {
            return !this.transitions.isEmpty();
        }

        public void addTransition(int oldPosition, int newPosition) {
            this.transitions.add((Pair<Integer, Integer>)new Pair((Object)oldPosition, (Object)newPosition));
        }

        public List<Pair<Integer, Integer>> getTransitions() {
            Collections.reverse(this.transitions);
            return this.transitions;
        }
    }

    public static interface OnSelectedItemBitmapCreationListener {
        public void onPreSelectedItemBitmapCreation(View var1, int var2, long var3);

        public void onPostSelectedItemBitmapCreation(View var1, int var2, long var3);
    }

    public static interface OnEditModeChangeListener {
        public void onEditModeChanged(boolean var1);
    }

    public static interface OnDragListener {
        public void onDragStarted(int var1);

        public void onDragPositionsChanged(int var1, int var2);
    }

    public static interface OnDropListener {
        public void onActionDrop();
    }

    private static interface SwitchCellAnimator {
        public void animateSwitchCell(int var1, int var2);
    }
}

