package com.intsig.csopen.sdk;

import android.content.Context;
import android.text.TextUtils;

/**
 * Factory for create {@link CSOpenAPI}
 * @author Ben
 *
 */
public class CSOpenApiFactory {
	
	private CSOpenApiFactory(){
		
	}
	
	/**
	 * used for create {@link CSOpenAPI}
	 * <p>ensure parameter context and appKey not null, otherwise will return null
	 * @param context 
	 * @param appKey app key of your app, can't be null or empty
	 * @param userId  optional, set null if you needn't
	 * @return instance of {@link CSOpenAPI}, or NULL if context or appKey is illegal
	 */
	public static CSOpenAPI createCSOpenApi(Context context, String appKey, String userId){
		if(context == null || TextUtils.isEmpty(appKey)){
			return null;
		}else{
			return new CSOpenApiV1(context, appKey, userId);
		}
	}
}
