package com.intsig.csopen.sdk;

import java.io.File;

import android.text.TextUtils;

/**
 * Parameters of scan image
 * @author Ben
 *
 */
public class CSOpenAPIParam {

	protected String mSourcePath;
	protected String mResultImgPath;
	protected String mResultPDFPath;
	protected String mOriginalImagePath;
	protected float mMinRequiredApiVersion;
	
	/**
	 * 
	 * @param sourcePath not null; source image file path
	 * @param resultImgPath not null; return file path of scanned image; 
	 * 		ATTENTION: the parent of resultImgPath must be exist
	 * @param resultPDFPath optional, pass null if needn't return PDF
	 * @param originalPath optional, pass NULL if needn't save original image
	 * @param apiVersion the minimal OpenAPI version of CamScanner
	 */
	public CSOpenAPIParam(String sourcePath, String resultImgPath, 
			String resultPDFPath, String originalPath, float apiVersion){
		mSourcePath = sourcePath;
		mResultImgPath = resultImgPath;
		mResultPDFPath = resultPDFPath;
		mOriginalImagePath = originalPath;
		mMinRequiredApiVersion = apiVersion;
	}
	
	/**
	 * check whether these parameters are legal
	 * @return true if legal
	 */
	public boolean checkLegal(){
		if(TextUtils.isEmpty(mSourcePath) || TextUtils.isEmpty(mResultImgPath)){
			return false;
		}else{
			File f = new File(mResultImgPath);
			if(!f.getParentFile().exists()){
				return false;
			}
		}
		return true;
	}
	
	public String getSourcePath() {
		return mSourcePath;
	}
	public void setSourcePath(String sourcePath) {
		this.mSourcePath = sourcePath;
	}
	public String getResultImgPath() {
		return mResultImgPath;
	}
	public void setResultImgPath(String resultImgPath) {
		this.mResultImgPath = resultImgPath;
	}
	public String getResultPDFPath() {
		return mResultPDFPath;
	}
	public void setResultPDFPath(String resultPDFPath) {
		this.mResultPDFPath = resultPDFPath;
	}
	public String getOriginalImagePath() {
		return mOriginalImagePath;
	}
	public void setOriginalImagePath(String originalImagePath) {
		this.mOriginalImagePath = originalImagePath;
	}
	public float getMinRequiredApiVersion() {
		return mMinRequiredApiVersion;
	}
	public void setMinRequiredApiVersion(float minRequiredApiVersion) {
		this.mMinRequiredApiVersion = minRequiredApiVersion;
	}
	
}
