package com.intsig.csopen.sdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

/**
 * API instance of OpenAPI.
 * <p> Use {@link CSOpenApiFactory} to create instance; You can simply use method 
 * {@link #scanImage(Activity, int, CSOpenAPIParam)} to call OpenAPI.
 * @author Ben
 *
 */
public abstract interface CSOpenAPI {

	/**
	 * IMPORTANT: This method must be invoked at the top of the calling
     * activity's onActivityResult() function to get the callback from CamScanner.
     *
	 * @param requestCode param from onActivityResult()
	 * @param resultCode param from onActivityResult()
	 * @param data param from onActivityResult()
	 * @param handler callback to handle the result
	 * @return true if this result is return from CamScanner OpenAPI;
	 */
	public abstract boolean handleResult(int requestCode, int resultCode, Intent data, CSOpenApiHandler handler);

	/**
	 * check whether CamScanner is installed.
	 * 
	 * <p> Attention: this method doesn't ensure whether CamScanner can support Open API
	 * @see #isCamScannerAvailable()
	 * @see #getOpenApiVersion()
	 * @return true if installed
	 */
	public abstract boolean isCamScannerInstalled();

	/**
	 * Whether the CamScanner installed support Open API
	 * @return true if the CamScanner support open api
	 * @see #getOpenApiVersion()
	 * @see #isCamScannerInstalled()
	 */
	public abstract boolean isCamScannerAvailable();
	/**
	 * get the OpenAPI version of current installed CamScanner; if CamScanner is not available, return -1
	 * @return OpenAPI version of CamScanner, or -1 if CamScanner does't support OpenAPI;
	 */
	public abstract float getOpenApiVersion();

	/**
	 * send file [param.imagePath] to CamScanner, and get scanned image back which stored at [param.resultImgPath]
	 * @param activity current activity instance to request OpenAPI
	 * @param requestCode request code for request CamScanner OpenAPI
	 * @param param OpenApi param, can't be NULL
	 * @return true if send request to CamScanner successfully; 
	 * 		false if CSOpenAPIParam is illegal or CamScanner not install
	 */
	public abstract boolean scanImage(Activity activity, int requestCode, CSOpenAPIParam param);
	
	/**
	 * get download link of CamScanner
	 * @return download link of CamScanner, such as http://www.intsig.com...
	 */
	public abstract String getDownloadLink();
}
