/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import java.lang.ref.WeakReference;

public class LocationHelper
extends LocationCallback {
    public static final int REQUEST_CHECK_SETTINGS = 505;
    public static final int REQUEST_PERMISSIONS_REQUEST_CODE = 606;
    private static final String TAG = "GPSLocationTracker";
    private static final long INTERVAL = 10000L;
    private static final long FASTEST_INTERVAL = 1000L;
    private LocationRequest mLocationRequest;
    private WeakReference<AppCompatActivity> activity;
    private LocationSettingsRequest mLocationSettingsRequest;
    private FusedLocationProviderClient mFusedLocationClient;
    private SettingsClient mSettingsClient;
    private LocationListener tracker;

    public LocationHelper(AppCompatActivity activity) {
        this.activity = new WeakReference<AppCompatActivity>(activity);
        this.mLocationRequest = new LocationRequest();
        this.mLocationRequest.setInterval(10000L);
        this.mLocationRequest.setFastestInterval(1000L);
        this.mLocationRequest.setPriority(102);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
        builder.addLocationRequest(this.mLocationRequest);
        this.mLocationSettingsRequest = builder.build();
        this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)activity);
        this.mSettingsClient = LocationServices.getSettingsClient((Activity)activity);
    }

    public void getLocation() {
        if (this.checkPermissions()) {
            this.startLocationUpdates();
        } else {
            this.requestPermissions();
        }
    }

    public void onLocationResult(LocationResult locationResult) {
        super.onLocationResult(locationResult);
        if (this.tracker != null) {
            this.tracker.onLocationChanged(locationResult.getLastLocation());
        }
        this.stopLocationUpdates();
    }

    private boolean checkPermissions() {
        int permissionState = ActivityCompat.checkSelfPermission((Context)((Context)this.activity.get()), (String)"android.permission.ACCESS_COARSE_LOCATION");
        return permissionState == 0;
    }

    public void stopLocationUpdates() {
        if (null != this.activity) {
            this.mFusedLocationClient.removeLocationUpdates((LocationCallback)this);
        }
    }

    private void startLocationUpdates() {
        this.mSettingsClient.checkLocationSettings(this.mLocationSettingsRequest).addOnSuccessListener((Activity)this.activity.get(), (OnSuccessListener)new OnSuccessListener<LocationSettingsResponse>(){

            public void onSuccess(LocationSettingsResponse locationSettingsResponse) {
                Log.i((String)LocationHelper.TAG, (String)"All location settings are satisfied.");
                LocationHelper.this.mFusedLocationClient.requestLocationUpdates(LocationHelper.this.mLocationRequest, (LocationCallback)LocationHelper.this, Looper.myLooper());
            }
        }).addOnFailureListener((Activity)this.activity.get(), new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                int statusCode = ((ApiException)e).getStatusCode();
                switch (statusCode) {
                    case 6: {
                        Log.i((String)LocationHelper.TAG, (String)"Location settings are not satisfied.");
                        try {
                            ResolvableApiException rae = (ResolvableApiException)e;
                            rae.startResolutionForResult((Activity)LocationHelper.this.activity.get(), 505);
                        }
                        catch (IntentSender.SendIntentException sie) {
                            Log.i((String)LocationHelper.TAG, (String)"PendingIntent unable to execute request.");
                        }
                        break;
                    }
                    case 8502: {
                        String errorMessage = "Location settings are inadequate, and cannot be fixed here. Fix in Settings.";
                        Log.e((String)LocationHelper.TAG, (String)errorMessage);
                        break;
                    }
                    default: {
                        Log.e((String)LocationHelper.TAG, (String)"Location Update Failed.");
                    }
                }
            }
        });
    }

    private void requestPermissions() {
        ActivityCompat.requestPermissions((Activity)((Activity)this.activity.get()), (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"}, (int)606);
    }

    public void setLocationListener(LocationListener tracker) {
        this.tracker = tracker;
    }
}

