/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.gaadi.neon.activity.neutral.NeonNeutralActivity;
import com.gaadi.neon.dynamicgrid.BaseDynamicGridAdapter;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.util.List;

public class ImageShowAdapter
extends BaseDynamicGridAdapter {
    private Context context;
    private boolean isProfileTagOnly;

    public ImageShowAdapter(Context context, boolean isProfileTagOnly) {
        super(context, NeonImagesHandler.getSingletonInstance().getImagesCollection(), 2);
        this.context = context;
        this.isProfileTagOnly = isProfileTagOnly;
    }

    @Override
    public int getCount() {
        if (NeonImagesHandler.getSingletonInstance().getImagesCollection() != null) {
            return NeonImagesHandler.getSingletonInstance().getImagesCollection().size();
        }
        return 0;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        PhotosHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.context, (int)R.layout.display_images, null);
            holder = new PhotosHolder();
            holder.image = (ImageView)convertView.findViewById(R.id.ivImageDisplay);
            holder.removeImage = (ImageView)convertView.findViewById(R.id.ivRemoveImage);
            holder.tvProfile = (TextView)convertView.findViewById(R.id.tvProfilePhoto);
            convertView.setTag((Object)holder);
        } else {
            holder = (PhotosHolder)convertView.getTag();
        }
        List<FileInfo> fileInfoList = NeonImagesHandler.getSingleonInstance().getImagesCollection();
        if (fileInfoList != null && fileInfoList.size() > 0) {
            if (this.isProfileTagOnly) {
                if (position > 0) {
                    holder.tvProfile.setVisibility(8);
                } else {
                    holder.tvProfile.setVisibility(0);
                    String tagName = NeonImagesHandler.getSingletonInstance().getNeutralParam().getProfileTagName();
                    holder.tvProfile.setText((CharSequence)tagName);
                }
            } else {
                if (NeonImagesHandler.getSingletonInstance().getGenericParam() != null && !NeonImagesHandler.getSingletonInstance().getGenericParam().getTagEnabled()) {
                    holder.tvProfile.setVisibility(8);
                } else {
                    holder.tvProfile.setVisibility(0);
                }
                if (fileInfoList.get(position).getFileTag() != null) {
                    holder.tvProfile.setText((CharSequence)fileInfoList.get(position).getFileTag().getTagName());
                } else {
                    holder.tvProfile.setText(R.string.select_tag);
                }
            }
            holder.removeImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (NeonImagesHandler.getSingleonInstance().removeFromCollection(position)) {
                        ImageShowAdapter.this.notifyDataSetChanged();
                        if (ImageShowAdapter.this.context instanceof NeonNeutralActivity) {
                            ((NeonNeutralActivity)ImageShowAdapter.this.context).onPostResume();
                        }
                    } else {
                        Toast.makeText((Context)ImageShowAdapter.this.context, (CharSequence)"Failed to delete.Please try again later.", (int)0).show();
                    }
                }
            });
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection().size() > 0) {
                RequestOptions options = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.ALL).centerCrop().placeholder(R.drawable.default_placeholder);
                Glide.with((Context)this.context).load(NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFilePath()).apply(options).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.image);
            }
        }
        return convertView;
    }

    private class PhotosHolder {
        ImageView image;
        ImageView removeImage;
        TextView tvProfile;

        private PhotosHolder() {
        }
    }
}

