/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.csopen.util;

import android.os.Build;

public class Log {
    private static final String TAG = "CsOpen.SDK.Log";
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_DEBUG = 1;
    public static final int LEVEL_INFO = 2;
    public static final int LEVEL_WARNING = 3;
    public static final int LEVEL_ERROR = 4;
    public static final int LEVEL_NONE = 5;
    private static int sLevel = 5;
    private static final String SYSTEM_INFO;

    static {
        StringBuilder localStringBuilder = new StringBuilder();
        localStringBuilder.append("VERSION.RELEASE:[" + Build.VERSION.RELEASE);
        localStringBuilder.append("] VERSION.CODENAME:[" + Build.VERSION.CODENAME);
        localStringBuilder.append("] VERSION.INCREMENTAL:[" + Build.VERSION.INCREMENTAL);
        localStringBuilder.append("] BOARD:[" + Build.BOARD);
        localStringBuilder.append("] DEVICE:[" + Build.DEVICE);
        localStringBuilder.append("] DISPLAY:[" + Build.DISPLAY);
        localStringBuilder.append("] FINGERPRINT:[" + Build.FINGERPRINT);
        localStringBuilder.append("] HOST:[" + Build.HOST);
        localStringBuilder.append("] MANUFACTURER:[" + Build.MANUFACTURER);
        localStringBuilder.append("] MODEL:[" + Build.MODEL);
        localStringBuilder.append("] PRODUCT:[" + Build.PRODUCT);
        localStringBuilder.append("] TAGS:[" + Build.TAGS);
        localStringBuilder.append("] TYPE:[" + Build.TYPE);
        localStringBuilder.append("] USER:[" + Build.USER + "]");
        SYSTEM_INFO = localStringBuilder.toString();
    }

    public static void setLevel(int level) {
        if (level < 0 || level > 5) {
            throw new IllegalArgumentException("illegal parameter level, values should be in range [0, 5]");
        }
        sLevel = level;
        android.util.Log.w((String)TAG, (String)("new log level: " + level));
    }

    public static int getLevel() {
        return sLevel;
    }

    public static void e(String tag, String msg) {
        Log.e(tag, msg, null);
    }

    public static void w(String tag, String msg) {
        Log.w(tag, msg, null);
    }

    public static void i(String tag, String msg) {
        Log.i(tag, msg, null);
    }

    public static void d(String tag, String msg) {
        Log.d(tag, msg, null);
    }

    public static void v(String tag, String msg) {
        Log.v(tag, msg, null);
    }

    public static void e(String tag, String msg, Object[] param) {
        if (sLevel > 4) {
            return;
        }
        msg = param == null ? msg : String.format(msg, param);
        android.util.Log.e((String)tag, (String)msg);
    }

    public static void w(String tag, String msg, Object[] param) {
        if (sLevel > 3) {
            return;
        }
        msg = param == null ? msg : String.format(msg, param);
        android.util.Log.w((String)tag, (String)msg);
    }

    public static void i(String tag, String msg, Object[] param) {
        if (sLevel > 2) {
            return;
        }
        msg = param == null ? msg : String.format(msg, param);
        android.util.Log.i((String)tag, (String)msg);
    }

    public static void d(String tag, String msg, Object[] param) {
        if (sLevel > 1) {
            return;
        }
        msg = param == null ? msg : String.format(msg, param);
        android.util.Log.d((String)tag, (String)msg);
    }

    public static void v(String tag, String msg, Object[] param) {
        if (sLevel > 0) {
            return;
        }
        msg = param == null ? msg : String.format(msg, param);
        android.util.Log.v((String)tag, (String)msg);
    }

    public static String getSysInfo() {
        return SYSTEM_INFO;
    }
}

