/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.widget.Toast;
import com.gaadi.neon.activity.NeonBaseActivity;
import com.gaadi.neon.model.BucketModel;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.util.ArrayList;

public abstract class NeonBaseGalleryActivity
extends NeonBaseActivity {
    private Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    private ArrayList<BucketModel> buckets;

    protected ArrayList<BucketModel> getImageBuckets() {
        Cursor mCursor;
        this.buckets = new ArrayList();
        String[] PROJECTION_BUCKET = new String[]{"bucket_display_name", "bucket_id", "_data"};
        String orderBy = "datetaken DESC";
        if (NeonImagesHandler.getSingletonInstance().getGalleryParam() != null && NeonImagesHandler.getSingletonInstance().getGalleryParam().isRestrictedExtensionJpgPngEnabled()) {
            boolean folderRestriction = false;
            String appName = "";
            if (NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderRestrictive() && (appName = NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderName() != null ? NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderName() : Constants.getAppName((Context)this)) != null && appName.length() > 0) {
                folderRestriction = true;
            }
            mCursor = folderRestriction ? this.getContentResolver().query(this.uri, PROJECTION_BUCKET, "bucket_display_name =? and mime_type in (?, ?)", new String[]{appName, "image/jpeg", "image/png"}, orderBy) : this.getContentResolver().query(this.uri, PROJECTION_BUCKET, "mime_type in (?, ?)", new String[]{"image/jpeg", "image/png"}, orderBy);
        } else {
            mCursor = this.getContentResolver().query(this.uri, PROJECTION_BUCKET, null, null, orderBy);
        }
        if (mCursor == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.gallery_error), (int)0).show();
            this.finish();
            return null;
        }
        mCursor.moveToFirst();
        if (mCursor.getCount() > 0) {
            do {
                String bucketId;
                int index;
                if ((index = this.getBucketIndexWithId(bucketId = mCursor.getString(mCursor.getColumnIndex("bucket_id")))) == -1) {
                    BucketModel bucketModel = new BucketModel();
                    bucketModel.setBucketId(bucketId);
                    bucketModel.setBucketName(mCursor.getString(mCursor.getColumnIndex("bucket_display_name")));
                    bucketModel.setFileCount(1);
                    bucketModel.setBucketCoverImagePath(mCursor.getString(mCursor.getColumnIndex("_data")));
                    this.buckets.add(bucketModel);
                    continue;
                }
                this.buckets.get(index).setFileCount(this.buckets.get(index).getFileCount() + 1);
            } while (mCursor.moveToNext());
        }
        mCursor.close();
        return this.buckets;
    }

    protected ArrayList<FileInfo> getFileFromBucketId(String bucketId) {
        String[] selectionArgs;
        String selection;
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        boolean folderRestriction = false;
        String appName = "";
        if (NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderRestrictive() && (appName = NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderName() != null ? NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderName() : Constants.getAppName((Context)this)) != null && appName.length() > 0) {
            folderRestriction = true;
        }
        String[] PROJECTION_FILES = new String[]{"bucket_display_name", "bucket_id", "_data", "datetaken"};
        String orderBy = "datetaken DESC";
        if (bucketId == null) {
            if (folderRestriction) {
                selection = "bucket_display_name =? and _size >? and mime_type in (?, ?)";
                selectionArgs = new String[]{appName, String.valueOf(0), "image/jpeg", "image/png"};
            } else {
                selection = null;
                selectionArgs = null;
            }
        } else if (folderRestriction) {
            selection = "bucket_id =? and bucket_display_name =? and _size >? and mime_type in (?, ?)";
            selectionArgs = new String[]{bucketId, appName, String.valueOf(0), "image/jpeg", "image/png"};
        } else {
            selection = "bucket_id =? and _size >? and mime_type in (?, ?)";
            selectionArgs = new String[]{bucketId, String.valueOf(0), "image/jpeg", "image/png"};
        }
        Cursor mCursor = this.getContentResolver().query(this.uri, PROJECTION_FILES, selection, selectionArgs, orderBy);
        if (mCursor == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.gallery_error), (int)0).show();
            this.finish();
            return null;
        }
        mCursor.moveToFirst();
        if (mCursor.getCount() > 0) {
            do {
                FileInfo singleFileInfo = new FileInfo();
                singleFileInfo.setSource(FileInfo.SOURCE.PHONE_GALLERY);
                singleFileInfo.setFilePath(mCursor.getString(mCursor.getColumnIndex("_data")));
                singleFileInfo.setDateTimeTaken(mCursor.getString(mCursor.getColumnIndex("datetaken")));
                singleFileInfo.setType(FileInfo.FILE_TYPE.IMAGE);
                fileInfos.add(singleFileInfo);
            } while (mCursor.moveToNext());
        }
        mCursor.close();
        return fileInfos;
    }

    private int getBucketIndexWithId(String id2) {
        if (this.buckets == null || this.buckets.size() <= 0) {
            return -1;
        }
        for (int i = 0; i < this.buckets.size(); ++i) {
            if (!this.buckets.get(i).getBucketId().equals(id2)) continue;
            return i;
        }
        return -1;
    }
}

