/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ImageView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.gaadi.neon.interfaces.UpdateSelection;
import com.gaadi.neon.util.ApplicationController;
import com.scanlibrary.R;
import java.util.HashSet;

public class SelectFilesAdapter
extends CursorAdapter
implements View.OnClickListener {
    public HashSet<String> selectedArr = new HashSet();
    private Context context;
    private UpdateSelection updateSelection;
    private FilesHolder filesHolder;
    private boolean stopSelection;

    public SelectFilesAdapter(Context context, Cursor c, int flags, UpdateSelection updateSelection) {
        super(context, c, flags);
        this.updateSelection = updateSelection;
        this.context = context;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rlSelectFiles) {
            this.actionSelectUnSelect(v);
        }
    }

    private void actionSelectUnSelect(View v) {
        FilesHolder holder = (FilesHolder)v.getTag();
        String imagePath = (String)holder.transparentLayer.getTag();
        if (imagePath.substring(imagePath.lastIndexOf(".") + 1).equalsIgnoreCase("bmp")) {
            Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.wrong_format), (int)0).show();
            return;
        }
        int position = (Integer)holder.selection_view.getTag();
        if (0 == holder.transparentLayer.getVisibility()) {
            holder.transparentLayer.setVisibility(4);
            holder.selection_view.setVisibility(4);
            this.selectedArr.remove(String.valueOf(position));
            this.updateSelection.updateSelected(imagePath, false);
        } else if (this.stopSelection) {
            Toast.makeText((Context)this.context, (CharSequence)this.context.getString(R.string.selected_max_photos), (int)0).show();
        } else {
            holder.transparentLayer.setVisibility(0);
            holder.selection_view.setVisibility(0);
            holder.selectedImage.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)R.color.transparent_white));
            this.updateSelection.updateSelected(imagePath, true);
            this.selectedArr.add(String.valueOf(position));
        }
    }

    public View newView(Context context, Cursor cursor, ViewGroup viewGroup) {
        View convertView = View.inflate((Context)context, (int)R.layout.select_files, null);
        this.filesHolder = new FilesHolder();
        this.filesHolder.selectedImage = (ImageView)convertView.findViewById(R.id.imageSelected);
        this.filesHolder.selection_view = (ImageView)convertView.findViewById(R.id.selection_view);
        this.filesHolder.transparentLayer = (ImageView)convertView.findViewById(R.id.vTransparentLayer);
        convertView.setTag((Object)this.filesHolder);
        return convertView;
    }

    public void bindView(View view, Context context, Cursor cursor) {
        this.filesHolder = (FilesHolder)view.getTag();
        String path = cursor.getString(cursor.getColumnIndex("_data"));
        view.setOnClickListener((View.OnClickListener)this);
        this.filesHolder.transparentLayer.setTag((Object)path);
        this.filesHolder.selection_view.setTag((Object)cursor.getPosition());
        RequestOptions options = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE).centerCrop().placeholder(R.drawable.default_placeholder);
        Glide.with((Context)context).load(path).apply(options).into(this.filesHolder.selectedImage);
        if (ApplicationController.selectedFiles != null && ApplicationController.selectedFiles.contains(path)) {
            this.filesHolder.transparentLayer.setVisibility(0);
            this.filesHolder.selection_view.setVisibility(0);
        } else {
            this.filesHolder.transparentLayer.setVisibility(4);
            this.filesHolder.selection_view.setVisibility(4);
        }
        if (this.selectedArr.contains(String.valueOf(cursor.getPosition()))) {
            this.filesHolder.transparentLayer.setVisibility(0);
            this.filesHolder.selection_view.setVisibility(0);
        }
    }

    public void setStopSelection(boolean stopSelection) {
        this.stopSelection = stopSelection;
    }

    public class FilesHolder {
        ImageView selectedImage;
        ImageView transparentLayer;
        ImageView selection_view;
    }
}

