/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.adapter.ImageTagsAdapter;
import com.gaadi.neon.events.ImageEditEvent;
import com.gaadi.neon.interfaces.FragmentListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.NeonUtils;
import com.scanlibrary.R;
import com.soundcloud.android.crop.Crop;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;

public class ImageReviewViewPagerFragment
extends Fragment
implements View.OnClickListener {
    public static final String ARG_PAGE = "page";
    private int mPageNumber;
    private ImageView deleteBtn;
    private ImageView rotateBtn;
    private TextView txtVwTagSpinner;
    private ImageView draweeView;
    private LinearLayout tagLayout;
    private FileInfo imageModel;
    List<ImageTagModel> tagModels;
    private Context mContext;
    private ImageView cropBtn;
    private File cropFilePath;
    private RelativeLayout fileEditLayout;

    public static ImageReviewViewPagerFragment create(int pageNumber, FileInfo imageModel) {
        ImageReviewViewPagerFragment fragment = new ImageReviewViewPagerFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_PAGE, pageNumber);
        args.putSerializable("imageModelReview", (Serializable)imageModel);
        fragment.setArguments(args);
        return fragment;
    }

    public static String getMimeType(String url) {
        String type = null;
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if (extension != null) {
            type = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return type;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mContext = context;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mPageNumber = this.getArguments().getInt(ARG_PAGE);
        if (NeonImagesHandler.getSingletonInstance() != null && NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel().size() > 0) {
            this.tagModels = NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel();
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        ViewGroup rootView = (ViewGroup)inflater.inflate(R.layout.fragment_image_review_viewpager, container, false);
        this.fileEditLayout = (RelativeLayout)rootView.findViewById(R.id.header_options_imageereview);
        this.deleteBtn = (ImageView)rootView.findViewById(R.id.imagereview_deletebtn);
        this.cropBtn = (ImageView)rootView.findViewById(R.id.imagereview_cropbtn);
        this.rotateBtn = (ImageView)rootView.findViewById(R.id.imagereview_rotatebtn);
        this.txtVwTagSpinner = (TextView)rootView.findViewById(R.id.imagereview_tag_spinner);
        this.draweeView = (ImageView)rootView.findViewById(R.id.imagereview_imageview);
        this.tagLayout = (LinearLayout)rootView.findViewById(R.id.footer_layout_imagereview_fragment);
        if (NeonImagesHandler.getSingleonInstance().getGenericParam().getTagEnabled()) {
            this.tagLayout.setVisibility(0);
        } else {
            this.tagLayout.setVisibility(8);
        }
        this.deleteBtn.setOnClickListener((View.OnClickListener)this);
        this.rotateBtn.setOnClickListener((View.OnClickListener)this);
        this.cropBtn.setOnClickListener((View.OnClickListener)this);
        this.txtVwTagSpinner.setOnClickListener((View.OnClickListener)this);
        this.onLoad(savedInstanceState);
        if (this.imageModel != null && this.imageModel.getFilePath() != null && (this.imageModel.getFilePath().contains("http") || this.imageModel.getFilePath().contains("https"))) {
            this.fileEditLayout.setVisibility(4);
        } else {
            this.fileEditLayout.setVisibility(0);
        }
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            this.fileEditLayout.setVisibility(8);
            this.tagLayout.setVisibility(8);
        }
        return rootView;
    }

    public void onLoad(Bundle savedInstanceState) {
        Serializable o;
        Bundle bundle = this.getArguments();
        this.imageModel = (FileInfo)bundle.getSerializable("imageModelReview");
        if (savedInstanceState != null && (o = bundle.getSerializable("imageModelReview")) != null) {
            this.imageModel = (FileInfo)o;
        }
        if (this.imageModel.getFileTag() != null) {
            this.txtVwTagSpinner.setText((CharSequence)this.imageModel.getFileTag().getTagName());
        }
        Glide.with((Context)this.mContext).load(this.imageModel.getFilePath()).placeholder(R.drawable.default_placeholder).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).into(this.draweeView);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putSerializable("imageModelReview", (Serializable)this.imageModel);
        super.onSaveInstanceState(outState);
    }

    private void showTagsDropDown(View v) {
        final ListPopupWindow listPopupWindow = new ListPopupWindow((Context)this.getActivity());
        listPopupWindow.setModal(true);
        listPopupWindow.setWidth(-2);
        ImageTagsAdapter imageTagsAdapter = new ImageTagsAdapter((Context)this.getActivity(), this.imageModel);
        listPopupWindow.setAdapter((ListAdapter)imageTagsAdapter);
        listPopupWindow.setAnchorView(v);
        listPopupWindow.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                ImageTagModel singleModel = ImageReviewViewPagerFragment.this.tagModels.get(position);
                if (singleModel.getNumberOfPhotos() > 0 && NeonImagesHandler.getSingleonInstance().getNumberOfPhotosCollected(singleModel) >= singleModel.getNumberOfPhotos()) {
                    Toast.makeText((Context)ImageReviewViewPagerFragment.this.getActivity(), (CharSequence)(ImageReviewViewPagerFragment.this.getActivity().getString(R.string.max_tag_count_error, new Object[]{singleModel.getNumberOfPhotos()}) + singleModel.getTagName()), (int)0).show();
                    return;
                }
                ImageReviewViewPagerFragment.this.imageModel.setFileTag(new ImageTagModel(singleModel.getTagName(), singleModel.getTagId(), singleModel.isMandatory(), singleModel.getNumberOfPhotos()));
                ImageEditEvent event = new ImageEditEvent();
                event.setModel(ImageReviewViewPagerFragment.this.imageModel);
                ((FragmentListener)ImageReviewViewPagerFragment.this.getActivity()).getFragmentChanges(event);
                listPopupWindow.dismiss();
                ImageReviewViewPagerFragment.this.txtVwTagSpinner.setText((CharSequence)singleModel.getTagName());
            }
        });
        this.txtVwTagSpinner.post(new Runnable(){

            @Override
            public void run() {
                listPopupWindow.show();
            }
        });
    }

    public int getPageNumber() {
        return this.mPageNumber;
    }

    public void onClick(View v) {
        ImageEditEvent event = new ImageEditEvent();
        event.setModel(this.imageModel);
        if (v.getId() == R.id.imagereview_deletebtn) {
            event.setImageEventType(1);
            event.setPosition(this.mPageNumber);
            this.warnDeleteDialog(event);
        } else if (v.getId() == R.id.imagereview_rotatebtn) {
            this.rotateImage(this.imageModel.getFilePath());
        } else if (v.getId() == R.id.imagereview_tag_spinner) {
            this.showTagsDropDown(v);
        } else if (v.getId() == R.id.imagereview_cropbtn) {
            this.cropFilePath = NeonUtils.getEmptyStoragePath((Context)this.getActivity());
            Uri inputUri = Uri.fromFile((File)new File(this.imageModel.getFilePath()));
            Uri outputUri = Uri.fromFile((File)this.cropFilePath);
            Crop.of((Uri)inputUri, (Uri)outputUri).start((Context)this.getActivity(), (Fragment)this);
        }
    }

    private void warnDeleteDialog(final ImageEditEvent event) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.getActivity());
        builder.setTitle(R.string.remove_img_title);
        builder.setMessage(R.string.removeImage);
        builder.setCancelable(false);
        builder.setPositiveButton(R.string.okDialog, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (ImageReviewViewPagerFragment.this.isAdded()) {
                    ((FragmentListener)ImageReviewViewPagerFragment.this.getActivity()).getFragmentChanges(event);
                }
            }
        });
        builder.setNegativeButton(R.string.cancelDialog, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        if (dialog != null && !dialog.isShowing()) {
            dialog.show();
        }
    }

    @SuppressLint(value={"NewApi"})
    private Bitmap getBitmap(String path) {
        DisplayMetrics displaymetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int screenWidth = displaymetrics.widthPixels;
        int screenHeight = displaymetrics.heightPixels;
        Log.e((String)"inside of", (String)("getBitmap = " + path));
        try {
            Object b = null;
            BitmapFactory.Options o = new BitmapFactory.Options();
            o.inJustDecodeBounds = true;
            Matrix matrix = new Matrix();
            ExifInterface exifReader = new ExifInterface(path);
            int orientation = exifReader.getAttributeInt("Orientation", -1);
            int rotate = 0;
            if (orientation != 1) {
                if (orientation == 6) {
                    rotate = 90;
                } else if (orientation == 3) {
                    rotate = 180;
                } else if (orientation == 8) {
                    rotate = 270;
                } else {
                    Toast.makeText((Context)this.getActivity(), (CharSequence)"Not Able to rotate image due to missing orientation tag", (int)0).show();
                    Log.e((String)"ERROR", (String)("Not Able to rotate image due to orientation tag=" + orientation));
                    return null;
                }
            }
            this.draweeView.setRotation(this.draweeView.getRotation() + 90.0f);
            ImageEditEvent event = new ImageEditEvent();
            event.setModel(this.imageModel);
            event.setImageEventType(2);
            ((FragmentListener)this.getActivity()).getFragmentChanges(event);
        }
        catch (Exception e) {
            Log.e((String)"my tag", (String)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void rotateImage(String path) {
        File file = new File(path);
        ExifInterface exifInterface = null;
        try {
            exifInterface = new ExifInterface(file.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        if (orientation == 1 | orientation == 0) {
            exifInterface.setAttribute("Orientation", "6");
        } else if (orientation == 6) {
            exifInterface.setAttribute("Orientation", "3");
        } else if (orientation == 3) {
            exifInterface.setAttribute("Orientation", "8");
        } else if (orientation == 8) {
            exifInterface.setAttribute("Orientation", "1");
        }
        try {
            exifInterface.saveAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.getBitmap(path);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent result) {
        if (requestCode == 6709 && resultCode == -1) {
            this.imageModel.setFilePath(this.cropFilePath.getAbsolutePath());
            Glide.with((Context)this.mContext).load(this.imageModel.getFilePath()).placeholder(R.drawable.default_placeholder).diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).into(this.draweeView);
        }
    }
}

