/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.widget.Toast;
import com.gaadi.neon.activity.camera.NormalCamera2ActivityNeon;
import com.gaadi.neon.activity.camera.NormalCameraActivityNeon;
import com.gaadi.neon.activity.gallery.GridFilesActivity;
import com.gaadi.neon.activity.gallery.GridFoldersActivity;
import com.gaadi.neon.activity.gallery.HorizontalFilesActivity;
import com.gaadi.neon.activity.neutral.NeonNeutralActivity;
import com.gaadi.neon.enumerations.LibraryMode;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.INeutralParam;
import com.gaadi.neon.interfaces.LivePhotosListener;
import com.gaadi.neon.interfaces.OnImageCollectionListener;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.intsig.csopen.sdk.CSOpenAPI;
import com.intsig.csopen.sdk.CSOpenAPIParam;
import java.util.List;

public class PhotosLibrary {
    public static void collectLivePhotos(int requestCode, LibraryMode libraryMode, Context activity, OnImageCollectionListener imageCollectionListener, LivePhotosListener livePhotosListener, ICameraParam iCameraParam) throws NullPointerException, NeonException {
        try {
            if (livePhotosListener == null) {
                throw new NullPointerException("'LivePhotosListener' cannot be null");
            }
            NeonImagesHandler.getSingletonInstance().setLivePhotosListener(livePhotosListener);
            PhotosLibrary.collectPhotos(requestCode, activity, libraryMode, PhotosMode.setCameraMode().setParams(iCameraParam), imageCollectionListener);
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
    }

    public static void collectPhotos(int requestCode, Context activity, LibraryMode libraryMode, PhotosMode photosMode, OnImageCollectionListener listener) throws NullPointerException, NeonException {
        NeonImagesHandler.getSingletonInstance().setImageResultListener(listener);
        NeonImagesHandler.getSingletonInstance().setLibraryMode(libraryMode);
        NeonImagesHandler.getSingletonInstance().setRequestCode(requestCode);
        PhotosLibrary.validate(activity, photosMode, listener);
        List<FileInfo> alreadyAddedImages = photosMode.getParams().getAlreadyAddedImages();
        if (alreadyAddedImages != null) {
            NeonImagesHandler.getSingletonInstance().setImagesCollection(alreadyAddedImages);
        }
        if (photosMode.getParams() instanceof INeutralParam) {
            PhotosLibrary.startNeutralActivity(activity, photosMode);
        } else if (photosMode.getParams() instanceof ICameraParam) {
            PhotosLibrary.startCameraActivity(activity, photosMode);
        } else if (photosMode.getParams() instanceof IGalleryParam) {
            PhotosLibrary.startGalleryActivity(activity, photosMode);
        }
    }

    private static void validate(Context activity, PhotosMode photosMode, OnImageCollectionListener listener) throws NullPointerException, NeonException {
        if (activity == null) {
            throw new NullPointerException("Activity instance cannot be null");
        }
        if (photosMode == null) {
            throw new NullPointerException("PhotosMode instance cannot be null");
        }
        if (photosMode.getParams().getTagEnabled() && (photosMode.getParams().getImageTagsModel() == null || photosMode.getParams().getImageTagsModel().size() <= 0)) {
            throw new NeonException("Tags enabled but list is empty or null");
        }
        if (listener == null) {
            throw new NullPointerException("'OnImageCollectionListener' cannot be null");
        }
    }

    private static void startCameraActivity(Context activity, PhotosMode photosMode) {
        ICameraParam cameraParams = (ICameraParam)photosMode.getParams();
        if (cameraParams == null) {
            Toast.makeText((Context)activity, (CharSequence)"Camera param null", (int)0).show();
            return;
        }
        NeonImagesHandler.getSingletonInstance().setCameraParam(cameraParams);
        switch (cameraParams.getCameraViewType()) {
            case normal_camera: 
            case gallery_preview_camera: {
                if (Build.VERSION.SDK_INT < 21) {
                    Intent intent = new Intent(activity, NormalCameraActivityNeon.class);
                    activity.startActivity(intent);
                    break;
                }
                Intent intent = new Intent(activity, NormalCamera2ActivityNeon.class);
                activity.startActivity(intent);
            }
        }
    }

    private static void startGalleryActivity(Context activity, PhotosMode photosMode) {
        IGalleryParam galleryParams = (IGalleryParam)photosMode.getParams();
        if (galleryParams == null) {
            Toast.makeText((Context)activity, (CharSequence)"Gallery param null", (int)0).show();
            return;
        }
        NeonImagesHandler.getSingletonInstance().setGalleryParam(galleryParams);
        switch (galleryParams.getGalleryViewType()) {
            case Grid_Structure: {
                Intent gridGalleryIntent = galleryParams.enableFolderStructure() ? new Intent(activity, GridFoldersActivity.class) : new Intent(activity, GridFilesActivity.class);
                activity.startActivity(gridGalleryIntent);
                break;
            }
            case Horizontal_Structure: {
                Intent horizontalGalleryIntent = galleryParams.enableFolderStructure() ? new Intent(activity, GridFoldersActivity.class) : new Intent(activity, HorizontalFilesActivity.class);
                activity.startActivity(horizontalGalleryIntent);
            }
        }
    }

    private static void startNeutralActivity(Context activity, PhotosMode photosMode) {
        NeonImagesHandler.getSingletonInstance().setNeutralEnabled(true);
        INeutralParam neutralParamParams = (INeutralParam)photosMode.getParams();
        if (neutralParamParams == null) {
            Toast.makeText((Context)activity, (CharSequence)"Neutral param null", (int)0).show();
            return;
        }
        NeonImagesHandler.getSingletonInstance().setNeutralParam(neutralParamParams);
        Intent neutralIntent = new Intent(activity, NeonNeutralActivity.class);
        activity.startActivity(neutralIntent);
    }

    public static boolean go2CamScanner(Activity activity, String filePath, String outputImagePath, int requestCode, CSOpenAPI csOpenAPI) {
        CSOpenAPIParam param = new CSOpenAPIParam(filePath, outputImagePath, null, null, 1.0f);
        return csOpenAPI.scanImage(activity, requestCode, param);
    }
}

