/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.location.Geocoder;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.google.android.gms.location.LocationSettingsStates;

public class FindLocations
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private GoogleApiClient mGoogleApiClient;
    private Activity activity;
    private long UPDATE_INTERVAL = 6000L;
    private long FASTEST_INTERVAL = 5000L;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private Location location;
    private ILocation callBack;
    private static FindLocations self;
    protected String mAddressOutput;
    public AddressResultReceiver mResultReceiver;
    private static final int REQUEST_CHECK_SETTINGS = 1;
    private static final int ACCESS_FINE_LOCATION_INTENT_ID = 3;
    private static final String BROADCAST_ACTION = "android.location.PROVIDERS_CHANGED";

    public Location getLocation() {
        return this.location;
    }

    public static FindLocations getInstance() {
        if (self == null) {
            self = new FindLocations();
        }
        return self;
    }

    public void init(Activity activity) {
        this.activity = activity;
        this.callBack = (ILocation)activity;
        this.mGoogleApiClient = new GoogleApiClient.Builder((Context)activity).addApi(LocationServices.API).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).build();
        this.mResultReceiver = new AddressResultReceiver(new Handler());
        this.connectClient();
    }

    protected void connectClient() {
        if (this.isGooglePlayServicesAvailable() && this.mGoogleApiClient != null) {
            this.mGoogleApiClient.connect();
        }
    }

    public void onConnected(@Nullable Bundle bundle) {
        boolean permissionGranted;
        boolean bl = permissionGranted = ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        if (permissionGranted) {
            this.location = LocationServices.FusedLocationApi.getLastLocation(this.mGoogleApiClient);
            if (this.location != null) {
                this.callBack.getLocation(this.location);
                if (!Geocoder.isPresent()) {
                    return;
                }
            }
            this.startLocationUpdates();
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)200);
        }
    }

    protected void startLocationUpdates() {
        boolean permissionGranted;
        if (!this.mGoogleApiClient.isConnected()) {
            return;
        }
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setPriority(100);
        locationRequest.setInterval(this.UPDATE_INTERVAL);
        locationRequest.setFastestInterval(this.FASTEST_INTERVAL);
        boolean bl = permissionGranted = ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        if (permissionGranted) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.mGoogleApiClient, locationRequest, (LocationListener)this);
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)200);
        }
    }

    public void onLocationChanged(Location location) {
        String msg = "Updated Location: " + Double.toString(location.getLatitude()) + "," + Double.toString(location.getLongitude());
        this.location = location;
        this.callBack.getLocation(location);
        this.startIntentService();
    }

    public void onConnectionSuspended(int i) {
        if (i == 1 || i == 2) {
            // empty if block
        }
    }

    public void onConnectionFailed(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            try {
                connectionResult.startResolutionForResult(this.activity, 9000);
            }
            catch (IntentSender.SendIntentException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isGooglePlayServicesAvailable() {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int result = googleAPI.isGooglePlayServicesAvailable((Context)this.activity);
        if (result != 0) {
            if (googleAPI.isUserResolvableError(result)) {
                googleAPI.getErrorDialog(this.activity, result, 9000).show();
            }
            return false;
        }
        return true;
    }

    protected void startIntentService() {
    }

    public boolean checkPermissions(Activity activity) {
        this.callBack = (ILocation)activity;
        return this.checkPermissions(activity, this.callBack);
    }

    public boolean checkPermissions(Activity activity, ILocation callBack) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                this.requestLocationPermission(activity);
                return false;
            }
            this.showSettingDialog(activity, callBack);
            return true;
        }
        this.showSettingDialog(activity, callBack);
        return true;
    }

    private void requestLocationPermission(Activity activity) {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_FINE_LOCATION")) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)3);
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)3);
        }
    }

    private void showSettingDialog(final Activity activity, final ILocation callBack) {
        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(100);
        locationRequest.setInterval(30000L);
        locationRequest.setFastestInterval(5000L);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);
        if (this.mGoogleApiClient == null) {
            return;
        }
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(this.mGoogleApiClient, builder.build());
        result.setResultCallback((ResultCallback)new ResultCallback<LocationSettingsResult>(){

            public void onResult(@NonNull LocationSettingsResult result) {
                Status status = result.getStatus();
                LocationSettingsStates state = result.getLocationSettingsStates();
                switch (status.getStatusCode()) {
                    case 0: {
                        if (FindLocations.this.location != null) {
                            callBack.getPermissionStatus(true);
                            break;
                        }
                        callBack.getPermissionStatus(false);
                        Toast.makeText((Context)activity, (CharSequence)"Finding Location.Please try again", (int)0).show();
                        break;
                    }
                    case 6: {
                        try {
                            status.startResolutionForResult(activity, 1);
                        }
                        catch (IntentSender.SendIntentException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    case 8502: {
                        break;
                    }
                    default: {
                        callBack.getPermissionStatus(false);
                    }
                }
            }
        });
    }

    class AddressResultReceiver
    extends ResultReceiver {
        public AddressResultReceiver(Handler handler) {
            super(handler);
        }

        protected void onReceiveResult(int resultCode, Bundle resultData) {
            this.displayAddressOutput();
        }

        private void displayAddressOutput() {
            FindLocations.this.callBack.getAddress(FindLocations.this.mAddressOutput);
        }
    }

    public static interface ILocation {
        public void getLocation(Location var1);

        public void getAddress(String var1);

        public void getPermissionStatus(Boolean var1);
    }
}

