/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.GalleryActivity;
import com.gaadi.neon.fragment.CameraFragment1;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.AnimationUtils;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CameraActivity1
extends AppCompatActivity
implements CameraFragment1.PictureTakenListener,
View.OnClickListener {
    public static final int GALLERY_PICK = 99;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private ImageView buttonCapture;
    private ImageView buttonDone;
    private CameraFragment1 mFragment;
    private PhotoParams photoParams;
    private int maxNumberOfImages;
    private LinearLayout scrollView;
    private TextView tvImageName;
    private String imageName;
    private ImageView buttonGallery;
    private ArrayList<ImageTagModel> mTagList;
    private int currentTag;
    private TextView tvTag;
    private TextView tvNext;
    private HashMap<ImageTagModel, List<FileInfo>> imagesWithTags;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_activity_layout);
        this.initialize();
        this.customize();
        this.enableDoneButton(false);
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (CameraActivity1.this.maxNumberOfImages == 0) {
                    CameraActivity1.this.buttonDone.setVisibility(0);
                    CameraActivity1.this.buttonDone.setOnClickListener((View.OnClickListener)CameraActivity1.this);
                }
                if (CameraActivity1.this.photoParams.getImageName() != null && !"".equals(CameraActivity1.this.photoParams.getImageName())) {
                    CameraActivity1.this.tvImageName.setVisibility(0);
                    CameraActivity1.this.tvImageName.setText((CharSequence)String.valueOf(CameraActivity1.this.photoParams.getImageName()));
                    CameraActivity1.this.tvImageName.setOnClickListener((View.OnClickListener)CameraActivity1.this);
                }
            }
        }, 1000L);
        FragmentManager manager = this.getSupportFragmentManager();
        manager.beginTransaction().replace(R.id.content_frame, (Fragment)this.mFragment).commit();
        if (savedInstanceState != null) {
            this.imagesList = (ArrayList)savedInstanceState.getSerializable("imagesSelected");
            this.addInScrollView(this.imagesList);
        }
    }

    private void initialize() {
        this.buttonCapture = (ImageView)this.findViewById(R.id.buttonCapture);
        this.buttonGallery = (ImageView)this.findViewById(R.id.buttonGallery);
        this.buttonDone = (ImageView)this.findViewById(R.id.buttonDone);
        this.scrollView = (LinearLayout)this.findViewById(R.id.imageHolderView);
        this.tvImageName = (TextView)this.findViewById(R.id.tvImageName);
        this.tvTag = (TextView)this.findViewById(R.id.tvTag);
        this.tvNext = (TextView)this.findViewById(R.id.tvSkip);
        this.findViewById(R.id.rlTags).setOnClickListener((View.OnClickListener)this);
        this.tvNext.setOnClickListener((View.OnClickListener)this);
        this.buttonCapture.setOnClickListener((View.OnClickListener)this);
        this.buttonGallery.setOnClickListener((View.OnClickListener)this);
    }

    private void customize() {
        this.photoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        if (this.photoParams.isTagEnabled()) {
            this.tvImageName.setVisibility(8);
            this.mTagList = this.photoParams.getImageTags();
            if (this.mTagList == null) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.no_tags_sent), (int)0).show();
                return;
            }
            this.setTag(this.mTagList.get(this.currentTag));
            this.imagesWithTags = new HashMap();
        } else {
            this.findViewById(R.id.rlTags).setVisibility(8);
        }
        this.maxNumberOfImages = this.photoParams.getNoOfPhotos();
        if (this.maxNumberOfImages == 1) {
            this.buttonDone.setVisibility(8);
        }
        this.imageName = this.photoParams.getImageName();
        boolean isGalleryEnabled = this.photoParams.isGalleryFromCameraEnabled();
        if (!isGalleryEnabled) {
            this.buttonGallery.setVisibility(8);
        }
    }

    public void setTag(ImageTagModel imageTagModel) {
        this.tvTag.setText((CharSequence)imageTagModel.getTagName());
    }

    public ImageTagModel getNextTag() {
        if (this.photoParams.isTagEnabled()) {
            if (this.mTagList.get(this.currentTag).isMandatory()) {
                if (this.imagesWithTags.get(this.mTagList.get(this.currentTag)) == null || this.imagesWithTags.get(this.mTagList.get(this.currentTag)).size() == 0) {
                    Toast.makeText((Context)this, (CharSequence)String.format(this.getString(R.string.tag_mandatory_error), this.mTagList.get(this.currentTag).getTagName()), (int)0).show();
                } else {
                    ++this.currentTag;
                }
            } else {
                ++this.currentTag;
            }
        } else if (this.currentTag < this.mTagList.size() && !this.mTagList.get(this.currentTag).isMandatory()) {
            ++this.currentTag;
        } else {
            Toast.makeText((Context)this, (CharSequence)String.format(this.getString(R.string.tag_mandatory_error), this.mTagList.get(this.currentTag).getTagName()), (int)0).show();
        }
        if (this.currentTag == this.mTagList.size() - 1) {
            this.tvNext.setText((CharSequence)this.getString(R.string.finish));
        }
        if (this.currentTag == this.mTagList.size()) {
            if (this.photoParams.isTagEnabled()) {
                this.onPicturesFinalized(this.imagesWithTags);
            } else {
                this.onPicturesFinalized(this.imagesList);
            }
            return this.mTagList.get(this.currentTag - 1);
        }
        return this.mTagList.get(this.currentTag);
    }

    public ImageTagModel getPreviousTag() {
        if (this.currentTag > 0) {
            --this.currentTag;
        }
        return this.mTagList.get(this.currentTag);
    }

    private void enableDoneButton(boolean enable) {
        this.buttonCapture.setImageResource(enable ? R.drawable.ic_camera_switch : R.drawable.ic_camera);
        this.buttonCapture.setTag((Object)(enable ? this.getString(R.string.done) : this.getString(R.string.capture)));
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("imagesSelected", this.imagesList);
    }

    private void handleCameraButtons(FileInfo fileInfo) {
        if (this.maxNumberOfImages == 1) {
            this.buttonCapture.setTag((Object)"done");
            this.onClick((View)this.buttonCapture);
        } else {
            if (this.imagesList.size() >= 1 && this.photoParams.isCameraHorizontalPreviewEnabled()) {
                this.scrollView.setVisibility(0);
                this.addInScrollView(fileInfo);
            } else {
                this.scrollView.setVisibility(8);
            }
            if (this.maxNumberOfImages > 0) {
                this.updateView(this.imagesList.size() < this.maxNumberOfImages);
            }
            this.mFragment.startPreview();
            this.buttonCapture.setEnabled(true);
        }
    }

    private void updateView(boolean status) {
        if (!status) {
            this.buttonCapture.setVisibility(8);
        } else {
            this.buttonCapture.setVisibility(0);
        }
        this.buttonDone.setVisibility(0);
        this.tvImageName.setText((CharSequence)(status ? this.imageName : this.getString(R.string.press_done)));
    }

    private void addInScrollView(ArrayList<FileInfo> infos) {
        if (infos != null && infos.size() > 0) {
            for (FileInfo info : infos) {
                this.scrollView.addView(this.createImageView(info));
            }
            this.scrollView.setVisibility(0);
        }
    }

    private void addInScrollView(FileInfo info) {
        this.scrollView.addView(this.createImageView(info));
        this.scrollView.setVisibility(0);
    }

    private View createImageView(final FileInfo info) {
        File file = new File(info.getFilePath());
        if (!file.exists()) {
            return null;
        }
        final View outerView = View.inflate((Context)this, (int)R.layout.camera_priority_overlay, null);
        outerView.findViewById(R.id.ivRemoveImage).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CameraActivity1.this.scrollView.removeView(outerView);
                CameraActivity1.this.imagesList.remove(info);
                if (CameraActivity1.this.maxNumberOfImages > 0) {
                    CameraActivity1.this.updateView(CameraActivity1.this.imagesList.size() < CameraActivity1.this.maxNumberOfImages);
                }
                if (CameraActivity1.this.imagesList.size() < 1) {
                    CameraActivity1.this.buttonDone.setVisibility(8);
                    CameraActivity1.this.scrollView.setVisibility(8);
                }
            }
        });
        Glide.with((FragmentActivity)this).load("file://" + info.getFilePath()).diskCacheStrategy(DiskCacheStrategy.ALL).crossFade().centerCrop().placeholder(R.drawable.image_load_default_small).into((ImageView)outerView.findViewById(R.id.ivCaptured));
        return outerView;
    }

    @Override
    public void onPictureTaken(String filePath) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(filePath);
        fileInfo.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileInfo.setDisplayName(this.imageName);
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        if (this.photoParams.isTagEnabled()) {
            if (this.imagesWithTags.get(this.mTagList.get(this.currentTag)) == null) {
                ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
                fileInfos.add(fileInfo);
                this.imagesWithTags.put(this.mTagList.get(this.currentTag), fileInfos);
            } else {
                List<FileInfo> listFiles = this.imagesWithTags.get(this.mTagList.get(this.currentTag));
                listFiles.add(fileInfo);
                this.imagesWithTags.put(this.mTagList.get(this.currentTag), listFiles);
            }
        } else {
            this.imagesList.add(fileInfo);
            this.handleCameraButtons(fileInfo);
        }
    }

    @Override
    public void onPicturesFinalized(ArrayList<FileInfo> infos) {
        this.getSupportFragmentManager().popBackStackImmediate();
        if (infos.size() > 0) {
            this.setResult(-1, new Intent().putExtra("images", infos));
            this.finish();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.click_photo), (int)0).show();
        }
    }

    @Override
    public void onPicturesFinalized(Map<ImageTagModel, List<FileInfo>> filesMap) {
        this.setResult(-1, new Intent().putExtra("images", this.imagesWithTags));
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == 99) {
            this.imagesList = (ArrayList)data.getSerializableExtra("galleryPhotos");
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.buttonCapture) {
            if (v.getTag().equals("capture")) {
                this.mFragment.clickPicture();
            } else if (v.getTag().equals("done")) {
                if (this.photoParams.isTagEnabled()) {
                    this.onPicturesFinalized(this.imagesWithTags);
                } else {
                    this.onPicturesFinalized(this.imagesList);
                }
            }
        } else if (v.getId() == R.id.buttonGallery) {
            Intent intent = new Intent((Context)this, GalleryActivity.class);
            intent.setFlags(0x4000000);
            intent.putExtra("maxCount", this.maxNumberOfImages);
            intent.putExtra("photoParams", (Serializable)this.photoParams);
            this.startActivityForResult(intent, 99);
        } else if (v.getId() == R.id.buttonDone) {
            if (!this.photoParams.isTagEnabled()) {
                if (this.imagesList.size() == 0) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.no_images), (int)0).show();
                } else {
                    this.buttonCapture.setTag((Object)"done");
                    this.onClick((View)this.buttonCapture);
                }
            } else {
                this.buttonCapture.setTag((Object)"done");
                this.onClick((View)this.buttonCapture);
            }
        } else if (v.getId() == R.id.tvSkip) {
            this.setTag(this.getNextTag());
            AnimationUtils.translateOnXAxis((View)this.tvTag, 200, 0);
        }
    }
}

