/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.gaadi.neon.util.Constants;
import com.scanlibrary.R;
import java.io.File;

public class ReviewImageActivity
extends AppCompatActivity
implements View.OnClickListener {
    protected Toolbar toolbar;
    private String imagePath;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        this.imagePath = extras.getString("image_path");
        String imageName = "";
        this.supportRequestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.review_image_activity);
        RelativeLayout relativeLayout = (RelativeLayout)this.findViewById(R.id.relativeLayout);
        this.toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.toolbar.setTitle((CharSequence)"");
        TextView tvImageName = (TextView)this.findViewById(R.id.imageName);
        boolean flag = extras.getBoolean(Constants.FLAG);
        if (flag) {
            this.toolbar.setVisibility(0);
            this.setSupportActionBar(this.toolbar);
            if (this.getSupportActionBar() != null) {
                this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            }
            tvImageName.setVisibility(8);
            Drawable upArrow = ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_action_done);
            upArrow.setColorFilter(ContextCompat.getColor((Context)this, (int)R.color.white), PorterDuff.Mode.SRC_ATOP);
            this.getSupportActionBar().setHomeAsUpIndicator(upArrow);
            relativeLayout.setVisibility(8);
        } else {
            this.toolbar.setVisibility(8);
            tvImageName.setVisibility(0);
            ImageView bDone = (ImageView)this.findViewById(R.id.bDone);
            ImageView bCancel = (ImageView)this.findViewById(R.id.bCancel);
            relativeLayout.setVisibility(0);
            bCancel.setOnClickListener((View.OnClickListener)this);
            bDone.setOnClickListener((View.OnClickListener)this);
        }
        ImageView ivReview = (ImageView)this.findViewById(R.id.ivReviewImage);
        tvImageName.setVisibility(0);
        tvImageName.setText((CharSequence)imageName);
        if (this.imagePath != null) {
            Glide.with((FragmentActivity)this).load(this.imagePath).into(ivReview);
        }
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.bDone) {
            FragmentManager manager = this.getSupportFragmentManager();
            manager.popBackStackImmediate();
            Intent intent = new Intent();
            intent.putExtra("image_path", this.imagePath);
            this.setResult(-1, intent);
            this.finish();
        } else if (id2 == R.id.bCancel) {
            Uri uri = Uri.parse((String)this.imagePath);
            File fdelete = new File(uri.getPath());
            if (fdelete.exists()) {
                if (fdelete.delete()) {
                    System.out.println("file Deleted :" + this.imagePath);
                } else {
                    System.out.println("file not Deleted :" + this.imagePath);
                }
            }
            this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", uri));
            this.setResult(0);
            this.finish();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
            }
        }
        return true;
    }
}

