/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.location.Location;
import android.support.media.ExifInterface;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ExifInterfaceHandling
extends ExifInterface {
    public ExifInterfaceHandling(File file) throws IOException {
        super(file.getCanonicalPath());
    }

    public void setLocation(Location location) {
        try {
            Date date = new Date(location.getTime());
            String dateStamp = new SimpleDateFormat("yyyy:MM:dd").format(date);
            String timeStamp = new SimpleDateFormat("hh:mm:ss").format(date);
            this.setAttribute("GPSLatitudeRef", String.valueOf(location.getLatitude()));
            this.setAttribute("GPSLongitudeRef", String.valueOf(location.getLongitude()));
            this.setAttribute("GPSDateStamp", dateStamp);
            this.setAttribute("GPSTimeStamp", timeStamp);
            this.setAttribute("DateTime", String.valueOf(date.getTime()));
            this.saveAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

