/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import com.gaadi.neon.activity.NeonBaseActivity;
import com.gaadi.neon.adapter.ImagesReviewViewPagerAdapter;
import com.gaadi.neon.events.ImageEditEvent;
import com.gaadi.neon.interfaces.FragmentListener;
import com.gaadi.neon.model.NeonResponse;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;

public class ImageReviewActivity
extends NeonBaseActivity
implements View.OnClickListener,
FragmentListener {
    private ImagesReviewViewPagerAdapter mPagerAdapter;
    private ViewPager mPager;
    private ImageView viewPagerRightBtn;
    private ImageView viewPagerLeftBtn;
    private boolean singleTagSelection;

    public boolean isSingleTagSelection() {
        return this.singleTagSelection;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_review);
        this.toolbar = (Toolbar)this.findViewById(R.id.tool_bar);
        this.setSupportActionBar(this.toolbar);
        this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.ic_left_arrow);
        this.toolbar.setNavigationIcon(R.drawable.ic_left_arrow);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.mPager = (ViewPager)this.findViewById(R.id.pager);
        this.viewPagerLeftBtn = (ImageView)this.findViewById(R.id.view_pager_leftbtn);
        this.viewPagerRightBtn = (ImageView)this.findViewById(R.id.view_pager_rightbtn);
        this.viewPagerRightBtn.setOnClickListener((View.OnClickListener)this);
        this.viewPagerLeftBtn.setOnClickListener((View.OnClickListener)this);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.setTitle(R.string.image_review);
        Intent intent = this.getIntent();
        this.singleTagSelection = intent.getBooleanExtra("singleTagSelection", false);
        int position = intent.getIntExtra("imageReviewPosition", 0);
        if (position == 0) {
            this.viewPagerLeftBtn.setVisibility(8);
        }
        if (position == NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1) {
            this.viewPagerRightBtn.setVisibility(8);
        }
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            this.viewPagerLeftBtn.setVisibility(8);
            this.viewPagerRightBtn.setVisibility(8);
        }
        this.mPagerAdapter = new ImagesReviewViewPagerAdapter(this.getSupportFragmentManager());
        this.mPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mPager.setCurrentItem(position);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageReviewActivity.this.setArrowButton(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void setArrowButton(int position) {
        if (position == 0 || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() == 1) {
            this.viewPagerLeftBtn.setVisibility(8);
        } else {
            this.viewPagerLeftBtn.setVisibility(0);
        }
        if (position == NeonImagesHandler.getSingleonInstance().getImagesCollection().size() - 1 || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() == 1) {
            this.viewPagerRightBtn.setVisibility(8);
        } else {
            this.viewPagerRightBtn.setVisibility(0);
        }
    }

    @Override
    public void getFragmentChanges(ImageEditEvent event) {
        boolean isViewDirty = false;
        if (event.getImageEventType() == 1) {
            isViewDirty = true;
            NeonImagesHandler.getSingletonInstance().removeFromCollection(event.getPosition());
            this.mPagerAdapter.setPagerItems();
            if (NeonImagesHandler.getSingletonInstance().getImagesCollection().size() == 0) {
                super.onBackPressed();
            }
            this.setArrowButton(this.mPager.getCurrentItem());
        } else if (event.getImageEventType() == 2) {
            isViewDirty = true;
        } else if (event.getImageEventType() == 3) {
            isViewDirty = true;
        } else if (event.getImageEventType() == 5) {
            isViewDirty = true;
        } else if (event.getImageEventType() == 4) {
            NeonImagesHandler.getSingletonInstance().getImagesCollection().set(event.getPosition(), event.getModel());
        }
    }

    public void onClick(View v) {
        int position;
        int id2 = v.getId();
        if (id2 == R.id.image_review_toolbar_doneBtn) {
            this.finish();
        } else if (id2 == R.id.view_pager_leftbtn) {
            int position2 = this.mPager.getCurrentItem();
            if (position2 > 0) {
                this.mPager.setCurrentItem(--position2);
            }
        } else if (id2 == R.id.view_pager_rightbtn && (position = this.mPager.getCurrentItem()) < NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1) {
            this.mPager.setCurrentItem(++position);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_view_pager, menu2);
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null && menu2 != null) {
            menu2.findItem(R.id.menu_done).setVisible(false);
            menu2.findItem(R.id.menu_retry).setVisible(true);
            menu2.findItem(R.id.menu_apply).setVisible(true);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public void onBackPressed() {
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            NeonImagesHandler.getSingletonInstance().removeFromCollection(NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1);
        }
        super.onBackPressed();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                    NeonImagesHandler.getSingletonInstance().removeFromCollection(NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1);
                }
                super.onBackPressed();
                return true;
            }
        }
        if (item.getItemId() == R.id.menu_done) {
            super.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.menu_apply) {
            boolean isUpdate = true;
            if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                int pos = NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1;
                isUpdate = NeonImagesHandler.getSingletonInstance().getLivePhotoNextTagListener().updateExifInfo(NeonImagesHandler.getSingletonInstance().getImagesCollection().get(pos));
                if (isUpdate) {
                    NeonResponse neonResponse = new NeonResponse();
                    neonResponse.setImageCollection(NeonImagesHandler.getSingletonInstance().getImagesCollection());
                    NeonImagesHandler.getSingletonInstance().getLivePhotosListener().onLivePhotoCollected(neonResponse);
                    NeonImagesHandler.getSingletonInstance().getLivePhotoNextTagListener().onNextTag();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"Finding location.Please wait.", (int)0).show();
                }
            }
            if (isUpdate) {
                super.onBackPressed();
            }
            return true;
        }
        if (item.getItemId() == R.id.menu_retry) {
            if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                NeonImagesHandler.getSingletonInstance().removeFromCollection(NeonImagesHandler.getSingletonInstance().getImagesCollection().size() - 1);
            }
            super.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

