/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.widget.Toast;
import com.gaadi.neon.activity.NeonBaseActivity;
import com.gaadi.neon.model.BucketModel;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.util.ArrayList;

public abstract class NeonBaseGalleryActivity
extends NeonBaseActivity {
    private Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    private ArrayList<BucketModel> buckets;

    protected ArrayList<BucketModel> getImageBuckets() {
        this.buckets = new ArrayList();
        String[] PROJECTION_BUCKET = new String[]{"bucket_display_name", "bucket_id", "_data"};
        String orderBy = "datetaken DESC";
        Cursor mCursor = NeonImagesHandler.getSingleonInstance().getGalleryParam() != null && NeonImagesHandler.getSingleonInstance().getGalleryParam().isRestrictedExtensionJpgPngEnabled() ? this.getContentResolver().query(this.uri, PROJECTION_BUCKET, "mime_type in (?, ?)", new String[]{"image/jpeg", "image/png"}, orderBy) : this.getContentResolver().query(this.uri, PROJECTION_BUCKET, null, null, orderBy);
        if (mCursor == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.gallery_error), (int)0).show();
            this.finish();
            return null;
        }
        mCursor.moveToFirst();
        if (mCursor.getCount() > 0) {
            do {
                String bucketId;
                int index;
                if ((index = this.getBucketIndexWithId(bucketId = mCursor.getString(mCursor.getColumnIndex("bucket_id")))) == -1) {
                    BucketModel bucketModel = new BucketModel();
                    bucketModel.setBucketId(bucketId);
                    bucketModel.setBucketName(mCursor.getString(mCursor.getColumnIndex("bucket_display_name")));
                    bucketModel.setFileCount(1);
                    bucketModel.setBucketCoverImagePath(mCursor.getString(mCursor.getColumnIndex("_data")));
                    this.buckets.add(bucketModel);
                    continue;
                }
                this.buckets.get(index).setFileCount(this.buckets.get(index).getFileCount() + 1);
            } while (mCursor.moveToNext());
        }
        mCursor.close();
        return this.buckets;
    }

    protected ArrayList<FileInfo> getFileFromBucketId(String bucketId) {
        Cursor mCursor;
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        String[] PROJECTION_FILES = new String[]{"bucket_display_name", "bucket_id", "_data", "datetaken"};
        String orderBy = "datetaken DESC";
        String selection = "bucket_id =? and _size >?";
        String[] selectionArgs = new String[]{bucketId, String.valueOf(0)};
        if (bucketId == null) {
            selection = null;
            selectionArgs = null;
        }
        if ((mCursor = this.getContentResolver().query(this.uri, PROJECTION_FILES, selection, selectionArgs, orderBy)) == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.gallery_error), (int)0).show();
            this.finish();
            return null;
        }
        mCursor.moveToFirst();
        if (mCursor.getCount() > 0) {
            do {
                FileInfo singleFileInfo = new FileInfo();
                singleFileInfo.setSource(FileInfo.SOURCE.PHONE_GALLERY);
                singleFileInfo.setFilePath(mCursor.getString(mCursor.getColumnIndex("_data")));
                singleFileInfo.setDateTimeTaken(mCursor.getString(mCursor.getColumnIndex("datetaken")));
                singleFileInfo.setType(FileInfo.FILE_TYPE.IMAGE);
                fileInfos.add(singleFileInfo);
            } while (mCursor.moveToNext());
        }
        mCursor.close();
        return fileInfos;
    }

    private int getBucketIndexWithId(String id2) {
        if (this.buckets == null || this.buckets.size() <= 0) {
            return -1;
        }
        for (int i = 0; i < this.buckets.size(); ++i) {
            if (!this.buckets.get(i).getBucketId().equals(id2)) continue;
            return i;
        }
        return -1;
    }
}

