/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.neon.activity.CameraActivity1;
import com.gaadi.neon.activity.GalleryActivity;
import com.gaadi.neon.activity.ImageReviewActivity;
import com.gaadi.neon.adapter.PhotosGridAdapter;
import com.gaadi.neon.interfaces.UpdateSelection;
import com.gaadi.neon.util.ApplicationController;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonUtils;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.io.Serializable;
import java.util.ArrayList;

public class NeutralFragment
extends Fragment
implements View.OnClickListener,
UpdateSelection,
AdapterView.OnItemClickListener {
    public static final String ADD_PHOTOS = "addPhotos";
    public static final String UPDATE_GRID = "update_grid";
    public static final String IMG_LOAD_DEF_BIG = "IMG_LOAD_DEF_BIG";
    public static final String IMG_LOAD_DEF_SMALL = "IMG_LOAD_DEF_SMALL";
    public static final String PHOTO_PARAMS = "photoParams";
    private static final int OPEN_IMAGE_VIEW_PAGER_SCREEN = 102;
    private static final String SELECTED_IMAGES = "alreadySelected";
    public static int CODE_CAMERA = 148;
    public static int loadDefImgBig;
    public static int loadDefImgSmall;
    private int maxPhotos = 20;
    private TextView tvCount;
    private GridView gvPhotos;
    private PhotosGridAdapter photosGridAdapter;
    private PhotoParams params;
    private ArrayList<FileInfo> cameraItemsFiles = new ArrayList();
    private Context context;

    public static NeutralFragment newInstance(Context context, PhotoParams params, ArrayList<?> uploadedImages, int loadDefaultResBig, int loadDefaultResSmall) {
        NeutralFragment fragment = new NeutralFragment();
        Bundle bundle = new Bundle();
        bundle.putSerializable(PHOTO_PARAMS, (Serializable)params);
        bundle.putSerializable(SELECTED_IMAGES, uploadedImages);
        bundle.putInt(IMG_LOAD_DEF_BIG, loadDefaultResBig);
        bundle.putInt(IMG_LOAD_DEF_SMALL, loadDefaultResSmall);
        fragment.setArguments(bundle);
        fragment.context = context;
        return fragment;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Intent intent = new Intent((Context)this.getActivity(), ImageReviewActivity.class);
        intent.putExtra("imageModelReview", this.cameraItemsFiles);
        intent.putExtra("imageReviewPosition", position);
        intent.addFlags(0x24000000);
        this.startActivityForResult(intent, 102);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.neutral_fragment, container, false);
        rootView.findViewById(R.id.addPhotoCamera).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.addPhotoGallary).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.done).setOnClickListener((View.OnClickListener)this);
        rootView.findViewById(R.id.ivBack).setOnClickListener((View.OnClickListener)this);
        this.tvCount = (TextView)rootView.findViewById(R.id.photosCount);
        this.params = (PhotoParams)this.getArguments().getSerializable(PHOTO_PARAMS);
        loadDefImgBig = this.getArguments().getInt(IMG_LOAD_DEF_BIG);
        loadDefImgSmall = this.getArguments().getInt(IMG_LOAD_DEF_SMALL);
        this.setUpPhotosGrid(rootView);
        if (this.params.getNoOfPhotos() > 0) {
            this.maxPhotos = this.params.getNoOfPhotos();
        }
        return rootView;
    }

    public void onResume() {
        super.onResume();
        this.tvCount.setText((CharSequence)String.valueOf(this.cameraItemsFiles.size()));
    }

    private void setUpPhotosGrid(View rootView) {
        this.gvPhotos = (GridView)rootView.findViewById(R.id.gvImages);
        this.gvPhotos.setAdapter((ListAdapter)this.photosGridAdapter);
        this.gvPhotos.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                Intent intent = new Intent((Context)NeutralFragment.this.getActivity(), ImageReviewActivity.class);
                intent.putExtra("imageModelReview", (Serializable)NeutralFragment.this.cameraItemsFiles);
                intent.putExtra("imageReviewPosition", position);
                intent.addFlags(0x24000000);
                NeutralFragment.this.startActivityForResult(intent, 102);
            }
        });
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.cameraItemsFiles.clear();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        assert (this.getView() != null);
        switch (requestCode) {
            case 148: {
                if (data == null) break;
                ArrayList cameraList = (ArrayList)data.getSerializableExtra("images");
                this.updateGrid(cameraList, ADD_PHOTOS);
                break;
            }
            case 256: {
                if (data == null) break;
                ArrayList galleryList = (ArrayList)data.getSerializableExtra("galleryPhotos");
                this.setSource(galleryList, FileInfo.SOURCE.PHONE_GALLERY);
                this.checkForDeletedFiles(this.cameraItemsFiles);
                this.updateGrid(galleryList, ADD_PHOTOS);
                break;
            }
            case 104: {
                this.onClick(this.getView().findViewById(R.id.addPhotoCamera));
                break;
            }
            case 105: {
                this.onClick(this.getView().findViewById(R.id.addPhotoGallary));
                break;
            }
            case 102: {
                ArrayList galleryList = (ArrayList)data.getSerializableExtra("imageModelReview");
                this.setSource(galleryList, FileInfo.SOURCE.PHONE_GALLERY);
                this.checkForDeletedFiles(galleryList);
                this.updateGrid(galleryList, ADD_PHOTOS);
            }
        }
    }

    private void checkForDeletedFiles(ArrayList<FileInfo> cameraItemsFiles) {
        ArrayList<FileInfo> deleteFiles = new ArrayList<FileInfo>();
        for (FileInfo fileInfo : cameraItemsFiles) {
            if (fileInfo.getSource() != FileInfo.SOURCE.PHONE_GALLERY || ApplicationController.selectedFiles == null || ApplicationController.selectedFiles.contains(fileInfo.getFilePath())) continue;
            deleteFiles.add(fileInfo);
        }
        cameraItemsFiles.removeAll(deleteFiles);
    }

    private void setSource(ArrayList<FileInfo> list1, FileInfo.SOURCE phoneGallery) {
        for (FileInfo fileInfo : list1) {
            fileInfo.setSource(phoneGallery);
        }
    }

    private void updateGrid(ArrayList<FileInfo> listAdd, String action) {
        if (action.equals(ADD_PHOTOS)) {
            NeonUtils.removeFileInfo(listAdd, this.cameraItemsFiles);
            this.cameraItemsFiles.addAll(listAdd);
            this.photosGridAdapter.notifyDataSetChanged();
        } else if (action.equals(UPDATE_GRID)) {
            this.cameraItemsFiles.clear();
            this.cameraItemsFiles.addAll(listAdd);
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.addPhotoCamera) {
            if (Build.VERSION.SDK_INT >= 23 && !NeonUtils.checkForPermission(this.context, new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"}, 104, "Camera and Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            Intent intent = new Intent((Context)this.getActivity(), CameraActivity1.class);
            intent.putExtra("maxCount", this.maxPhotos - this.cameraItemsFiles.size());
            intent.setFlags(0x4000000);
            intent.putExtra(PHOTO_PARAMS, (Serializable)this.params);
            this.startActivityForResult(intent, CODE_CAMERA);
        } else if (v.getId() == R.id.addPhotoGallary) {
            if (Build.VERSION.SDK_INT >= 23 && !NeonUtils.checkForPermission(this.context, new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, 105, "Storage")) {
                return;
            }
            if (this.cameraItemsFiles.size() >= this.maxPhotos) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)("Maximum photos can be : " + this.maxPhotos), (int)0).show();
                return;
            }
            Intent intent1 = new Intent((Context)this.getActivity(), GalleryActivity.class);
            intent1.putExtra(PHOTO_PARAMS, (Serializable)this.params);
            intent1.setFlags(0x4000000);
            this.startActivityForResult(intent1, 256);
        } else if (v.getId() == R.id.done) {
            this.getActivity().setResult(-1, new Intent().putExtra("images", this.cameraItemsFiles));
            this.getActivity().finish();
        } else if (v.getId() == R.id.ivBack) {
            try {
                if (ApplicationController.selectedFiles != null) {
                    ApplicationController.selectedFiles.clear();
                }
            }
            catch (Exception e) {
                Log.d((String)"", (String)("onClick: " + e.getLocalizedMessage()));
            }
            finally {
                this.getActivity().finish();
            }
        }
    }

    @Override
    public void updateSelected(String imagePath, Boolean selected) {
        if (!selected.booleanValue()) {
            for (FileInfo fileInfo1 : this.cameraItemsFiles) {
                if (!fileInfo1.getFilePath().equals(imagePath)) continue;
                this.cameraItemsFiles.remove(fileInfo1);
                if (ApplicationController.selectedFiles == null) break;
                ApplicationController.selectedFiles.remove(imagePath);
                break;
            }
            this.tvCount.setText((CharSequence)String.valueOf(this.cameraItemsFiles.size()));
        }
    }
}

