/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.ImageReviewActivity;
import com.gaadi.neon.activity.neutral.NeonNeutralActivity;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;

public class ImageShowAdapter
extends BaseAdapter {
    private Context context;

    public ImageShowAdapter(Context activity) {
        this.context = activity;
    }

    public int getCount() {
        if (NeonImagesHandler.getSingleonInstance().getImagesCollection() != null) {
            return NeonImagesHandler.getSingleonInstance().getImagesCollection().size();
        }
        return 0;
    }

    public Object getItem(int position) {
        return NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        PhotosHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.context, (int)R.layout.display_images, null);
            holder = new PhotosHolder();
            holder.image = (ImageView)convertView.findViewById(R.id.ivImageDisplay);
            holder.removeImage = (ImageView)convertView.findViewById(R.id.ivRemoveImage);
            holder.tvProfile = (TextView)convertView.findViewById(R.id.tvProfilePhoto);
            convertView.setTag((Object)holder);
        } else {
            holder = (PhotosHolder)convertView.getTag();
        }
        if (!NeonImagesHandler.getSingleonInstance().getGenericParam().getTagEnabled()) {
            holder.tvProfile.setVisibility(8);
        } else {
            holder.tvProfile.setVisibility(0);
        }
        if (NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFileTag() != null) {
            holder.tvProfile.setText((CharSequence)NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFileTag().getTagName());
        } else {
            holder.tvProfile.setText(R.string.select_tag);
        }
        holder.removeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NeonImagesHandler.getSingleonInstance().removeFromCollection(position)) {
                    ImageShowAdapter.this.notifyDataSetChanged();
                    if ((NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) && ImageShowAdapter.this.context instanceof NeonNeutralActivity) {
                        ((NeonNeutralActivity)ImageShowAdapter.this.context).onPostResume();
                    }
                } else {
                    Toast.makeText((Context)ImageShowAdapter.this.context, (CharSequence)"Failed to delete.Please try again later.", (int)0).show();
                }
            }
        });
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent viewPagerIntent = new Intent(ImageShowAdapter.this.context, ImageReviewActivity.class);
                viewPagerIntent.putExtra("imageReviewPosition", position);
                ImageShowAdapter.this.context.startActivity(viewPagerIntent);
            }
        });
        Glide.with((Context)this.context).load(NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFilePath()).crossFade().placeholder(R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.image);
        return convertView;
    }

    private class PhotosHolder {
        ImageView image;
        ImageView removeImage;
        TextView tvProfile;

        private PhotosHolder() {
        }
    }
}

