/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.widget.Toast;
import com.gaadi.neon.fragment.CameraFragment;
import com.gaadi.neon.fragment.CameraFragment1;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.io.File;
import java.util.ArrayList;

public class CameraActivity
extends AppCompatActivity
implements CameraFragment.PictureTakenListener {
    public static final int GALLERY_PICK = 99;
    private static final String TAG = "CameraActivity";
    public boolean readyToTakePicture;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private ArrayList<String> outputImages = new ArrayList();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_priority_items);
        PhotoParams photoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        CameraFragment1 fragment = new CameraFragment1();
        FragmentManager manager = this.getSupportFragmentManager();
        manager.beginTransaction().replace(R.id.content_frame, (Fragment)fragment).commit();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("imagesSelected", this.imagesList);
    }

    @Override
    public void onPictureTaken(String filePath) {
        this.outputImages.clear();
        this.outputImages.add(filePath);
        this.setResult(-1, new Intent().putStringArrayListExtra("result_images", this.outputImages));
        this.finish();
    }

    @Override
    public void onPicturesFinalized(ArrayList<FileInfo> infos) {
        this.getSupportFragmentManager().popBackStackImmediate();
        if (infos.size() > 0) {
            Log.d((String)TAG, (String)("onPicturesFinalized: " + infos.get(0).getFilePath()));
            this.setResult(-1, new Intent().putExtra("images", infos));
            this.finish();
        } else {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.click_photo), (int)0).show();
        }
    }

    @Override
    public void sendPictureForCropping(File file) {
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 99) {
                this.imagesList = (ArrayList)data.getSerializableExtra("galleryPhotos");
            } else {
                this.readyToTakePicture = true;
            }
        } else if (resultCode == 0) {
            // empty if block
        }
    }
}

