/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.camera.NeonBaseCameraActivity;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.fragment.CameraFragment1;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.OnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.AnimationUtils;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.PermissionType;
import com.scanlibrary.R;
import com.scanlibrary.databinding.NormalCameraActivityLayoutBinding;
import java.util.ArrayList;
import java.util.List;

public class NormalCameraActivityNeon
extends NeonBaseCameraActivity
implements CameraFragment1.SetOnPictureTaken {
    ICameraParam cameraParams;
    RelativeLayout tagsLayout;
    List<ImageTagModel> tagModels;
    int currentTag;
    NormalCameraActivityLayoutBinding binder;
    private TextView tvImageName;
    private TextView tvTag;
    private TextView tvNext;
    private TextView tvPrevious;
    private ImageView buttonGallery;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        this.cameraParams = NeonImagesHandler.getSingleonInstance().getCameraParam();
        this.customize();
        this.bindCameraFragment();
    }

    private void bindCameraFragment() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new OnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        try {
                            NormalCameraActivityNeon.this.askForPermissionIfNeeded(PermissionType.camera, new OnPermissionResultListener(){

                                @Override
                                public void onResult(boolean permissionGranted) {
                                    if (permissionGranted) {
                                        new Handler().post(new Runnable(){

                                            @Override
                                            public void run() {
                                                CameraFragment1 fragment = new CameraFragment1();
                                                FragmentManager manager = NormalCameraActivityNeon.this.getSupportFragmentManager();
                                                manager.beginTransaction().replace(R.id.content_frame, (Fragment)fragment).commit();
                                            }
                                        });
                                    } else {
                                        Toast.makeText((Context)NormalCameraActivityNeon.this, (int)R.string.permission_error, (int)0).show();
                                    }
                                }
                            });
                        }
                        catch (ManifestPermission manifestPermission) {
                            manifestPermission.printStackTrace();
                        }
                    } else {
                        Toast.makeText((Context)NormalCameraActivityNeon.this, (int)R.string.permission_error, (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }

    private void bindXml() {
        this.binder = (NormalCameraActivityLayoutBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.normal_camera_activity_layout);
        this.tvImageName = this.binder.tvImageName;
        this.tvTag = this.binder.tvTag;
        this.tvNext = this.binder.tvSkip;
        this.tvPrevious = this.binder.tvPrev;
        this.buttonGallery = this.binder.buttonGallery;
        this.tagsLayout = this.binder.rlTags;
        this.binder.setHandlers(this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.buttonDone) {
            if (!NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
                Intent intent = new Intent((Context)this, ImageShow.class);
                this.startActivity(intent);
                this.finish();
            } else {
                this.setResult(-1);
                this.finish();
            }
        } else if (id2 == R.id.buttonGallery) {
            try {
                IGalleryParam galleryParam = NeonImagesHandler.getSingleonInstance().getGalleryParam();
                if (galleryParam == null) {
                    galleryParam = new IGalleryParam(){

                        @Override
                        public boolean selectVideos() {
                            return false;
                        }

                        @Override
                        public GalleryType getGalleryViewType() {
                            return GalleryType.Grid_Structure;
                        }

                        @Override
                        public boolean enableFolderStructure() {
                            return true;
                        }

                        @Override
                        public boolean galleryToCameraSwitchEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isRestrictedExtensionJpgPngEnabled() {
                            return true;
                        }

                        @Override
                        public int getNumberOfPhotos() {
                            return NeonImagesHandler.getSingleonInstance().getCameraParam().getNumberOfPhotos();
                        }

                        @Override
                        public boolean getTagEnabled() {
                            return NeonImagesHandler.getSingleonInstance().getCameraParam().getTagEnabled();
                        }

                        @Override
                        public List<ImageTagModel> getImageTagsModel() {
                            return NeonImagesHandler.getSingleonInstance().getCameraParam().getImageTagsModel();
                        }

                        public ArrayList<FileInfo> getAlreadyAddedImages() {
                            return null;
                        }
                    };
                }
                PhotosLibrary.collectPhotos((Context)this, PhotosMode.setGalleryMode().setParams(galleryParam), NeonImagesHandler.getSingleonInstance().getImageResultListener());
                this.finish();
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
        } else if (id2 == R.id.tvSkip) {
            if (this.currentTag == this.tagModels.size() - 1) {
                this.onClick((View)this.binder.buttonDone);
            } else {
                this.setTag(this.getNextTag(), true);
            }
        } else if (id2 == R.id.tvPrev) {
            this.setTag(this.getPreviousTag(), false);
        }
    }

    private boolean finishValidation() {
        if (NeonImagesHandler.getSingleonInstance().getCameraParam().getTagEnabled()) {
            for (int i = 0; i < this.tagModels.size(); ++i) {
                if (!this.tagModels.get(i).isMandatory() || NeonImagesHandler.getSingleonInstance().checkImagesAvailableForTag(this.tagModels.get(i))) continue;
                Toast.makeText((Context)this, (CharSequence)String.format(this.getString(R.string.tag_mandatory_error), this.tagModels.get(i).getTagName()), (int)0).show();
                return false;
            }
        } else {
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
                Toast.makeText((Context)this, (int)R.string.no_images, (int)0).show();
                return false;
            }
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection().size() < NeonImagesHandler.getSingleonInstance().getCameraParam().getNumberOfPhotos()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.more_images, new Object[]{NeonImagesHandler.getSingleonInstance().getCameraParam().getNumberOfPhotos() - NeonImagesHandler.getSingleonInstance().getImagesCollection().size()}), (int)0).show();
                return false;
            }
        }
        return true;
    }

    public ImageTagModel getNextTag() {
        ++this.currentTag;
        if (this.currentTag == this.tagModels.size() - 1) {
            this.tvNext.setText((CharSequence)this.getString(R.string.finish));
        }
        if (this.currentTag > 0) {
            this.tvPrevious.setVisibility(0);
        }
        return this.tagModels.get(this.currentTag);
    }

    public ImageTagModel getPreviousTag() {
        if (this.currentTag > 0) {
            --this.currentTag;
        }
        if (this.currentTag != this.tagModels.size() - 1) {
            this.tvNext.setText((CharSequence)this.getString(R.string.next));
        }
        if (this.currentTag == 0) {
            this.tvPrevious.setVisibility(8);
        }
        return this.tagModels.get(this.currentTag);
    }

    public void setTag(ImageTagModel imageTagModel, boolean rightToLeft) {
        this.tvTag.setText((CharSequence)imageTagModel.getTagName());
        if (rightToLeft) {
            AnimationUtils.translateOnXAxis((View)this.tvTag, 200, 0);
        } else {
            AnimationUtils.translateOnXAxis((View)this.tvTag, -200, 0);
        }
    }

    private void customize() {
        if (this.cameraParams.getTagEnabled()) {
            this.tvImageName.setVisibility(8);
            this.tagsLayout.setVisibility(0);
            this.tagModels = this.cameraParams.getImageTagsModel();
            this.initialiazeCurrentTag();
            this.setTag(this.tagModels.get(this.currentTag), true);
        } else {
            this.tagsLayout.setVisibility(8);
            this.findViewById(R.id.rlTags).setVisibility(8);
        }
        this.buttonGallery.setVisibility(this.cameraParams.cameraToGallerySwitchEnabled() ? 0 : 8);
    }

    private void initialiazeCurrentTag() {
        for (int i = 0; i < NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().size(); ++i) {
            if (NeonImagesHandler.getSingleonInstance().checkImagesAvailableForTag(this.tagModels.get(i))) continue;
            this.currentTag = i;
            break;
        }
        if (this.currentTag == this.tagModels.size() - 1) {
            this.tvNext.setText((CharSequence)this.getString(R.string.finish));
        }
        if (this.currentTag > 0) {
            this.tvPrevious.setVisibility(0);
        }
    }

    public void onBackPressed() {
        if (NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else {
            NeonImagesHandler.getSingleonInstance().showBackOperationAlertIfNeeded((Activity)this);
        }
    }

    @Override
    public void onPictureTaken(String filePath) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(filePath);
        fileInfo.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        if (this.cameraParams.getTagEnabled()) {
            fileInfo.setFileTag(this.tagModels.get(this.currentTag));
        }
        NeonImagesHandler.getSingleonInstance().putInImageCollection(fileInfo, (Context)this);
    }
}

