/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.app.Activity;
import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.adapter.ImageShowAdapter;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ImageShowLayoutBinding;
import java.util.List;

public class ImageShowFragment
extends Fragment {
    ImageShowAdapter adapter;
    ImageShowLayoutBinding binder;
    View.OnClickListener doneListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (ImageShowFragment.this.validate()) {
                NeonImagesHandler.getSingleonInstance().sendImageCollectionAndFinish((Activity)ImageShowFragment.this.getActivity(), ResponseCode.Success);
            }
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binder = (ImageShowLayoutBinding)DataBindingUtil.inflate((LayoutInflater)this.getActivity().getLayoutInflater(), (int)R.layout.image_show_layout, null, (boolean)false);
        this.binder.btnDone.setOnClickListener(this.doneListener);
        return this.binder.getRoot();
    }

    public void onResume() {
        super.onResume();
        if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
            return;
        }
        if (this.adapter == null) {
            this.adapter = new ImageShowAdapter((Context)this.getActivity());
            this.binder.imageShowGrid.setAdapter((ListAdapter)this.adapter);
        } else {
            this.adapter.notifyDataSetChanged();
        }
    }

    private boolean validate() {
        if (!NeonImagesHandler.getSingleonInstance().getGenericParam().getTagEnabled()) {
            return true;
        }
        List<FileInfo> fileInfos = NeonImagesHandler.getSingleonInstance().getImagesCollection();
        if (fileInfos != null && fileInfos.size() > 0) {
            for (int i = 0; i < fileInfos.size(); ++i) {
                if (fileInfos.get(i).getFileTag() != null) continue;
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Set tag for all images", (int)0).show();
                return false;
            }
        }
        List<ImageTagModel> imageTagModels = NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel();
        for (int j = 0; j < imageTagModels.size(); ++j) {
            if (!imageTagModels.get(j).isMandatory() || NeonImagesHandler.getSingleonInstance().checkImagesAvailableForTag(imageTagModels.get(j))) continue;
            Toast.makeText((Context)this.getActivity(), (CharSequence)"All mandatory tags are not covered.", (int)0).show();
            return false;
        }
        return true;
    }
}

