/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.Enumerations.CameraFacing;
import com.gaadi.neon.Enumerations.CameraOrientation;
import com.gaadi.neon.Enumerations.CameraType;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.gallery.NeonBaseGalleryActivity;
import com.gaadi.neon.adapter.GalleryHoriontalAdapter;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.SetOnImageClickListener;
import com.gaadi.neon.interfaces.SetOnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.PermissionType;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;
import com.scanlibrary.databinding.HorizontalGalleryLayoutBinding;
import java.util.ArrayList;
import java.util.List;

public class HorizontalFilesActivity
extends NeonBaseGalleryActivity
implements SetOnImageClickListener {
    HorizontalGalleryLayoutBinding binder;
    ArrayList<FileInfo> fileInfos;
    MenuItem textViewDone;
    MenuItem menuItemCamera;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        String title = this.getIntent().getStringExtra("BucketName");
        if (title == null || title.length() <= 0) {
            title = "Files";
        }
        this.setTitle(title);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done_file, menu2);
        this.textViewDone = menu2.findItem(R.id.menu_next);
        this.menuItemCamera = menu2.findItem(R.id.menuCamera);
        this.menuItemCamera.setVisible(SingletonClass.getSingleonInstance().getGalleryParam().galleryToCameraSwitchEnabled());
        this.textViewDone.setVisible(true);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menu_next) {
            if (SingletonClass.getSingleonInstance().getImagesCollection() == null || SingletonClass.getSingleonInstance().getImagesCollection().size() <= 0) {
                Toast.makeText((Context)this, (CharSequence)"No image selected", (int)0).show();
                return super.onOptionsItemSelected(item);
            }
            if (!SingletonClass.getSingleonInstance().isNeutralEnabled()) {
                Intent intent = new Intent((Context)this, ImageShow.class);
                this.startActivity(intent);
                this.setResult(300);
                this.finish();
            } else {
                this.setResult(-1);
                this.finish();
            }
        } else if (id2 == R.id.menuCamera) {
            this.performCameraOperation();
            this.setResult(300);
            this.finish();
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (SingletonClass.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else if (!SingletonClass.getSingleonInstance().getGalleryParam().enableFolderStructure()) {
            SingletonClass.getSingleonInstance().showBackOperationAlertIfNeeded((Activity)this);
        } else {
            super.onBackPressed();
        }
    }

    private void performCameraOperation() {
        ICameraParam cameraParam = SingletonClass.getSingleonInstance().getCameraParam();
        if (cameraParam == null) {
            cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.front;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return true;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return true;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return true;
                }

                @Override
                public int getNumberOfPhotos() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getNumberOfPhotos();
                }

                @Override
                public boolean getTagEnabled() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getTagEnabled();
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return SingletonClass.getSingleonInstance().getGalleryParam().getImageTagsModel();
                }

                public ArrayList<FileInfo> getAlreadyAddedImages() {
                    return null;
                }
            };
        }
        try {
            PhotosLibrary.collectPhotos((Context)this, PhotosMode.setCameraMode().setParams(cameraParam), SingletonClass.getSingleonInstance().getImageResultListener());
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
    }

    private void bindXml() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new SetOnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        HorizontalFilesActivity.this.binder = (HorizontalGalleryLayoutBinding)DataBindingUtil.inflate((LayoutInflater)HorizontalFilesActivity.this.getLayoutInflater(), (int)R.layout.horizontal_gallery_layout, (ViewGroup)HorizontalFilesActivity.this.frameLayout, (boolean)true);
                        LinearLayoutManager linearLayoutManager = new LinearLayoutManager((Context)HorizontalFilesActivity.this, 0, false);
                        HorizontalFilesActivity.this.binder.galleryHorizontalRv.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
                        HorizontalFilesActivity.this.fileInfos = HorizontalFilesActivity.this.getFileFromBucketId(HorizontalFilesActivity.this.getIntent().getStringExtra("BucketId"));
                        if (HorizontalFilesActivity.this.fileInfos != null && HorizontalFilesActivity.this.fileInfos.size() > 0) {
                            GalleryHoriontalAdapter adapter = new GalleryHoriontalAdapter((Context)HorizontalFilesActivity.this, HorizontalFilesActivity.this.fileInfos, HorizontalFilesActivity.this);
                            HorizontalFilesActivity.this.binder.galleryHorizontalRv.setAdapter((RecyclerView.Adapter)adapter);
                            HorizontalFilesActivity.this.onClick(HorizontalFilesActivity.this.fileInfos.get(0));
                        }
                    } else {
                        Toast.makeText((Context)HorizontalFilesActivity.this, (CharSequence)"Permission not granted", (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }

    @Override
    public void onClick(FileInfo fileInfo) {
        Glide.with((FragmentActivity)this).load(fileInfo.getFilePath()).placeholder(R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.NONE).into(this.binder.fullScreenImage);
    }
}

