/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.widget.FrameLayout;
import com.gaadi.neon.interfaces.SetOnPermissionResultListener;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.PermissionType;
import com.scanlibrary.R;

public abstract class NeonBaseActivity
extends AppCompatActivity {
    protected FrameLayout frameLayout;
    protected Toolbar toolbar;
    private SetOnPermissionResultListener permissionResultListener;
    private final int permissionRequestCode = 1;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        this.setTheme(R.style.NeonLibTheme);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_base);
        this.frameLayout = (FrameLayout)this.findViewById(R.id.content_frame);
        this.toolbar = (Toolbar)this.findViewById(R.id.tool_bar);
        this.setSupportActionBar(this.toolbar);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    protected void askForPermissionIfNeeded(PermissionType permissionType, SetOnPermissionResultListener listener) throws ManifestPermission {
        this.permissionResultListener = listener;
        switch (permissionType) {
            case read_calender: {
                this.goForPermission(new String[]{"android.permission.READ_CALENDAR"});
                break;
            }
            case write_calender: {
                this.goForPermission(new String[]{"android.permission.WRITE_CALENDAR"});
                break;
            }
            case camera: {
                this.goForPermission(new String[]{"android.permission.CAMERA"});
                break;
            }
            case read_contacts: {
                this.goForPermission(new String[]{"android.permission.READ_CONTACTS"});
                break;
            }
            case write_contacts: {
                this.goForPermission(new String[]{"android.permission.WRITE_CONTACTS"});
                break;
            }
            case get_accounts: {
                this.goForPermission(new String[]{"android.permission.GET_ACCOUNTS"});
                break;
            }
            case access_fine_locations: {
                this.goForPermission(new String[]{"android.permission.ACCESS_FINE_LOCATION"});
                break;
            }
            case access_course_locations: {
                this.goForPermission(new String[]{"android.permission.ACCESS_COARSE_LOCATION"});
                break;
            }
            case record_audio: {
                this.goForPermission(new String[]{"android.permission.RECORD_AUDIO"});
                break;
            }
            case read_phone_state: {
                this.goForPermission(new String[]{"android.permission.READ_PHONE_STATE"});
                break;
            }
            case call_phone: {
                this.goForPermission(new String[]{"android.permission.CALL_PHONE"});
                break;
            }
            case read_call_log: {
                if (Build.VERSION.SDK_INT < 16) break;
                this.goForPermission(new String[]{"android.permission.READ_CALL_LOG"});
                break;
            }
            case write_call_log: {
                if (Build.VERSION.SDK_INT < 16) break;
                this.goForPermission(new String[]{"android.permission.WRITE_CALL_LOG"});
                break;
            }
            case add_voice_mail: {
                this.goForPermission(new String[]{"com.android.voicemail.permission.ADD_VOICEMAIL"});
                break;
            }
            case use_sip: {
                this.goForPermission(new String[]{"android.permission.USE_SIP"});
                break;
            }
            case process_outgoing_calls: {
                this.goForPermission(new String[]{"android.permission.PROCESS_OUTGOING_CALLS"});
                break;
            }
            case body_sensors: {
                if (Build.VERSION.SDK_INT < 20) break;
                this.goForPermission(new String[]{"android.permission.BODY_SENSORS"});
                break;
            }
            case send_sms: {
                this.goForPermission(new String[]{"android.permission.SEND_SMS"});
                break;
            }
            case receieve_sms: {
                this.goForPermission(new String[]{"android.permission.RECEIVE_SMS"});
                break;
            }
            case read_sms: {
                this.goForPermission(new String[]{"android.permission.READ_SMS"});
                break;
            }
            case receive_wap_push: {
                this.goForPermission(new String[]{"android.permission.RECEIVE_WAP_PUSH"});
                break;
            }
            case receive_mms: {
                this.goForPermission(new String[]{"android.permission.RECEIVE_MMS"});
                break;
            }
            case read_external_storage: {
                if (Build.VERSION.SDK_INT < 16) break;
                this.goForPermission(new String[]{"android.permission.READ_EXTERNAL_STORAGE"});
                break;
            }
            case write_external_storage: {
                this.goForPermission(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"});
                break;
            }
            default: {
                this.permissionResultListener.onResult(false);
            }
        }
    }

    private void goForPermission(String[] permissionName) throws ManifestPermission {
        if (!this.mentionedInManifest(permissionName[0])) {
            throw new ManifestPermission("Mention " + permissionName[0] + " in your Manifest file");
        }
        if (Build.VERSION.SDK_INT < 23 || ContextCompat.checkSelfPermission((Context)this, (String)permissionName[0]) == 0) {
            this.permissionResultListener.onResult(true);
            return;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])permissionName, (int)1);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                this.permissionResultListener.onResult(grantResults.length > 0 && grantResults[0] == 0);
            }
        }
    }

    private boolean mentionedInManifest(String permission2) {
        try {
            PackageInfo info = this.getPackageManager().getPackageInfo(this.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    if (!p.equals(permission2)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

