/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.content.Context;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.adapter.ImageShowAdapter;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ImageShowLayoutBinding;
import java.util.ArrayList;

public class ImageShowFragment
extends Fragment {
    ImageShowAdapter adapter;
    ImageShowLayoutBinding binder;
    View.OnClickListener doneListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (ImageShowFragment.this.validate()) {
                if (SingletonClass.getSingleonInstance().getGenericParam().getTagEnabled()) {
                    SingletonClass.getSingleonInstance().getImageResultListener().imageCollection(SingletonClass.getSingleonInstance().getFileHashMap());
                } else {
                    SingletonClass.getSingleonInstance().getImageResultListener().imageCollection(SingletonClass.getSingleonInstance().getImagesCollection());
                }
                SingletonClass.getSingleonInstance().scheduleSinletonClearance();
                ImageShowFragment.this.getActivity().finish();
            }
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.binder = (ImageShowLayoutBinding)DataBindingUtil.inflate((LayoutInflater)this.getActivity().getLayoutInflater(), (int)R.layout.image_show_layout, null, (boolean)false);
        this.binder.btnDone.setOnClickListener(this.doneListener);
        return this.binder.getRoot();
    }

    public void onResume() {
        super.onResume();
        if (SingletonClass.getSingleonInstance().getImagesCollection() == null || SingletonClass.getSingleonInstance().getImagesCollection().size() <= 0) {
            return;
        }
        if (this.adapter == null) {
            this.adapter = new ImageShowAdapter((Context)this.getActivity());
            this.binder.imageShowGrid.setAdapter((ListAdapter)this.adapter);
        } else {
            this.adapter.notifyDataSetChanged();
        }
    }

    private boolean validate() {
        if (!SingletonClass.getSingleonInstance().getGenericParam().getTagEnabled()) {
            return true;
        }
        ArrayList<FileInfo> fileInfos = SingletonClass.getSingleonInstance().getImagesCollection();
        if (fileInfos != null && fileInfos.size() > 0) {
            for (int i = 0; i < fileInfos.size(); ++i) {
                if (fileInfos.get(i).getFileTag() != null) continue;
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Set tag for all images", (int)0).show();
                return false;
            }
        }
        return true;
    }
}

