/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.gaadi.neon.activity.NeonBaseActivity;
import com.gaadi.neon.adapter.ImagesReviewViewPagerAdapter;
import com.gaadi.neon.events.ImageEditEvent;
import com.gaadi.neon.interfaces.FragmentListener;
import com.gaadi.neon.util.SingletonClass;
import com.scanlibrary.R;

public class ImageReviewActivity
extends NeonBaseActivity
implements View.OnClickListener,
FragmentListener {
    private ImagesReviewViewPagerAdapter mPagerAdapter;
    private TextView mDoneButton;
    private TextView mTitle;
    private ViewPager mPager;
    private Toolbar toolbar;
    private boolean isViewDirty = false;
    private ImageView viewPagerRightBtn;
    private ImageView viewPagerLeftBtn;
    private boolean singleTagSelection;

    public boolean isSingleTagSelection() {
        return this.singleTagSelection;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_review);
        this.toolbar = (Toolbar)this.findViewById(R.id.image_review_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.mDoneButton = (TextView)this.findViewById(R.id.image_review_toolbar_doneBtn);
        this.mDoneButton.setOnClickListener((View.OnClickListener)this);
        this.mPager = (ViewPager)this.findViewById(R.id.pager);
        this.viewPagerLeftBtn = (ImageView)this.findViewById(R.id.view_pager_leftbtn);
        this.viewPagerRightBtn = (ImageView)this.findViewById(R.id.view_pager_rightbtn);
        this.viewPagerRightBtn.setOnClickListener((View.OnClickListener)this);
        this.viewPagerLeftBtn.setOnClickListener((View.OnClickListener)this);
        this.mTitle = (TextView)this.findViewById(R.id.image_review_toolbar_title);
        this.getSupportActionBar().setTitle((CharSequence)"Image Review");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowHomeEnabled(true);
        Intent intent = this.getIntent();
        this.singleTagSelection = intent.getBooleanExtra("singleTagSelection", false);
        int position = intent.getIntExtra("imageReviewPosition", 0);
        if (position == 0) {
            this.viewPagerLeftBtn.setVisibility(8);
        }
        if (position == SingletonClass.getSingleonInstance().getImagesCollection().size() - 1) {
            this.viewPagerRightBtn.setVisibility(8);
        }
        this.mPagerAdapter = new ImagesReviewViewPagerAdapter(this.getSupportFragmentManager());
        this.mPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mPager.setCurrentItem(position);
        this.mPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageReviewActivity.this.setArrowButton(position);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void setArrowButton(int position) {
        if (position == 0 || SingletonClass.getSingleonInstance().getImagesCollection().size() == 1) {
            this.viewPagerLeftBtn.setVisibility(8);
        } else {
            this.viewPagerLeftBtn.setVisibility(0);
        }
        if (position == SingletonClass.getSingleonInstance().getImagesCollection().size() - 1 || SingletonClass.getSingleonInstance().getImagesCollection().size() == 1) {
            this.viewPagerRightBtn.setVisibility(8);
        } else {
            this.viewPagerRightBtn.setVisibility(0);
        }
    }

    @Override
    public void getFragmentChanges(ImageEditEvent event) {
        if (event.getImageEventType() == 1) {
            this.isViewDirty = true;
            SingletonClass.getSingleonInstance().removeFromCollection(event.getPosition());
            this.mPagerAdapter.setPagerItems();
            if (SingletonClass.getSingleonInstance().getImagesCollection().size() == 0) {
                this.onBackPressed();
            }
            this.setArrowButton(this.mPager.getCurrentItem());
        } else if (event.getImageEventType() == 2) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 3) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 5) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 4) {
            SingletonClass.getSingleonInstance().getImagesCollection().set(event.getPosition(), event.getModel());
        }
    }

    public void onClick(View v) {
        int position;
        int id2 = v.getId();
        if (id2 == R.id.image_review_toolbar_doneBtn) {
            this.finish();
        } else if (id2 == R.id.view_pager_leftbtn) {
            int position2 = this.mPager.getCurrentItem();
            if (position2 > 0) {
                this.mPager.setCurrentItem(--position2);
            }
        } else if (id2 == R.id.view_pager_rightbtn && (position = this.mPager.getCurrentItem()) < SingletonClass.getSingleonInstance().getImagesCollection().size() - 1) {
            this.mPager.setCurrentItem(++position);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_view_pager, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        if (item.getItemId() == R.id.menu_done) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

