/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.adapter.FolderHolder;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.util.ArrayList;

public class ImagesFoldersAdapter
extends BaseAdapter {
    Context context;
    ArrayList<FileInfo> folders;

    public ImagesFoldersAdapter(Context context, ArrayList<FileInfo> files) {
        this.context = context;
        this.folders = files;
    }

    public int getCount() {
        return this.folders.size();
    }

    public Object getItem(int position) {
        return this.folders.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FolderHolder holder;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            convertView = inflater.inflate(R.layout.gallery_folder_layout, null);
            holder = new FolderHolder();
            holder.imageView = (ImageView)convertView.findViewById(R.id.ivFolderThumbnail);
            holder.countFiles = (TextView)convertView.findViewById(R.id.tvCount);
            holder.FolderName = (TextView)convertView.findViewById(R.id.tvFolderName);
            convertView.setTag((Object)holder);
        }
        holder = (FolderHolder)convertView.getTag();
        FileInfo fileInfo = this.folders.get(position);
        if (fileInfo.getFileCount() > 0) {
            holder.countFiles.setText((CharSequence)(fileInfo.getFileCount() + ""));
            holder.countFiles.setVisibility(0);
        } else {
            holder.countFiles.setVisibility(4);
        }
        holder.FolderName.setText((CharSequence)this.folders.get(position).getDisplayName().toString());
        Glide.with((Context)this.context).load("file://" + this.folders.get(position).getFilePath()).diskCacheStrategy(DiskCacheStrategy.ALL).placeholder(R.drawable.default_placeholder).centerCrop().into(holder.imageView);
        return convertView;
    }
}

