/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.activity.BaseActivity;
import com.gaadi.neon.activity.GalleryFiles;
import com.gaadi.neon.adapter.ImagesFoldersAdapter;
import com.gaadi.neon.util.CommonUtils;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class GalleryActivity
extends BaseActivity
implements AdapterView.OnItemClickListener {
    public static final String MAX_COUNT = "maxCount";
    public static final String FOLDER_NAME = "folder_name";
    public static final String GALLERY_SELECTED_PHOTOS = "galleryPhotos";
    private static final int REQUEST_FOLDER_FILES = 100;
    private ArrayList<FileInfo> folders = new ArrayList();
    private PhotoParams mPhotoParams;
    private int maxCount;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getLayoutInflater().inflate(R.layout.activity_gallery, (ViewGroup)this.frameLayout);
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setTitle((CharSequence)this.getString(R.string.gallery));
        }
        GridView gvFolders = (GridView)this.findViewById(R.id.gvFolders);
        if (this.getIntent().getSerializableExtra("photoParams") != null) {
            this.mPhotoParams = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
            this.maxCount = this.mPhotoParams.getNoOfPhotos();
        }
        ImagesFoldersAdapter adapter = new ImagesFoldersAdapter((Context)this, this.folders);
        gvFolders.setAdapter((ListAdapter)adapter);
        Uri uri = CommonUtils.getImageStoreUri();
        String[] PROJECTION_BUCKET = new String[]{"bucket_display_name", "_data"};
        Cursor mCursor = this.mPhotoParams != null && this.mPhotoParams.isRestrictedExtensionEnabled() ? this.getContentResolver().query(uri, PROJECTION_BUCKET, "mime_type in (?, ?)", new String[]{"image/jpeg", "image/png"}, null) : this.getContentResolver().query(uri, PROJECTION_BUCKET, "\"1) GROUP BY 1,(1\"", null, null);
        if (mCursor == null) {
            Toast.makeText((Context)this, (CharSequence)this.getString(R.string.gallery_error), (int)0).show();
            this.finish();
            return;
        }
        mCursor.moveToFirst();
        HashMap<String, Integer> mapFolders = new HashMap<String, Integer>();
        for (int i = 0; i < mCursor.getCount(); ++i) {
            String bucketName = mCursor.getString(mCursor.getColumnIndex("bucket_display_name"));
            Integer count = (Integer)mapFolders.get(bucketName);
            if (count != null && count != 0) {
                mapFolders.put(bucketName, count + 1);
            } else {
                mapFolders.put(bucketName, 1);
            }
            mCursor.moveToNext();
        }
        mCursor.close();
        String selection = "bucket_display_name= ?";
        String orderBy = "datetaken DESC LIMIT 1";
        for (Map.Entry entry : mapFolders.entrySet()) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDisplayName((String)entry.getKey());
            fileInfo.setFileCount((Integer)entry.getValue());
            Cursor cursorImage = this.getContentResolver().query(uri, PROJECTION_BUCKET, selection, new String[]{fileInfo.getDisplayName()}, orderBy);
            if (cursorImage == null) continue;
            cursorImage.moveToFirst();
            for (int j = 0; j < cursorImage.getCount(); ++j) {
                String imagePath = cursorImage.getString(cursorImage.getColumnIndex("_data"));
                fileInfo.setFilePath(imagePath);
                cursorImage.moveToNext();
            }
            this.folders.add(fileInfo);
            cursorImage.close();
        }
        adapter.notifyDataSetChanged();
        gvFolders.setOnItemClickListener((AdapterView.OnItemClickListener)this);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Intent intent = new Intent();
        if (resultCode == 10) {
            intent.putExtra(GALLERY_SELECTED_PHOTOS, data.getExtras().getSerializable("selectedFiles"));
            this.setResult(-1, intent);
            this.finish();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu2) {
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_settings) {
            return false;
        }
        if (id2 == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        FileInfo fileInfo = this.folders.get(position);
        Intent intent = new Intent((Context)this, GalleryFiles.class);
        intent.putExtra(FOLDER_NAME, fileInfo.getDisplayName());
        if (this.maxCount > 0) {
            intent.putExtra(MAX_COUNT, this.maxCount);
        }
        this.startActivityForResult(intent, 100);
    }
}

