/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.gaadi.neon.adapter.CapturedImagesAdapter;
import com.gaadi.neon.util.CameraPreview;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.PhotoParams;
import com.scanlibrary.R;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class CameraActivity1
extends Activity
implements View.OnClickListener,
Camera.PictureCallback {
    private static final String TAG = "ScanActivity";
    public static final String CAMERA_IMAGES = "captured_images";
    private Camera camera;
    private ImageView capturedImageView;
    CameraPreview cameraPreview;
    private LinearLayout llCapturedImages;
    LinearLayout llActionsCamera;
    int maxCount;
    public static Boolean readyToTakePicture = false;
    private ArrayList<FileInfo> imagesList = new ArrayList();
    private CapturedImagesAdapter imagesAdapter;
    private ListView lvCaptureImages;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.camera_items);
        this.llActionsCamera = (LinearLayout)this.findViewById(R.id.llActionsCamera);
        PhotoParams params = (PhotoParams)this.getIntent().getSerializableExtra("photoParams");
        this.maxCount = this.getIntent().getIntExtra("maxCount", 0);
        if (params != null) {
            PhotoParams.CameraOrientation orientation = params.getOrientation();
            this.setOrientation(orientation);
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.camera == null) {
            try {
                this.camera = Camera.open();
                this.cameraPreview = new CameraPreview(this, this.camera);
                FrameLayout camera_lLayout = (FrameLayout)this.findViewById(R.id.camera_preview);
                camera_lLayout.addView((View)this.cameraPreview);
                this.getWindow().setFlags(1024, 1024);
                this.findViewById(R.id.button_capture).setOnClickListener((View.OnClickListener)this);
                this.findViewById(R.id.bDone).setOnClickListener((View.OnClickListener)this);
                this.findViewById(R.id.bBack).setOnClickListener((View.OnClickListener)this);
                this.capturedImageView = (ImageView)this.findViewById(R.id.ivCaptured);
                this.lvCaptureImages = (ListView)this.findViewById(R.id.lvCapturedImages);
                this.imagesAdapter = new CapturedImagesAdapter((Context)this, this.imagesList);
                this.lvCaptureImages.setAdapter((ListAdapter)this.imagesAdapter);
                this.imagesAdapter.notifyDataSetChanged();
            }
            catch (Exception e) {
                Log.e((String)"Camera Open Exception", (String)("" + e.getMessage()));
            }
        } else {
            Log.e((String)TAG, (String)"camera not null");
        }
    }

    private void setOrientation(PhotoParams.CameraOrientation orientation) {
        if (orientation != null) {
            if (orientation.equals((Object)PhotoParams.CameraOrientation.LANDSCAPE)) {
                this.setRequestedOrientation(0);
            } else if (orientation.equals((Object)PhotoParams.CameraOrientation.PORTRAIT)) {
                this.setRequestedOrientation(1);
            }
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.button_capture) {
            if (this.imagesAdapter.getImageInfoArrayList().size() >= this.maxCount) {
                Toast.makeText((Context)this, (CharSequence)("Maximum no. of images allowed is " + this.maxCount), (int)1).show();
                return;
            }
            if (readyToTakePicture.booleanValue()) {
                this.camera.takePicture(null, null, (Camera.PictureCallback)this);
                readyToTakePicture = false;
                this.llActionsCamera.setEnabled(false);
            }
        } else if (v.getId() == R.id.bBack) {
            this.finish();
        } else if (v.getId() == R.id.bDone) {
            Intent intent = new Intent();
            intent.putExtra(CAMERA_IMAGES, this.imagesAdapter.getImageInfoArrayList());
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void updateCapturedPhotos(File pictureFile) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(pictureFile.getAbsolutePath());
        fileInfo.setFileName(pictureFile.getAbsolutePath().substring(pictureFile.getAbsolutePath().lastIndexOf("/") + 1));
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        this.imagesAdapter.getImageInfoArrayList().add(fileInfo);
        this.imagesAdapter.notifyDataSetChanged();
        this.lvCaptureImages.smoothScrollToPosition(this.imagesAdapter.getCount() - 1);
        this.camera.startPreview();
    }

    public void onPause() {
        super.onPause();
        try {
            this.camera.setPreviewCallback(null);
            this.cameraPreview.getHolder().removeCallback((SurfaceHolder.Callback)this.cameraPreview);
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onPictureTaken(byte[] data, Camera camera) {
        File pictureFile = Constants.getMediaOutputFile((Context)this, 1);
        this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse((String)("file://" + pictureFile.getAbsolutePath()))));
        if (pictureFile == null) {
            Log.d((String)TAG, (String)"Error creating media file, check storage permissions: ");
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(pictureFile);
            fos.write(data);
            fos.close();
            this.updateCapturedPhotos(pictureFile);
            readyToTakePicture = true;
            this.llActionsCamera.setEnabled(true);
        }
        catch (FileNotFoundException e) {
            Log.d((String)TAG, (String)("File not found: " + e.getMessage()));
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Error accessing file: " + e.getMessage()));
        }
    }
}

