/*
 * Decompiled with CFR 0.152.
 */
package com.scanlibrary;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.gaadi.neon.util.FileInfo;
import com.google.android.gms.appindexing.Action;
import com.google.android.gms.appindexing.AppIndex;
import com.google.android.gms.common.api.GoogleApiClient;
import com.scanlibrary.FragmentListener;
import com.scanlibrary.ImageEditEvent;
import com.scanlibrary.ImageModel;
import com.scanlibrary.ImagesReviewViewPagerAdapter;
import com.scanlibrary.R;
import java.util.ArrayList;

public class ImageReviewActivity
extends AppCompatActivity
implements View.OnClickListener,
FragmentListener {
    private ImagesReviewViewPagerAdapter mPagerAdapter;
    private ArrayList<FileInfo> imagesList;
    private TextView mDoneButton;
    private TextView mTitle;
    private ViewPager mPager;
    private Toolbar toolbar;
    private boolean isViewDirty = false;
    private ImageView viewPagerRightBtn;
    private ImageView viewPagerLeftBtn;
    private GoogleApiClient client;
    private UpdateImageListReceiver mUpdateImageListReceiver;
    ArrayList<ImageModel> tempImageList;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_imagereview);
        this.toolbar = (Toolbar)this.findViewById(R.id.image_review_toolbar);
        this.setSupportActionBar(this.toolbar);
        this.mDoneButton = (TextView)this.findViewById(R.id.image_review_toolbar_doneBtn);
        this.mDoneButton.setOnClickListener((View.OnClickListener)this);
        this.mPager = (ViewPager)this.findViewById(R.id.pager);
        this.viewPagerLeftBtn = (ImageView)this.findViewById(R.id.view_pager_leftbtn);
        this.viewPagerRightBtn = (ImageView)this.findViewById(R.id.view_pager_rightbtn);
        this.viewPagerRightBtn.setOnClickListener((View.OnClickListener)this);
        this.viewPagerLeftBtn.setOnClickListener((View.OnClickListener)this);
        this.mTitle = (TextView)this.findViewById(R.id.image_review_toolbar_title);
        this.getSupportActionBar().setTitle((CharSequence)"Image Review");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setDisplayShowHomeEnabled(true);
        Intent intent = this.getIntent();
        this.imagesList = (ArrayList)intent.getSerializableExtra("imageModelReview");
        int position = intent.getIntExtra("imageReviewPosition", 0);
        if (position == 0) {
            this.viewPagerLeftBtn.setVisibility(8);
        }
        if (position == this.imagesList.size() - 1) {
            this.viewPagerRightBtn.setVisibility(8);
        }
        this.mPagerAdapter = new ImagesReviewViewPagerAdapter(this.getSupportFragmentManager(), this.imagesList);
        this.mPager.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mPager.setCurrentItem(position);
        this.mPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageReviewActivity.this.setArrowButton(position, ImageReviewActivity.this.imagesList);
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        IntentFilter filter = new IntentFilter();
        filter.addAction("updateImageList");
        this.mUpdateImageListReceiver = new UpdateImageListReceiver();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mUpdateImageListReceiver, filter);
        this.client = new GoogleApiClient.Builder((Context)this).addApi(AppIndex.API).build();
    }

    public void makeUnchangedList(ArrayList<ImageModel> list) {
        this.tempImageList = new ArrayList();
        this.tempImageList.addAll(list);
    }

    private void setArrowButton(int position, ArrayList<FileInfo> imagesTempList) {
        if (position == 0 || imagesTempList.size() == 1) {
            this.viewPagerLeftBtn.setVisibility(8);
        } else {
            this.viewPagerLeftBtn.setVisibility(0);
        }
        if (position == imagesTempList.size() - 1 || imagesTempList.size() == 1) {
            this.viewPagerRightBtn.setVisibility(8);
        } else {
            this.viewPagerRightBtn.setVisibility(0);
        }
    }

    @Override
    public void getFragmentChanges(ImageEditEvent event) {
        if (event.getImageEventType() == 1) {
            this.isViewDirty = true;
            this.imagesList.remove(event.getPosition());
            this.mPagerAdapter.setPagerItems(this.imagesList);
            if (this.imagesList.size() == 0) {
                this.onBackPressed();
            }
            this.setArrowButton(this.mPager.getCurrentItem(), this.imagesList);
        } else if (event.getImageEventType() == 2) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 3) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 5) {
            this.isViewDirty = true;
        } else if (event.getImageEventType() == 4) {
            this.imagesList.set(event.getPosition(), event.getModel());
        }
    }

    public void onClick(View v) {
        int position;
        int id2 = v.getId();
        if (id2 == R.id.image_review_toolbar_doneBtn) {
            Intent i = new Intent();
            i.putExtra("imageModelReview", this.imagesList);
            this.setResult(-1, i);
            this.finish();
        } else if (id2 == R.id.view_pager_leftbtn) {
            int position2 = this.mPager.getCurrentItem();
            if (position2 > 0) {
                this.mPager.setCurrentItem(--position2);
            }
        } else if (id2 == R.id.view_pager_rightbtn && (position = this.mPager.getCurrentItem()) < this.imagesList.size() - 1) {
            this.mPager.setCurrentItem(++position);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_view_pager, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        if (item.getItemId() == R.id.menu_done) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        Intent i = new Intent();
        i.putExtra("imageModelReview", this.imagesList);
        this.setResult(-1, i);
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mUpdateImageListReceiver);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
    }

    public void onStart() {
        super.onStart();
        this.client.connect();
        Action viewAction = Action.newAction((String)"http://schema.org/ViewAction", (String)"ImageReview Page", (Uri)Uri.parse((String)"http://host/path"), (Uri)Uri.parse((String)"android-app://com.scanlibrary/http/host/path"));
    }

    public void onStop() {
        super.onStop();
        Action viewAction = Action.newAction((String)"http://schema.org/ViewAction", (String)"ImageReview Page", (Uri)Uri.parse((String)"http://host/path"), (Uri)Uri.parse((String)"android-app://com.scanlibrary/http/host/path"));
        this.client.disconnect();
    }

    class UpdateImageListReceiver
    extends BroadcastReceiver {
        UpdateImageListReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            ImageReviewActivity.this.setResult(5001, intent);
            ImageReviewActivity.this.finish();
        }
    }
}

