/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.hardware.Camera;
import android.net.Uri;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.util.ArrayList;

public class CommonUtils {
    public static void createNotification(Context context, int smallIcon, String title, String content, Intent resultIntent, int imageUploadNotifId) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setSmallIcon(smallIcon).setContentTitle((CharSequence)title).setAutoCancel(true).setContentText((CharSequence)content);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)context);
        stackBuilder.addNextIntent(resultIntent);
        PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, 0x8000000);
        mBuilder.setContentIntent(resultPendingIntent);
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.notify(imageUploadNotifId, mBuilder.build());
    }

    public static String getStringSharedPreference(Context context, String key, String defaultValue) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        if (preferences.contains(key)) {
            return preferences.getString(key, defaultValue);
        }
        return defaultValue;
    }

    public static ArrayList<FileInfo> removeFileInfo(ArrayList<FileInfo> source, FileInfo fileInfo) {
        for (FileInfo fileInfo1 : source) {
            if (!fileInfo.getFilePath().equals(fileInfo1.getFilePath())) continue;
            source.remove(fileInfo);
            break;
        }
        return source;
    }

    public static void removeFileInfo(ArrayList<String> source, ArrayList<FileInfo> removeFiles, Boolean flag) {
        if (source == null) {
            return;
        }
        for (FileInfo fileInfo : removeFiles) {
            if (!source.contains(fileInfo.getFilePath())) continue;
            source.remove(fileInfo.getFilePath());
        }
    }

    public static void addFileInfo(ArrayList<FileInfo> source, FileInfo fileInfo) {
        Boolean alreadyPresent = false;
        for (FileInfo fileInfo1 : source) {
            if (!fileInfo.getFilePath().equals(fileInfo1.getFilePath())) continue;
            alreadyPresent = true;
            break;
        }
        if (!alreadyPresent.booleanValue()) {
            source.add(fileInfo);
        }
    }

    public static void removeFileInfo(ArrayList<FileInfo> source, String filePath) {
        for (FileInfo fileInfo : source) {
            if (!filePath.equals(fileInfo.getFilePath())) continue;
            source.remove(fileInfo);
            break;
        }
    }

    public static void removeFileInfo(ArrayList<FileInfo> source, ArrayList<FileInfo> fileInfos) {
        ArrayList<FileInfo> toBeDeleted = new ArrayList<FileInfo>();
        block0: for (FileInfo fileInfo : source) {
            for (FileInfo fileInfo1 : fileInfos) {
                if (!fileInfo1.getFilePath().equals(fileInfo.getFilePath())) continue;
                toBeDeleted.add(fileInfo);
                continue block0;
            }
        }
        source.removeAll(toBeDeleted);
    }

    public static void expand(final View v) {
        v.measure(-1, -2);
        final int targetHeight = v.getMeasuredHeight();
        v.getLayoutParams().height = 0;
        v.setVisibility(0);
        Animation a = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                v.getLayoutParams().height = interpolatedTime == 1.0f ? -2 : (int)((float)targetHeight * interpolatedTime);
                v.requestLayout();
            }

            public boolean willChangeBounds() {
                return true;
            }
        };
        a.setDuration((long)((int)((float)targetHeight / v.getContext().getResources().getDisplayMetrics().density)));
        v.startAnimation(a);
    }

    public static Uri getImageStoreUri() {
        return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    }

    public static boolean getBooleanSharedPreference(Context context, String key, boolean defaultValue) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        if (preferences.contains(key)) {
            return preferences.getBoolean(key, defaultValue);
        }
        return defaultValue;
    }

    public static void setBooleanSharedPreference(Context context, String key, boolean value) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (key != null && !key.isEmpty()) {
            editor.putBoolean(key, value);
            editor.apply();
        }
    }

    public static boolean checkForPermission(final Context context, String[] permissions, final int requestCode, String requestFor) {
        final ArrayList<String> permissionNeededForList = CommonUtils.checkSelfPermission(context, permissions);
        String requestsFor = permissionNeededForList.get(permissionNeededForList.size() - 1);
        permissionNeededForList.remove(permissionNeededForList.size() - 1);
        if (permissionNeededForList.isEmpty()) {
            return true;
        }
        if (!requestsFor.isEmpty()) {
            new AlertDialog.Builder(context).setTitle((CharSequence)context.getString(R.string.permission_error)).setMessage((CharSequence)context.getString(R.string.you_need_to_allow_access_to, (Object[])new String[]{requestFor, requestFor})).setPositiveButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CommonUtils.requestPermission(context, permissionNeededForList.toArray(new String[permissionNeededForList.size()]), requestCode);
                }
            }).setNegativeButton((CharSequence)context.getString(R.string.go_to_app_info), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                    intent.setData(uri);
                    ((Activity)context).startActivityForResult(intent, 10);
                }
            }).create().show();
        }
        CommonUtils.requestPermission(context, permissionNeededForList.toArray(new String[permissionNeededForList.size()]), requestCode);
        return false;
    }

    private static ArrayList<String> checkSelfPermission(Context context, String[] permissions) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder requestsFor = new StringBuilder();
        for (String permission2 : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)permission2) == 0) continue;
            list.add(permission2);
            if (CommonUtils.getBooleanSharedPreference(context, permission2, false)) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission2)) continue;
                if (requestsFor.length() > 0) {
                    requestsFor.append(", ");
                }
                requestsFor.append(permission2.substring(permission2.lastIndexOf(".") + 1));
                continue;
            }
            CommonUtils.setBooleanSharedPreference(context, permission2, true);
        }
        if (requestsFor.length() > 0) {
            list.add(requestsFor.toString());
        } else {
            list.add("");
        }
        return list;
    }

    private static void requestPermission(Context context, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions, (int)requestCode);
    }

    public static int isFrontCameraAvailable() {
        Camera.CameraInfo ci = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)ci);
            if (ci.facing != 1) continue;
            return 1;
        }
        return 0;
    }

    public static Bitmap doBrightness(Bitmap src, int value) {
        int width = src.getWidth();
        int height = src.getHeight();
        Bitmap bmOut = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)src.getConfig());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = src.getPixel(x, y);
                int A = Color.alpha((int)pixel);
                int R2 = Color.red((int)pixel);
                int G = Color.green((int)pixel);
                int B = Color.blue((int)pixel);
                if ((R2 += value) > 255) {
                    R2 = 255;
                } else if (R2 < 0) {
                    R2 = 0;
                }
                if ((G += value) > 255) {
                    G = 255;
                } else if (G < 0) {
                    G = 0;
                }
                if ((B += value) > 255) {
                    B = 255;
                } else if (B < 0) {
                    B = 0;
                }
                bmOut.setPixel(x, y, Color.argb((int)A, (int)R2, (int)G, (int)B));
            }
        }
        return bmOut;
    }
}

