/*
 * Decompiled with CFR 0.152.
 */
package com.fulongbin.decoder;

import android.text.TextUtils;
import android.util.Log;
import com.fulongbin.decoder.App;
import java.io.File;

public class Silk {
    static final String TAG = "Silk_v3_decoder";
    static String cacheDir;

    public static void setCacheDir(String dir) {
        cacheDir = dir;
    }

    public static String getCacheDir() {
        return cacheDir;
    }

    public static boolean checkCacheDir() {
        if (cacheDir == null) {
            Log.e((String)TAG, (String)"cacheDir is null , please setCacheDir");
            return false;
        }
        File fCacheDir = new File(cacheDir);
        if (!fCacheDir.canWrite()) {
            Log.e((String)TAG, (String)("cacheDir[" + cacheDir + "]  cat not write please set anther"));
        }
        return true;
    }

    private static String createPcmFileName(String src) {
        int index = src.lastIndexOf(47);
        String originName = src.substring(index, src.length());
        String temp = cacheDir + originName + ".pcm";
        Log.e((String)TAG, (String)("pmc temp " + temp));
        return temp;
    }

    private static void deleteTempFile(String url) {
        File pcm = new File(url);
        if (pcm.exists()) {
            pcm.delete();
        }
    }

    public static boolean convertMp3ToSilk(String src, String dest) {
        if (TextUtils.isEmpty((CharSequence)src) || TextUtils.isEmpty((CharSequence)dest)) {
            Log.e((String)TAG, (String)"src or dest is empty");
            return false;
        }
        if (!Silk.checkCacheDir()) {
            return false;
        }
        String temp = Silk.createPcmFileName(src);
        boolean result = Silk.mp3ToSilk(src, dest, temp) == 0;
        Silk.deleteTempFile(temp);
        return result;
    }

    public static boolean convertSilkToMp3(String src, String dest) {
        if (TextUtils.isEmpty((CharSequence)src) || TextUtils.isEmpty((CharSequence)dest)) {
            Log.e((String)TAG, (String)"src or dest is empty");
            return false;
        }
        if (!Silk.checkCacheDir()) {
            return false;
        }
        String temp = Silk.createPcmFileName(src);
        boolean result = Silk.silkToMp3(src, dest, temp) == 0;
        Silk.deleteTempFile(temp);
        return result;
    }

    public static boolean convertWavToSilk(String src, String dest) {
        if (TextUtils.isEmpty((CharSequence)src) || TextUtils.isEmpty((CharSequence)dest)) {
            Log.e((String)TAG, (String)"src or dest is empty");
            return false;
        }
        if (!Silk.checkCacheDir()) {
            return false;
        }
        String temp = Silk.createPcmFileName(src);
        boolean result = Silk.wavToSilk(src, dest, temp) == 0;
        Silk.deleteTempFile(temp);
        return result;
    }

    public static boolean convertSilkToWav(String src, String dest) {
        if (TextUtils.isEmpty((CharSequence)src) || TextUtils.isEmpty((CharSequence)dest)) {
            Log.e((String)TAG, (String)"src or dest is empty");
            return false;
        }
        if (!Silk.checkCacheDir()) {
            return false;
        }
        String temp = Silk.createPcmFileName(src);
        boolean result = Silk.silkToWav(src, dest, temp) == 0;
        Silk.deleteTempFile(temp);
        return result;
    }

    public static native int mp3ToSilk(String var0, String var1, String var2);

    public static native int silkToMp3(String var0, String var1, String var2);

    public static native int wavToSilk(String var0, String var1, String var2);

    public static native int silkToWav(String var0, String var1, String var2);

    static {
        System.loadLibrary("silk_v3_decoder");
        if (App.INSTANCE != null) {
            cacheDir = App.INSTANCE.getCacheDir().getAbsolutePath();
        }
    }
}

