/*
 * Decompiled with CFR 0.152.
 */
package com.fulmicoton.multiregexp;

import com.fulmicoton.multiregexp.MultiState;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.DkBricsAutomatonHelper;
import dk.brics.automaton.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultiPatternAutomaton {
    public final int[][] accept;
    final boolean[] atLeastOneAccept;
    private final int stride;
    private final int[] transitions;
    private final int[] alphabet;
    private final int nbPatterns;

    private MultiPatternAutomaton(int[][] accept, int[] transitions, char[] points, int nbPatterns) {
        this.accept = accept;
        this.transitions = transitions;
        this.alphabet = MultiPatternAutomaton.alphabet(points);
        this.stride = points.length;
        this.atLeastOneAccept = new boolean[accept.length];
        for (int i = 0; i < accept.length; ++i) {
            this.atLeastOneAccept[i] = this.accept[i].length > 0;
        }
        this.nbPatterns = nbPatterns;
    }

    private static int[] alphabet(char[] points) {
        int[] alphabet = new int[65536];
        int i = 0;
        for (char j = '\u0000'; j <= '\uffff'; ++j) {
            if (i + 1 >= points.length || j == points[i + 1]) {
                // empty if block
            }
            alphabet[j] = ++i;
        }
        return alphabet;
    }

    static MultiState initialState(List<Automaton> automata) {
        State[] initialStates = new State[automata.size()];
        int c = 0;
        for (Automaton automaton : automata) {
            initialStates[c] = automaton.getInitialState();
            ++c;
        }
        return new MultiState(initialStates);
    }

    static MultiPatternAutomaton make(List<Automaton> automata) {
        for (Automaton automaton : automata) {
            automaton.determinize();
        }
        char[] points = DkBricsAutomatonHelper.pointsUnion(automata);
        LinkedList<MultiState> statesToVisits = new LinkedList<MultiState>();
        MultiState initialState = MultiPatternAutomaton.initialState(automata);
        statesToVisits.add(initialState);
        ArrayList<int[]> transitionList = new ArrayList<int[]>();
        HashMap<MultiState, Integer> multiStateIndex = new HashMap<MultiState, Integer>();
        multiStateIndex.put(initialState, 0);
        while (!statesToVisits.isEmpty()) {
            MultiState visitingState = (MultiState)statesToVisits.remove();
            assert (multiStateIndex.containsKey(visitingState));
            int[] curTransitions = new int[points.length];
            for (int c = 0; c < points.length; ++c) {
                int destStateId;
                char point = points[c];
                MultiState destState = visitingState.step(point);
                if (destState.isNull()) {
                    curTransitions[c] = -1;
                    continue;
                }
                if (!multiStateIndex.containsKey(destState)) {
                    statesToVisits.add(destState);
                    destStateId = multiStateIndex.size();
                    multiStateIndex.put(destState, destStateId);
                } else {
                    destStateId = (Integer)multiStateIndex.get(destState);
                }
                curTransitions[c] = destStateId;
            }
            transitionList.add(curTransitions);
        }
        assert (transitionList.size() == multiStateIndex.size());
        int nbStates = multiStateIndex.size();
        int[] transitions = new int[nbStates * points.length];
        for (int stateId = 0; stateId < nbStates; ++stateId) {
            for (int pointId = 0; pointId < points.length; ++pointId) {
                transitions[stateId * points.length + pointId] = ((int[])transitionList.get(stateId))[pointId];
            }
        }
        int[][] acceptValues = new int[nbStates][];
        for (Map.Entry entry : multiStateIndex.entrySet()) {
            Integer stateId = (Integer)entry.getValue();
            MultiState multiState = (MultiState)entry.getKey();
            acceptValues[stateId.intValue()] = multiState.toAcceptValues();
        }
        return new MultiPatternAutomaton(acceptValues, transitions, points, automata.size());
    }

    public int step(int state, char c) {
        return this.transitions[state * this.stride + this.alphabet[c - '\u0000']];
    }

    public int getNbPatterns() {
        return this.nbPatterns;
    }
}

