/*
 * Decompiled with CFR 0.152.
 */
package androidx.security.crypto;

import android.content.SharedPreferences;
import androidx.collection.ArraySet;
import androidx.security.crypto.SecureWrappedOnSharedPreferenceChangeListener;
import androidx.security.crypto._InternalCoreHarmony__SecureHarmonyPreferencesKt;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.DeterministicAead;
import com.google.crypto.tink.subtle.Base64;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0002./B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J(\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0002\b\u00030\u001bH\u0016J\u001a\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J\u0014\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u0010 \u001a\u00020!2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020!H\u0016J\u001a\u0010\"\u001a\u00020#2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020#H\u0016J\u001a\u0010$\u001a\u00020%2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020%H\u0016J\u001e\u0010&\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003H\u0016J*\u0010'\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010(2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010(H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016J\u0010\u0010-\u001a\u00020+2\u0006\u0010,\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Landroidx/security/crypto/SecureHarmonyPreferencesImpl;", "Landroid/content/SharedPreferences;", "fileName", "", "sharedPreferences", "aead", "Lcom/google/crypto/tink/Aead;", "deterministicAead", "Lcom/google/crypto/tink/DeterministicAead;", "(Ljava/lang/String;Landroid/content/SharedPreferences;Lcom/google/crypto/tink/Aead;Lcom/google/crypto/tink/DeterministicAead;)V", "changedListeners", "Ljava/util/WeakHashMap;", "Landroid/content/SharedPreferences$OnSharedPreferenceChangeListener;", "Landroidx/security/crypto/SecureWrappedOnSharedPreferenceChangeListener;", "contains", "", "key", "decryptKey", "encryptedKey", "edit", "Landroid/content/SharedPreferences$Editor;", "encryptKey", "encryptKeyValuePair", "Lkotlin/Pair;", "bytes", "", "getAll", "", "getBoolean", "defValue", "getDecryptedObject", "", "getFloat", "", "getInt", "", "getLong", "", "getString", "getStringSet", "", "defValues", "registerOnSharedPreferenceChangeListener", "", "listener", "unregisterOnSharedPreferenceChangeListener", "EncryptedType", "SecureEditor", "crypto_release"})
@SourceDebugExtension(value={"SMAP\nSecureHarmonyPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureHarmonyPreferences.kt\nandroidx/security/crypto/SecureHarmonyPreferencesImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1855#2,2:356\n*S KotlinDebug\n*F\n+ 1 SecureHarmonyPreferences.kt\nandroidx/security/crypto/SecureHarmonyPreferencesImpl\n*L\n150#1:356,2\n*E\n"})
final class SecureHarmonyPreferencesImpl
implements SharedPreferences {
    @NotNull
    private final String fileName;
    @NotNull
    private final SharedPreferences sharedPreferences;
    @NotNull
    private final Aead aead;
    @NotNull
    private final DeterministicAead deterministicAead;
    @NotNull
    private final WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, SecureWrappedOnSharedPreferenceChangeListener> changedListeners;

    public SecureHarmonyPreferencesImpl(@NotNull String fileName, @NotNull SharedPreferences sharedPreferences, @NotNull Aead aead, @NotNull DeterministicAead deterministicAead) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)sharedPreferences, (String)"sharedPreferences");
        Intrinsics.checkNotNullParameter((Object)aead, (String)"aead");
        Intrinsics.checkNotNullParameter((Object)deterministicAead, (String)"deterministicAead");
        this.fileName = fileName;
        this.sharedPreferences = sharedPreferences;
        this.aead = aead;
        this.deterministicAead = deterministicAead;
        this.changedListeners = new WeakHashMap();
    }

    @NotNull
    public Map<String, ?> getAll() {
        HashMap allEntries = new HashMap();
        Iterable $this$forEach$iv = this.sharedPreferences.getAll().keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String key = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)key);
            String decryptedKey = this.decryptKey(key);
            ((Map)allEntries).put(decryptedKey, this.getDecryptedObject(decryptedKey));
        }
        return allEntries;
    }

    @Nullable
    public String getString(@Nullable String key, @Nullable String defValue) {
        Object obj = this.getDecryptedObject(key);
        String string = (String)obj;
        if (string == null) {
            string = defValue;
        }
        return string;
    }

    @Nullable
    public Set<String> getStringSet(@Nullable String key, @Nullable Set<String> defValues) {
        Object obj = this.getDecryptedObject(key);
        Set set = (Set)obj;
        if (set == null || (set = CollectionsKt.toMutableSet((Iterable)set)) == null) {
            set = defValues;
        }
        return set;
    }

    public int getInt(@Nullable String key, int defValue) {
        Object obj = this.getDecryptedObject(key);
        Integer n = (Integer)obj;
        return n != null ? n : defValue;
    }

    public long getLong(@Nullable String key, long defValue) {
        Object obj = this.getDecryptedObject(key);
        Long l = (Long)obj;
        return l != null ? l : defValue;
    }

    public float getFloat(@Nullable String key, float defValue) {
        Object obj = this.getDecryptedObject(key);
        Float f = (Float)obj;
        return f != null ? f.floatValue() : defValue;
    }

    public boolean getBoolean(@Nullable String key, boolean defValue) {
        Object obj = this.getDecryptedObject(key);
        Boolean bl = (Boolean)obj;
        return bl != null ? bl : defValue;
    }

    public boolean contains(@Nullable String key) {
        String encryptedKey = this.encryptKey(key);
        return this.sharedPreferences.contains(encryptedKey);
    }

    @NotNull
    public SharedPreferences.Editor edit() {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"edit(...)");
        return new SecureEditor(editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        SecureHarmonyPreferencesImpl secureHarmonyPreferencesImpl = this;
        synchronized (secureHarmonyPreferencesImpl) {
            boolean bl = false;
            SecureWrappedOnSharedPreferenceChangeListener secureListener = new SecureWrappedOnSharedPreferenceChangeListener(this, listener);
            ((Map)this.changedListeners).put(listener, secureListener);
            this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)secureListener);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(@NotNull SharedPreferences.OnSharedPreferenceChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        SecureHarmonyPreferencesImpl secureHarmonyPreferencesImpl = this;
        synchronized (secureHarmonyPreferencesImpl) {
            boolean bl = false;
            SecureWrappedOnSharedPreferenceChangeListener secureListener = this.changedListeners.remove(listener);
            if (secureListener != null) {
                this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)secureListener);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Object getDecryptedObject(String key) {
        String string = key;
        if (string == null) {
            string = "__NULL__";
        }
        String mutableKey = string;
        try {
            String encryptedKey = this.encryptKey(mutableKey);
            String encryptedValue = this.sharedPreferences.getString(encryptedKey, null);
            if (encryptedValue != null) {
                byte[] cipherText = Base64.decode((String)encryptedValue, (int)0);
                byte[] byArray = encryptedKey.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] result = this.aead.decrypt(cipherText, byArray);
                ByteBuffer buffer = ByteBuffer.wrap(result);
                buffer.position(0);
                switch (buffer.getInt()) {
                    case 0: {
                        int stringLength = buffer.getInt();
                        ByteBuffer stringSlice = buffer.slice();
                        buffer.limit(stringLength);
                        String string2 = Charsets.UTF_8.decode(stringSlice).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                        String stringValue = string2;
                        return Intrinsics.areEqual((Object)stringValue, (Object)"__NULL__") ? null : stringValue;
                    }
                    case 2: {
                        return buffer.getInt();
                    }
                    case 3: {
                        return buffer.getLong();
                    }
                    case 4: {
                        return Float.valueOf(buffer.getFloat());
                    }
                    case 5: {
                        return buffer.get() != 0;
                    }
                    case 1: {
                        ArraySet stringSet = new ArraySet(0, 1, null);
                        while (buffer.hasRemaining()) {
                            String s;
                            int subStringLength = buffer.getInt();
                            ByteBuffer subStringSlice = buffer.slice();
                            subStringSlice.limit(subStringLength);
                            buffer.position(buffer.position() + subStringLength);
                            Intrinsics.checkNotNullExpressionValue((Object)Charsets.UTF_8.decode(subStringSlice).toString(), (String)"toString(...)");
                            if (Intrinsics.areEqual((Object)s, (Object)"__NULL__")) {
                                stringSet.add(null);
                                continue;
                            }
                            stringSet.add((Object)s);
                        }
                        return stringSet;
                    }
                }
                return null;
            }
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("Could not decrypt value. " + e.getMessage(), e);
        }
        return null;
    }

    private final String encryptKey(String key) {
        String string = key;
        if (string == null) {
            string = "__NULL__";
        }
        String k = string;
        try {
            byte[] byArray = k.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String string2 = this.fileName;
            byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] encryptedKeyBytes = this.deterministicAead.encryptDeterministically(byArray, byArray2);
            String string3 = Base64.encode((byte[])encryptedKeyBytes);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encode(...)");
            return string3;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("Could not encrypt key. " + e.getMessage(), e);
        }
    }

    @Nullable
    public final String decryptKey(@NotNull String encryptedKey) {
        Intrinsics.checkNotNullParameter((Object)encryptedKey, (String)"encryptedKey");
        try {
            byte[] byArray = Base64.decode((String)encryptedKey, (int)0);
            String string = this.fileName;
            byte[] byArray2 = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            byte[] clearText = this.deterministicAead.decryptDeterministically(byArray, byArray2);
            Intrinsics.checkNotNull((Object)clearText);
            String key = new String(clearText, Charsets.UTF_8);
            if (Intrinsics.areEqual((Object)key, (Object)"__NULL__")) {
                key = null;
            }
            return key;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("Could not decrypt key. " + e.getMessage(), e);
        }
    }

    private final Pair<String, String> encryptKeyValuePair(String key, byte[] bytes) {
        String encryptedKey = this.encryptKey(key);
        if (bytes.length == 0) {
            return TuplesKt.to((Object)encryptedKey, null);
        }
        byte[] byArray = encryptedKey.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] cipherText = this.aead.encrypt(bytes, byArray);
        return TuplesKt.to((Object)encryptedKey, (Object)Base64.encode((byte[])cipherText));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Landroidx/security/crypto/SecureHarmonyPreferencesImpl$EncryptedType;", "", "()V", "BOOLEAN", "", "FLOAT", "INT", "LONG", "STRING", "STRING_SET", "crypto_release"})
    private static final class EncryptedType {
        @NotNull
        public static final EncryptedType INSTANCE = new EncryptedType();
        public static final int STRING = 0;
        public static final int STRING_SET = 1;
        public static final int INT = 2;
        public static final int LONG = 3;
        public static final int FLOAT = 4;
        public static final int BOOLEAN = 5;

        private EncryptedType() {
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0004\u001a\u00020\u0005H\u0096\u0001J\u0011\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00010\u0001H\u0096\u0001J\t\u0010\b\u001a\u00020\tH\u0096\u0001J\u001a\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\tH\u0016J\u001a\u0010\u000e\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0015H\u0016J\u001c\u0010\u0016\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0016J$\u0010\u0017\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\u0010\u0018\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Landroidx/security/crypto/SecureHarmonyPreferencesImpl$SecureEditor;", "Landroid/content/SharedPreferences$Editor;", "editor", "(Landroidx/security/crypto/SecureHarmonyPreferencesImpl;Landroid/content/SharedPreferences$Editor;)V", "apply", "", "clear", "kotlin.jvm.PlatformType", "commit", "", "putBoolean", "key", "", "value", "putEncryptedObject", "", "putFloat", "", "putInt", "", "putLong", "", "putString", "putStringSet", "values", "", "remove", "crypto_release"})
    @SourceDebugExtension(value={"SMAP\nSecureHarmonyPreferences.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecureHarmonyPreferences.kt\nandroidx/security/crypto/SecureHarmonyPreferencesImpl$SecureEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,355:1\n1855#2,2:356\n1855#2,2:358\n*S KotlinDebug\n*F\n+ 1 SecureHarmonyPreferences.kt\nandroidx/security/crypto/SecureHarmonyPreferencesImpl$SecureEditor\n*L\n81#1:356,2\n90#1:358,2\n*E\n"})
    private final class SecureEditor
    implements SharedPreferences.Editor {
        @NotNull
        private final SharedPreferences.Editor editor;

        public SecureEditor(SharedPreferences.Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
        }

        public void apply() {
            this.editor.apply();
        }

        public SharedPreferences.Editor clear() {
            return this.editor.clear();
        }

        public boolean commit() {
            return this.editor.commit();
        }

        @NotNull
        public SharedPreferences.Editor putString(@Nullable String key, @Nullable String value) {
            Object stringBytes;
            Object object;
            block6: {
                block5: {
                    object = value;
                    if (object == null) break block5;
                    byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    object = byArray;
                    if (byArray != null) break block6;
                }
                object = _InternalCoreHarmony__SecureHarmonyPreferencesKt.access$getEMPTY_BYTE_ARRAY$p();
            }
            if (((Object)(stringBytes = object)).length == 0) {
                this.putEncryptedObject(key, _InternalCoreHarmony__SecureHarmonyPreferencesKt.access$getEMPTY_BYTE_ARRAY$p());
            } else {
                int stringByteLength = ((Object)stringBytes).length;
                ByteBuffer buffer = ByteBuffer.allocate(8 + stringByteLength);
                buffer.putInt(0);
                buffer.putInt(stringByteLength);
                buffer.put((byte[])stringBytes);
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                this.putEncryptedObject(key, byArray);
            }
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putStringSet(@Nullable String key, @Nullable Set<String> values) {
            if (values == null) {
                this.putEncryptedObject(key, _InternalCoreHarmony__SecureHarmonyPreferencesKt.access$getEMPTY_BYTE_ARRAY$p());
            } else {
                ArrayList<byte[]> byteValues = new ArrayList<byte[]>();
                int totalBytes = 0;
                totalBytes = values.size() * 4;
                Iterable $this$forEach$iv = values;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    byte[] byteValue;
                    String strValue = (String)element$iv;
                    boolean bl = false;
                    String string = strValue;
                    if (string == null) {
                        string = "__NULL__";
                    }
                    String v = string;
                    Intrinsics.checkNotNullExpressionValue((Object)v.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
                    byteValues.add(byteValue);
                    totalBytes += byteValue.length;
                }
                ByteBuffer buffer = ByteBuffer.allocate(totalBytes += 4);
                buffer.putInt(1);
                Iterable $this$forEach$iv2 = byteValues;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    byte[] bytes = (byte[])element$iv;
                    boolean bl = false;
                    buffer.putInt(bytes.length);
                    buffer.put(bytes);
                }
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
                this.putEncryptedObject(key, byArray);
            }
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putInt(@Nullable String key, int value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(2);
            buffer.putInt(value);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this.putEncryptedObject(key, byArray);
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putLong(@Nullable String key, long value) {
            ByteBuffer buffer = ByteBuffer.allocate(12);
            buffer.putInt(3);
            buffer.putLong(value);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this.putEncryptedObject(key, byArray);
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putFloat(@Nullable String key, float value) {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putInt(4);
            buffer.putFloat(value);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this.putEncryptedObject(key, byArray);
            return this;
        }

        @NotNull
        public SharedPreferences.Editor putBoolean(@Nullable String key, boolean value) {
            ByteBuffer buffer = ByteBuffer.allocate(5);
            buffer.putInt(5);
            buffer.put(value ? (byte)1 : 0);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            this.putEncryptedObject(key, byArray);
            return this;
        }

        @NotNull
        public SharedPreferences.Editor remove(@Nullable String key) {
            String string = key;
            if (string == null) {
                string = "__NULL__";
            }
            SharedPreferences.Editor editor = this.editor.remove(SecureHarmonyPreferencesImpl.this.encryptKey(string));
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"remove(...)");
            return editor;
        }

        private final void putEncryptedObject(String key, byte[] value) {
            String string = key;
            if (string == null) {
                string = "__NULL__";
            }
            String mutableKey = string;
            try {
                Pair encryptedPair = SecureHarmonyPreferencesImpl.this.encryptKeyValuePair(mutableKey, value);
                this.editor.putString((String)encryptedPair.getFirst(), (String)encryptedPair.getSecond());
            }
            catch (GeneralSecurityException e) {
                throw new SecurityException("Could not encrypt data: " + e.getMessage(), e);
            }
        }
    }
}

