/*
 * Decompiled with CFR 0.152.
 */
package com.fox.one.pay.core.rate;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.fox.one.pay.core.model.CurrencyTicker;
import com.fox.one.pay.core.rate.CurrencyRateServerFramework$WhenMappings;
import com.fox.one.support.framework.Currency;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u0000 (2\u00020\u0001:\u0003()*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0010J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH$J\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0018J\u0016\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u000bJ\u0016\u0010 \u001a\u00020\u00182\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004J\u000e\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bJ\u0006\u0010$\u001a\u00020\u000bJ\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bJ\u0006\u0010'\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework;", "", "()V", "currencyTickers", "", "Lcom/fox/one/pay/core/model/CurrencyTicker;", "exchangeRateHandler", "Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework$ExchangeRateHandler;", "syncEnable", "", "cny2usd", "", "cnyValue", "cny2usdt", "fromCNYValue", "targetSymbol", "", "getLegalSign", "currency", "Lcom/fox/one/support/framework/Currency;", "getLegalSymbol", "getRateBaseCNY", "symbol", "onSyncExchangeRate", "", "listener", "Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework$OnExchangeRateUpdateListener;", "startSync", "stopSync", "toCNYValue", "sourceSymbol", "value", "updateRates", "rateTickers", "usd2cny", "usdValue", "usdRate", "usdt2cny", "usdtValue", "usdtRate", "Companion", "ExchangeRateHandler", "OnExchangeRateUpdateListener", "pay_release"})
public abstract class CurrencyRateServerFramework {
    private boolean syncEnable;
    private ExchangeRateHandler exchangeRateHandler = new ExchangeRateHandler();
    private List<CurrencyTicker> currencyTickers;
    private static final int WHAT_SYNC = 1;
    private static final long DELAY_RETRY = 600L;
    private static final long DELAY_SYNC = 10000L;
    public static final Companion Companion = new Companion(null);

    protected abstract void onSyncExchangeRate(@NotNull OnExchangeRateUpdateListener var1);

    public final void updateRates(@Nullable List<CurrencyTicker> rateTickers) {
        List list = rateTickers;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        this.currencyTickers = list;
    }

    public final double getRateBaseCNY(@NotNull String symbol) {
        CurrencyTicker ticker;
        CurrencyTicker currencyTicker;
        Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
        List<CurrencyTicker> list = this.currencyTickers;
        if (list != null) {
            Object v1;
            block3: {
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    CurrencyTicker it = (CurrencyTicker)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getFrom(), (Object)symbol)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            currencyTicker = v1;
        } else {
            currencyTicker = null;
        }
        CurrencyTicker currencyTicker2 = ticker = currencyTicker;
        return currencyTicker2 != null ? currencyTicker2.getPrice() : 1.0;
    }

    public final double usdRate() {
        return this.getRateBaseCNY(Currency.USD.name());
    }

    public final double usdtRate() {
        return this.getRateBaseCNY(Currency.USDT.name());
    }

    public final double usd2cny(double usdValue) {
        return this.toCNYValue(Currency.USD.name(), usdValue);
    }

    public final double cny2usd(double cnyValue) {
        return this.fromCNYValue(Currency.USD.name(), cnyValue);
    }

    public final double usdt2cny(double usdtValue) {
        return this.toCNYValue(Currency.USDT.name(), usdtValue);
    }

    public final double cny2usdt(double cnyValue) {
        return this.fromCNYValue(Currency.USDT.name(), cnyValue);
    }

    public final double toCNYValue(@NotNull String sourceSymbol, double value) {
        Intrinsics.checkParameterIsNotNull((Object)sourceSymbol, (String)"sourceSymbol");
        return this.getRateBaseCNY(sourceSymbol) * value;
    }

    public final double fromCNYValue(@NotNull String targetSymbol, double cnyValue) {
        Intrinsics.checkParameterIsNotNull((Object)targetSymbol, (String)"targetSymbol");
        return cnyValue / this.getRateBaseCNY(targetSymbol);
    }

    @NotNull
    public final String getLegalSymbol(@NotNull Currency currency) {
        Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
        return currency.name();
    }

    @NotNull
    public final String getLegalSign(@NotNull Currency currency) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
        switch (CurrencyRateServerFramework$WhenMappings.$EnumSwitchMapping$0[currency.ordinal()]) {
            case 1: {
                string = "\u00a5";
                break;
            }
            case 2: {
                string = "$";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public final void startSync() {
        this.syncEnable = true;
        this.exchangeRateHandler.removeMessages(1);
        this.exchangeRateHandler.sendEmptyMessage(1);
    }

    public final void stopSync() {
        this.syncEnable = false;
        this.exchangeRateHandler.removeMessages(1);
    }

    public static final /* synthetic */ void access$setSyncEnable$p(CurrencyRateServerFramework $this, boolean bl) {
        $this.syncEnable = bl;
    }

    @Nullable
    public static final /* synthetic */ List access$getCurrencyTickers$p(CurrencyRateServerFramework $this) {
        return $this.currencyTickers;
    }

    public static final /* synthetic */ void access$setCurrencyTickers$p(CurrencyRateServerFramework $this, @Nullable List list) {
        $this.currencyTickers = list;
    }

    @NotNull
    public static final /* synthetic */ ExchangeRateHandler access$getExchangeRateHandler$p(CurrencyRateServerFramework $this) {
        return $this.exchangeRateHandler;
    }

    public static final /* synthetic */ void access$setExchangeRateHandler$p(CurrencyRateServerFramework $this, @NotNull ExchangeRateHandler exchangeRateHandler) {
        $this.exchangeRateHandler = exchangeRateHandler;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework$ExchangeRateHandler;", "Landroid/os/Handler;", "(Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "pay_release"})
    public final class ExchangeRateHandler
    extends Handler {
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            if (1 == msg.what && CurrencyRateServerFramework.this.syncEnable) {
                CurrencyRateServerFramework.this.onSyncExchangeRate(new OnExchangeRateUpdateListener(this){
                    final /* synthetic */ ExchangeRateHandler this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void onRateUpdated(@Nullable List<CurrencyTicker> cnyTickers) {
                        block2: {
                            block1: {
                                CurrencyRateServerFramework.access$setCurrencyTickers$p(this.this$0.CurrencyRateServerFramework.this, cnyTickers);
                                if (CurrencyRateServerFramework.access$getCurrencyTickers$p(this.this$0.CurrencyRateServerFramework.this) == null) break block1;
                                List list = CurrencyRateServerFramework.access$getCurrencyTickers$p(this.this$0.CurrencyRateServerFramework.this);
                                if (list == null) break block2;
                                if (!list.isEmpty()) break block2;
                            }
                            CurrencyRateServerFramework.access$getExchangeRateHandler$p(this.this$0.CurrencyRateServerFramework.this).sendEmptyMessageDelayed(1, 600L);
                            return;
                        }
                        CurrencyRateServerFramework.access$getExchangeRateHandler$p(this.this$0.CurrencyRateServerFramework.this).sendEmptyMessageDelayed(1, 10000L);
                    }
                    {
                        this.this$0 = $outer;
                    }
                });
            }
        }

        public ExchangeRateHandler() {
            super(Looper.getMainLooper());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework$OnExchangeRateUpdateListener;", "", "onRateUpdated", "", "cnyTickers", "", "Lcom/fox/one/pay/core/model/CurrencyTicker;", "pay_release"})
    public static interface OnExchangeRateUpdateListener {
        public void onRateUpdated(@Nullable List<CurrencyTicker> var1);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateServerFramework$Companion;", "", "()V", "DELAY_RETRY", "", "DELAY_SYNC", "WHAT_SYNC", "", "pay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

