/*
 * Decompiled with CFR 0.152.
 */
package com.fox.one.pay.core.rate;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.fox.one.pay.core.model.CurrencyTicker;
import com.fox.one.pay.core.rate.CurrencyRateAPI;
import com.fox.one.pay.core.rate.CurrencyRateManager$WhenMappings;
import com.fox.one.pay.core.rate.CurrencyResponse;
import com.fox.one.support.framework.Currency;
import com.fox.one.support.framework.network.APILoader;
import com.fox.one.support.framework.network.HttpEngine;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000201B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001fJ\u0006\u0010#\u001a\u00020\u001fJ\u0012\u0010$\u001a\u00020\u001f2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0016\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0012J\u000e\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012J\u0006\u0010,\u001a\u00020\u0012J\u000e\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u0012J\u0006\u0010/\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateManager;", "", "()V", "DELAY_RETRY", "", "DELAY_SYNC", "WHAT_SYNC", "", "apiLoader", "Lcom/fox/one/support/framework/network/APILoader;", "currencyTickers", "", "Lcom/fox/one/pay/core/model/CurrencyTicker;", "exchangeRateHandler", "Lcom/fox/one/pay/core/rate/CurrencyRateManager$ExchangeRateHandler;", "syncEnable", "", "cny2usd", "", "cnyValue", "cny2usdt", "fromCNYValue", "targetSymbol", "", "getLegalSign", "currency", "Lcom/fox/one/support/framework/Currency;", "getLegalSymbol", "getRateBaseCNY", "symbol", "init", "", "application", "Landroid/app/Application;", "startSync", "stopSync", "syncExchangeRate", "listener", "Lcom/fox/one/pay/core/rate/CurrencyRateManager$OnExchangeRateUpdateListener;", "toCNYValue", "sourceSymbol", "value", "usd2cny", "usdValue", "usdRate", "usdt2cny", "usdtValue", "usdtRate", "ExchangeRateHandler", "OnExchangeRateUpdateListener", "pay_release"})
public final class CurrencyRateManager {
    private static final int WHAT_SYNC = 1;
    private static final long DELAY_RETRY = 600L;
    private static final long DELAY_SYNC = 10000L;
    private static boolean syncEnable;
    private static ExchangeRateHandler exchangeRateHandler;
    private static final APILoader apiLoader;
    private static List<CurrencyTicker> currencyTickers;
    public static final CurrencyRateManager INSTANCE;

    public final void init(@NotNull Application application) {
        OkHttpClient okHttpClient;
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        OkHttpClient okHttpClient2 = okHttpClient = new OkHttpClient.Builder().addInterceptor(HttpEngine.Companion.getDefaultInterceptor()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient2, (String)"okHttpClient");
        apiLoader.setOkHttp(okHttpClient2);
        apiLoader.setBaseUri(new APILoader.BaseUrl("https://dev-gateway.fox.one", "https://openapi.fox.one", "https://openapi.fox.one"));
        this.startSync();
    }

    private final void syncExchangeRate(OnExchangeRateUpdateListener listener) {
        ((CurrencyRateAPI)apiLoader.load(CurrencyRateAPI.class)).getCurrencyRates().enqueue((Callback)new Callback<CurrencyResponse>(listener){
            final /* synthetic */ OnExchangeRateUpdateListener $listener;

            public void onFailure(@NotNull Call<CurrencyResponse> call, @NotNull Throwable t) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                    OnExchangeRateUpdateListener onExchangeRateUpdateListener = this.$listener;
                    if (onExchangeRateUpdateListener == null) break block0;
                    onExchangeRateUpdateListener.onRateUpdated(null);
                }
            }

            public void onResponse(@NotNull Call<CurrencyResponse> call, @NotNull Response<CurrencyResponse> response) {
                block0: {
                    Intrinsics.checkParameterIsNotNull(call, (String)"call");
                    Intrinsics.checkParameterIsNotNull(response, (String)"response");
                    Object object = (CurrencyResponse)((Object)response.body());
                    CurrencyRateManager.access$setCurrencyTickers$p(CurrencyRateManager.INSTANCE, object != null && (object = object.getData()) != null ? ((CurrencyResponse.Data)object).getCnyTickers() : null);
                    OnExchangeRateUpdateListener onExchangeRateUpdateListener = this.$listener;
                    if (onExchangeRateUpdateListener == null) break block0;
                    onExchangeRateUpdateListener.onRateUpdated(CurrencyRateManager.access$getCurrencyTickers$p(CurrencyRateManager.INSTANCE));
                }
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
    }

    public final double getRateBaseCNY(@NotNull String symbol) {
        CurrencyTicker ticker;
        CurrencyTicker currencyTicker;
        Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
        List<CurrencyTicker> list = currencyTickers;
        if (list != null) {
            Object v1;
            block3: {
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    CurrencyTicker it = (CurrencyTicker)element$iv;
                    if (!Intrinsics.areEqual((Object)it.getFrom(), (Object)symbol)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            currencyTicker = v1;
        } else {
            currencyTicker = null;
        }
        CurrencyTicker currencyTicker2 = ticker = currencyTicker;
        return currencyTicker2 != null ? currencyTicker2.getPrice() : 1.0;
    }

    public final double usdRate() {
        return this.getRateBaseCNY(Currency.USD.name());
    }

    public final double usdtRate() {
        return this.getRateBaseCNY(Currency.USDT.name());
    }

    public final double usd2cny(double usdValue) {
        return this.toCNYValue(Currency.USD.name(), usdValue);
    }

    public final double cny2usd(double cnyValue) {
        return this.fromCNYValue(Currency.USD.name(), cnyValue);
    }

    public final double usdt2cny(double usdtValue) {
        return this.toCNYValue(Currency.USDT.name(), usdtValue);
    }

    public final double cny2usdt(double cnyValue) {
        return this.fromCNYValue(Currency.USDT.name(), cnyValue);
    }

    public final double toCNYValue(@NotNull String sourceSymbol, double value) {
        Intrinsics.checkParameterIsNotNull((Object)sourceSymbol, (String)"sourceSymbol");
        return this.getRateBaseCNY(sourceSymbol) * value;
    }

    public final double fromCNYValue(@NotNull String targetSymbol, double cnyValue) {
        Intrinsics.checkParameterIsNotNull((Object)targetSymbol, (String)"targetSymbol");
        return cnyValue / this.getRateBaseCNY(targetSymbol);
    }

    @NotNull
    public final String getLegalSymbol(@NotNull Currency currency) {
        Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
        return currency.name();
    }

    @NotNull
    public final String getLegalSign(@NotNull Currency currency) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)currency, (String)"currency");
        switch (CurrencyRateManager$WhenMappings.$EnumSwitchMapping$0[currency.ordinal()]) {
            case 1: {
                string = "\u00a5";
                break;
            }
            case 2: {
                string = "$";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public final void startSync() {
        syncEnable = true;
        exchangeRateHandler.removeMessages(1);
        exchangeRateHandler.sendEmptyMessage(1);
    }

    public final void stopSync() {
        syncEnable = false;
        exchangeRateHandler.removeMessages(1);
    }

    private CurrencyRateManager() {
    }

    static {
        CurrencyRateManager currencyRateManager;
        INSTANCE = currencyRateManager = new CurrencyRateManager();
        exchangeRateHandler = new ExchangeRateHandler();
        apiLoader = new APILoader();
    }

    public static final /* synthetic */ boolean access$getSyncEnable$p(CurrencyRateManager $this) {
        CurrencyRateManager currencyRateManager = $this;
        return syncEnable;
    }

    public static final /* synthetic */ void access$setSyncEnable$p(CurrencyRateManager $this, boolean bl) {
        CurrencyRateManager currencyRateManager = $this;
        syncEnable = bl;
    }

    @Nullable
    public static final /* synthetic */ List access$getCurrencyTickers$p(CurrencyRateManager $this) {
        CurrencyRateManager currencyRateManager = $this;
        return currencyTickers;
    }

    public static final /* synthetic */ void access$setCurrencyTickers$p(CurrencyRateManager $this, @Nullable List list) {
        CurrencyRateManager currencyRateManager = $this;
        currencyTickers = list;
    }

    @NotNull
    public static final /* synthetic */ ExchangeRateHandler access$getExchangeRateHandler$p(CurrencyRateManager $this) {
        CurrencyRateManager currencyRateManager = $this;
        return exchangeRateHandler;
    }

    public static final /* synthetic */ void access$setExchangeRateHandler$p(CurrencyRateManager $this, @NotNull ExchangeRateHandler exchangeRateHandler) {
        CurrencyRateManager currencyRateManager = $this;
        CurrencyRateManager.exchangeRateHandler = exchangeRateHandler;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateManager$ExchangeRateHandler;", "Landroid/os/Handler;", "()V", "handleMessage", "", "msg", "Landroid/os/Message;", "pay_release"})
    public static final class ExchangeRateHandler
    extends Handler {
        public void handleMessage(@NotNull Message msg) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            if (1 == msg.what && CurrencyRateManager.access$getSyncEnable$p(INSTANCE)) {
                INSTANCE.syncExchangeRate(new OnExchangeRateUpdateListener(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void onRateUpdated(@Nullable List<CurrencyTicker> cnyTickers) {
                        block2: {
                            block1: {
                                if (CurrencyRateManager.access$getCurrencyTickers$p(CurrencyRateManager.INSTANCE) == null) break block1;
                                List list = CurrencyRateManager.access$getCurrencyTickers$p(CurrencyRateManager.INSTANCE);
                                if (list == null) break block2;
                                if (!list.isEmpty()) break block2;
                            }
                            CurrencyRateManager.access$getExchangeRateHandler$p(CurrencyRateManager.INSTANCE).sendEmptyMessageDelayed(1, 600L);
                            return;
                        }
                        CurrencyRateManager.access$getExchangeRateHandler$p(CurrencyRateManager.INSTANCE).sendEmptyMessageDelayed(1, 10000L);
                    }
                });
            }
        }

        public ExchangeRateHandler() {
            super(Looper.getMainLooper());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/fox/one/pay/core/rate/CurrencyRateManager$OnExchangeRateUpdateListener;", "", "onRateUpdated", "", "cnyTickers", "", "Lcom/fox/one/pay/core/model/CurrencyTicker;", "pay_release"})
    public static interface OnExchangeRateUpdateListener {
        public void onRateUpdated(@Nullable List<CurrencyTicker> var1);
    }
}

