/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.parser;

import com.sforce.ws.parser.MXSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;

public class XmlOutputStream
implements AutoCloseable {
    private MXSerializer serializer = new MXSerializer();
    private OutputStream out;

    public XmlOutputStream(OutputStream out, boolean prettyPrint) throws IOException {
        this.out = out;
        this.serializer.setOutput(out, "UTF-8");
        if (prettyPrint) {
            Objects.requireNonNull(this.serializer);
            this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", " ");
        }
    }

    public XmlOutputStream(OutputStream out, String prettyPrintIndentation) throws IOException {
        this.out = out;
        this.serializer.setOutput(out, "UTF-8");
        Objects.requireNonNull(this.serializer);
        this.serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", prettyPrintIndentation);
    }

    public String getPrefix(String namespace) {
        return this.serializer.getPrefix(namespace, false);
    }

    public void startDocument() throws IOException {
        this.serializer.startDocument("UTF-8", null);
    }

    public void endDocument() throws IOException {
        this.serializer.endDocument();
    }

    public void setPrefix(String prefix, String namespace) throws IOException {
        this.serializer.setPrefix(prefix, namespace);
    }

    public void writeStartTag(String namespace, String name) throws IOException {
        this.serializer.startTag(namespace, name);
    }

    public void writeEndTag(String namespace, String name) throws IOException {
        this.serializer.endTag(namespace, name);
    }

    public void writeStringElement(String namespace, String name, String content) throws IOException {
        this.writeStartTag(namespace, name);
        if (content == null) {
            this.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        } else {
            this.writeText(content);
        }
        this.writeEndTag(namespace, name);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException {
        this.serializer.attribute(namespace, name, value);
    }

    public void writeText(String text) throws IOException {
        this.serializer.text(text);
    }

    public void writeComment(String text) throws IOException {
        this.serializer.comment(text);
    }

    public Writer getWriter() {
        return this.serializer.getWriter();
    }

    public void flush() throws IOException {
        this.serializer.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

