/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.template.Template;
import com.sforce.ws.template.TemplateException;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.Types;
import java.io.File;
import java.io.IOException;

public abstract class TypeGenerator {
    protected String packageName;
    protected String className;
    protected File tempDir;
    protected TypeMapper mapper;
    protected Types types;

    public TypeGenerator(Types types, Schema schema, String name, File tempDir, TypeMapper typeMapper) {
        this.packageName = NameMapper.getPackageName(schema.getTargetNamespace(), typeMapper.getPackagePrefix());
        this.className = NameMapper.getClassName(name);
        this.types = types;
        this.mapper = typeMapper;
        this.tempDir = tempDir;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    protected abstract String getTemplate();

    public String generate() throws IOException, TemplateException {
        File dir = FileUtil.mkdirs(this.packageName, this.tempDir);
        Template template = new Template();
        template.setProperty("gen", this);
        File javaFile = new File(dir, this.className + ".java");
        template.exec(this.getTemplate(), javaFile.getAbsolutePath());
        return javaFile.getAbsolutePath();
    }
}

