/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools.sync;

import com.foilen.smalltools.tools.sync.SyncChanges;
import com.foilen.smalltools.tools.sync.SyncConfiguration;
import com.foilen.smalltools.tools.sync.SyncSlice;
import com.foilen.smalltools.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SyncTools {
    private static final Logger log = LoggerFactory.getLogger(SyncTools.class);

    private static <E, I, P> I findFrom(SyncConfiguration<I, E, P> syncConfiguration, SyncSlice<I> syncSlice, List<E> sourceEntities, List<P> destinationEntities) {
        Object from = null;
        if (!sourceEntities.isEmpty()) {
            if (syncSlice.getAfterId().isPresent()) {
                Optional<Object> first = sourceEntities.stream().map(it -> syncConfiguration.getIdFromEntity().apply(it)).filter(it -> syncConfiguration.getCompareId().apply(it, syncSlice.getAfterId().get()) > 0).findFirst();
                if (first.isPresent()) {
                    from = first.get();
                }
            } else {
                from = syncConfiguration.getIdFromEntity().apply(sourceEntities.get(0));
            }
        }
        if (!destinationEntities.isEmpty()) {
            Object finalFrom = from;
            Optional<Object> first = destinationEntities.stream().map(it -> syncConfiguration.getIdFromPartial().apply(it)).filter(it -> !syncSlice.getAfterId().isPresent() || syncConfiguration.getCompareId().apply(it, syncSlice.getAfterId().get()) > 0).filter(it -> finalFrom == null || syncConfiguration.getCompareId().apply(it, finalFrom) < 0).findFirst();
            if (first.isPresent()) {
                from = first.get();
            }
        }
        return (I)from;
    }

    private static <E, I, P> I findTo(SyncConfiguration<I, E, P> syncConfiguration, List<E> sourceEntities, List<P> destinationEntities) {
        Object to = null;
        if (!sourceEntities.isEmpty()) {
            to = syncConfiguration.getIdFromEntity().apply(sourceEntities.get(sourceEntities.size() - 1));
        }
        if (!destinationEntities.isEmpty()) {
            I otherId = syncConfiguration.getIdFromPartial().apply(destinationEntities.get(destinationEntities.size() - 1));
            if (to == null) {
                to = otherId;
            } else if (syncConfiguration.getCompareId().apply(otherId, to) < 0) {
                to = otherId;
            }
        }
        return (I)to;
    }

    public static final <E, I, P> SyncChanges sync(SyncConfiguration<I, E, P> syncConfiguration) {
        return SyncTools.sync(syncConfiguration, new SyncSlice());
    }

    public static final <E, I, P> SyncChanges sync(SyncConfiguration<I, E, P> syncConfiguration, SyncSlice<I> slice) {
        SyncChanges changes = new SyncChanges();
        List<E> sourceEntities = null;
        List<P> destinationEntities = null;
        boolean updateSource = true;
        boolean updateDestination = true;
        Object fromId = null;
        Object toId = null;
        while (updateSource || updateDestination) {
            log.debug("Processing slice: {} ; updateSource {} ; updateDestination {} ", new Object[]{slice, updateSource, updateDestination});
            if (updateSource) {
                sourceEntities = syncConfiguration.getSourceSlice().call(slice, syncConfiguration.getMaxSliceSize());
                updateSource = false;
            }
            if (updateDestination) {
                destinationEntities = syncConfiguration.getDestinationSlice().call(slice, syncConfiguration.getMaxSliceSize());
                updateDestination = false;
            }
            if (sourceEntities.isEmpty() && destinationEntities.isEmpty()) {
                log.debug("There is nothing else on both sides. Processing completed");
                continue;
            }
            fromId = SyncTools.findFrom(syncConfiguration, slice, sourceEntities, destinationEntities);
            toId = SyncTools.findTo(syncConfiguration, sourceEntities, destinationEntities);
            log.debug("From {} to {}", fromId, toId);
            Object finalFromId = fromId;
            Object finalToId = toId;
            Iterator sourceIt = sourceEntities.stream().map(it -> new Tuple2(syncConfiguration.getIdFromEntity().apply(it), it)).filter(it -> syncConfiguration.getCompareId().apply(it.getA(), finalFromId) >= 0).filter(it -> syncConfiguration.getCompareId().apply(it.getA(), finalToId) <= 0).iterator();
            Iterator destinationIt = destinationEntities.stream().map(it -> new Tuple2(syncConfiguration.getIdFromPartial().apply(it), it)).filter(it -> syncConfiguration.getCompareId().apply(it.getA(), finalFromId) >= 0).filter(it -> syncConfiguration.getCompareId().apply(it.getA(), finalToId) <= 0).iterator();
            Tuple2 sourceNext = sourceIt.hasNext() ? (Tuple2)sourceIt.next() : null;
            Tuple2 destinationNext = destinationIt.hasNext() ? (Tuple2)destinationIt.next() : null;
            ArrayList toAdd = new ArrayList();
            ArrayList toRemove = new ArrayList();
            ArrayList toUpdate = new ArrayList();
            while (sourceNext != null || destinationNext != null) {
                if (sourceNext == null) {
                    toRemove.add(destinationNext.getA());
                    destinationNext = destinationIt.hasNext() ? (Tuple2)destinationIt.next() : null;
                    continue;
                }
                if (destinationNext == null) {
                    toAdd.add(sourceNext.getB());
                    sourceNext = sourceIt.hasNext() ? (Tuple2)sourceIt.next() : null;
                    continue;
                }
                int comparison = syncConfiguration.getCompareId().apply(sourceNext.getA(), destinationNext.getA());
                if (comparison == 0) {
                    if (syncConfiguration.getNeedsUpdate().check(sourceNext.getB(), destinationNext.getB())) {
                        toUpdate.add(sourceNext.getB());
                    }
                    sourceNext = sourceIt.hasNext() ? (Tuple2)sourceIt.next() : null;
                    destinationNext = destinationIt.hasNext() ? (Tuple2)destinationIt.next() : null;
                    continue;
                }
                if (comparison < 0) {
                    toAdd.add(sourceNext.getB());
                    sourceNext = sourceIt.hasNext() ? (Tuple2)sourceIt.next() : null;
                    continue;
                }
                toRemove.add(destinationNext.getA());
                destinationNext = destinationIt.hasNext() ? (Tuple2)destinationIt.next() : null;
            }
            log.debug("Will apply changes: add {} ; update {} ; delete {}", new Object[]{toAdd.size(), toUpdate.size(), toRemove.size()});
            if (!toRemove.isEmpty()) {
                syncConfiguration.getDeleteHandler().accept(toRemove);
            }
            if (!toUpdate.isEmpty()) {
                syncConfiguration.getUpdateHandler().accept(toUpdate);
            }
            if (!toAdd.isEmpty()) {
                syncConfiguration.getAddHandler().accept(toAdd);
            }
            changes.added += (long)toAdd.size();
            changes.updated += (long)toUpdate.size();
            changes.deleted += (long)toRemove.size();
            if (!sourceEntities.isEmpty() && syncConfiguration.getIdFromEntity().apply(sourceEntities.get(sourceEntities.size() - 1)).equals(toId)) {
                log.debug("Will advance source");
                updateSource = true;
            }
            if (!destinationEntities.isEmpty() && syncConfiguration.getIdFromPartial().apply(destinationEntities.get(destinationEntities.size() - 1)).equals(toId)) {
                log.debug("Will advance destination");
                updateDestination = true;
            }
            slice.setAfterId(Optional.of(toId));
            fromId = toId;
        }
        return changes;
    }
}

