/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;

public class SpaceConverterTools {
    public static long KB = 1000L;
    public static long MB = 1000L * KB;
    public static long GB = 1000L * MB;
    public static long TB = 1000L * GB;
    public static long KIB = 1024L;
    public static long MIB = 1024L * KIB;
    public static long GIB = 1024L * MIB;
    public static long TIB = 1024L * GIB;

    public static String convertToBiggestBUnit(Long bytes) {
        if (bytes == null) {
            return null;
        }
        String unit = "B";
        double main = bytes.longValue();
        if (bytes >= TB) {
            unit = "T";
            main /= (double)TB;
        } else if (bytes >= GB) {
            unit = "G";
            main /= (double)GB;
        } else if (bytes >= MB) {
            unit = "M";
            main /= (double)MB;
        } else if (bytes >= KB) {
            unit = "K";
            main /= (double)KB;
        }
        main *= 100.0;
        main = (double)Math.round(main) / 100.0;
        String text = String.valueOf(main);
        int dotPos = text.indexOf(46);
        if (dotPos != -1) {
            int maxDecimalPos = Math.min(text.length(), dotPos + 3);
            while ((text.charAt(maxDecimalPos - 1) == '.' || text.charAt(maxDecimalPos - 1) == '0') && text.charAt(--maxDecimalPos) != '.') {
            }
            text = text.substring(0, maxDecimalPos);
        }
        return text + unit;
    }

    public static long convertToBytes(String space) {
        boolean inNum = true;
        String spaceLower = space.toLowerCase();
        Object numeric = "";
        Object unit = "";
        for (int i = 0; i < spaceLower.length(); ++i) {
            char current = spaceLower.charAt(i);
            if (inNum) {
                if (current >= '0' && current <= '9' || current == '.') {
                    numeric = (String)numeric + current;
                    continue;
                }
                inNum = false;
            }
            if (current == '\t' || current == ' ') continue;
            unit = (String)unit + current;
        }
        try {
            double value = Double.parseDouble((String)numeric);
            switch (unit) {
                case "": 
                case "b": {
                    break;
                }
                case "k": 
                case "kb": {
                    value *= (double)KB;
                    break;
                }
                case "m": 
                case "mb": {
                    value *= (double)MB;
                    break;
                }
                case "g": 
                case "gb": {
                    value *= (double)GB;
                    break;
                }
                case "t": 
                case "tb": {
                    value *= (double)TB;
                    break;
                }
                case "ki": 
                case "kib": {
                    value *= (double)KIB;
                    break;
                }
                case "mi": 
                case "mib": {
                    value *= (double)MIB;
                    break;
                }
                case "gi": 
                case "gib": {
                    value *= (double)GIB;
                    break;
                }
                case "ti": 
                case "tib": {
                    value *= (double)TIB;
                    break;
                }
                default: {
                    throw new SmallToolsException(space + " is an invalid space");
                }
            }
            return (long)value;
        }
        catch (SmallToolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmallToolsException(space + " is an invalid space");
        }
    }
}

