/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.tools.AbstractBasics;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class BufferBatchesTools<I>
extends AbstractBasics
implements Closeable {
    private int itemsInBatch;
    private Consumer<List<I>> batchExecution;
    private Collection<I> buffer = new ArrayList<I>();

    public static <I> void autoClose(int itemsInBatch, Consumer<List<I>> batchExecution, Consumer<BufferBatchesTools<I>> execution) {
        BufferBatchesTools<I> bufferBatchesTools = new BufferBatchesTools<I>(itemsInBatch, batchExecution);
        execution.accept(bufferBatchesTools);
        bufferBatchesTools.close();
    }

    public static <I> void autoClose(Collection<I> buffer, int itemsInBatch, Consumer<List<I>> batchExecution, Consumer<BufferBatchesTools<I>> execution) {
        BufferBatchesTools<I> bufferBatchesTools = new BufferBatchesTools<I>(buffer, itemsInBatch, batchExecution);
        execution.accept(bufferBatchesTools);
        bufferBatchesTools.close();
    }

    public BufferBatchesTools(int itemsInBatch, Consumer<List<I>> batchExecution) {
        this.itemsInBatch = itemsInBatch;
        this.batchExecution = batchExecution;
    }

    public BufferBatchesTools(Collection<I> buffer, int itemsInBatch, Consumer<List<I>> batchExecution) {
        this.buffer = buffer;
        this.itemsInBatch = itemsInBatch;
        this.batchExecution = batchExecution;
    }

    public void add(I item) {
        this.buffer.add(item);
        while (this.buffer.size() >= this.itemsInBatch) {
            this.process();
        }
    }

    public void add(List<I> items) {
        this.buffer.addAll(items);
        while (this.buffer.size() >= this.itemsInBatch) {
            this.process();
        }
    }

    @Override
    public void close() {
        while (!this.buffer.isEmpty()) {
            this.process();
        }
    }

    private void process() {
        int to = Math.min(this.itemsInBatch, this.buffer.size());
        List subList = this.buffer.stream().limit(to).collect(Collectors.toList());
        this.batchExecution.accept(subList);
        this.buffer.removeAll(subList);
    }
}

