/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.systemusage.implementations;

import com.foilen.smalltools.systemusage.ProcUsage;
import com.foilen.smalltools.systemusage.implementations.MemoryUsageStrategy;
import com.foilen.smalltools.systemusage.results.MemoryInfo;

public class MemoryUsageProcImpl
implements MemoryUsageStrategy {
    private String procMemPath = "/proc/meminfo";
    private long lastCheck;
    private MemoryInfo lastMemoryInfo;

    public MemoryUsageProcImpl() {
    }

    public MemoryUsageProcImpl(String procMemPath) {
        this.procMemPath = procMemPath;
    }

    @Override
    public Long getSystemFreeMemory() {
        this.refreshIfNeeded();
        return this.lastMemoryInfo.getPhysicalAvailable();
    }

    @Override
    public Long getSystemTotalMemory() {
        this.refreshIfNeeded();
        return this.lastMemoryInfo.getPhysicalTotal();
    }

    @Override
    public Long getSystemUsedMemory() {
        this.refreshIfNeeded();
        return this.lastMemoryInfo.getPhysicalUsed();
    }

    private void refreshIfNeeded() {
        if (System.currentTimeMillis() - this.lastCheck > 500L) {
            this.lastMemoryInfo = ProcUsage.getMemoryInfo(this.procMemPath);
            this.lastCheck = System.currentTimeMillis();
        }
    }
}

