/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.streamwrapper;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.streamwrapper.AbstractOutputStreamWrapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenamingOnCloseOutputStreamWrapper
extends AbstractOutputStreamWrapper {
    private static final Logger logger = LoggerFactory.getLogger(RenamingOnCloseOutputStreamWrapper.class);
    private File renameSourceFile;
    private File renameDestinationFile;
    private boolean deleteOnClose = false;
    private boolean wasClosed = false;

    public RenamingOnCloseOutputStreamWrapper(OutputStream wrappedOutputStream, File renameSourceFile, File renameDestinationFile) {
        super(wrappedOutputStream);
        this.renameSourceFile = renameSourceFile;
        this.renameDestinationFile = renameDestinationFile;
    }

    public RenamingOnCloseOutputStreamWrapper(OutputStream wrappedOutputStream, File renameSourceFile, File renameDestinationFile, boolean deleteOnClose) {
        super(wrappedOutputStream);
        this.renameSourceFile = renameSourceFile;
        this.renameDestinationFile = renameDestinationFile;
        this.deleteOnClose = deleteOnClose;
    }

    @Override
    public void close() throws IOException {
        if (this.wasClosed) {
            return;
        }
        this.wasClosed = true;
        super.close();
        try {
            if (this.deleteOnClose) {
                logger.debug("Discarding the file ", (Object)this.renameSourceFile.getAbsolutePath());
                this.renameSourceFile.delete();
            } else {
                logger.debug("Renaming the file {} -> {}", (Object)this.renameSourceFile.getAbsolutePath(), (Object)this.renameDestinationFile.getAbsolutePath());
                this.renameDestinationFile.delete();
                if (!this.renameSourceFile.renameTo(this.renameDestinationFile)) {
                    throw new SmallToolsException("Could not rename the file [" + this.renameSourceFile.getAbsolutePath() + "] to [" + this.renameDestinationFile.getAbsolutePath() + "]");
                }
            }
        }
        catch (SmallToolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem renaming the file", e);
        }
    }

    public boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    public void setDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose = deleteOnClose;
    }
}

