/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.solver;

import com.foilen.smalltools.solver.SolveState;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;

public class SolverPickItemsTools<T> {
    private List<T> items;
    private boolean canReuse = true;

    public SolverPickItemsTools(List<T> items) {
        this.items = items;
    }

    private void addOneAndCheck(List<List<T>> results, Function<List<T>, SolveState> solver, Deque<Integer> positions, Deque<T> possibility) {
        int nextPos = 0;
        if (!positions.isEmpty()) {
            nextPos = positions.peekLast();
            if (!this.canReuse && ++nextPos >= this.items.size()) {
                return;
            }
        }
        while (nextPos < this.items.size()) {
            possibility.add(this.items.get(nextPos));
            switch (solver.apply((List)((Object)possibility))) {
                case NO_ADDMORE: {
                    positions.add(nextPos);
                    this.addOneAndCheck(results, solver, positions, possibility);
                    positions.removeLast();
                    break;
                }
                case NO_WONTBE: {
                    break;
                }
                case YES: {
                    results.add(new ArrayList<T>(possibility));
                }
            }
            possibility.removeLast();
            ++nextPos;
        }
    }

    public boolean isCanReuse() {
        return this.canReuse;
    }

    public void setCanReuse(boolean canReuse) {
        this.canReuse = canReuse;
    }

    public List<List<T>> solve(Function<List<T>, SolveState> solver) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        LinkedList<Integer> positions = new LinkedList<Integer>();
        LinkedList possibility = new LinkedList();
        this.addOneAndCheck(results, solver, positions, possibility);
        return results;
    }
}

