/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.listscomparator;

import com.foilen.smalltools.listscomparator.ItemsComparator;
import com.foilen.smalltools.listscomparator.ListComparatorHandler;
import com.foilen.smalltools.listscomparator.ListsComparatorDifference;
import com.foilen.smalltools.listscomparator.SpliteratorComparatorDifference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class ListsComparator {
    public static <L, R> void compareLists(List<L> lefts, List<R> rights, ItemsComparator<L, R> itemsComparator, ListComparatorHandler<L, R> listComparatorHandler) {
        int posLeft = 0;
        int posRight = 0;
        while (posLeft < lefts.size() || posRight < rights.size()) {
            Object left = null;
            if (posLeft < lefts.size()) {
                left = lefts.get(posLeft);
            }
            Object right = null;
            if (posRight < rights.size()) {
                right = rights.get(posRight);
            }
            if (left == null) {
                ++posRight;
                listComparatorHandler.rightOnly(right);
                continue;
            }
            if (right == null) {
                ++posLeft;
                listComparatorHandler.leftOnly(left);
                continue;
            }
            int comparison = itemsComparator.compareTo(left, right);
            if (comparison < 0) {
                ++posLeft;
                listComparatorHandler.leftOnly(left);
                continue;
            }
            if (comparison > 0) {
                ++posRight;
                listComparatorHandler.rightOnly(right);
                continue;
            }
            listComparatorHandler.both(left, right);
            ++posLeft;
            ++posRight;
        }
    }

    public static <T extends Comparable<T>> List<ListsComparatorDifference<T>> compareLists(List<T> lefts, List<T> rights) {
        final ArrayList<ListsComparatorDifference<T>> comparisons = new ArrayList<ListsComparatorDifference<T>>();
        ListsComparator.compareLists(lefts, rights, new ListComparatorHandler<T, T>(){

            @Override
            public void both(T left, T right) {
            }

            @Override
            public void leftOnly(T left) {
                comparisons.add(new ListsComparatorDifference(left, -1));
            }

            @Override
            public void rightOnly(T right) {
                comparisons.add(new ListsComparatorDifference(right, 1));
            }
        });
        return comparisons;
    }

    public static <T extends Comparable<T>> void compareLists(List<T> lefts, List<T> rights, ListComparatorHandler<T, T> listComparatorHandler) {
        ListsComparator.compareLists(lefts, rights, (left, right) -> left.compareTo(right), listComparatorHandler);
    }

    public static <L, R> void compareStreams(Stream<L> lefts, Stream<R> rights, ItemsComparator<L, R> itemsComparator, ListComparatorHandler<L, R> listComparatorHandler) {
        Object right;
        Iterator leftIt = lefts.iterator();
        Iterator rightIt = rights.iterator();
        Object left = leftIt.hasNext() ? leftIt.next() : null;
        Object v0 = right = rightIt.hasNext() ? rightIt.next() : null;
        while (left != null || right != null) {
            if (left == null) {
                listComparatorHandler.rightOnly(right);
                right = rightIt.hasNext() ? rightIt.next() : null;
                continue;
            }
            if (right == null) {
                listComparatorHandler.leftOnly(left);
                left = leftIt.hasNext() ? leftIt.next() : null;
                continue;
            }
            int comparison = itemsComparator.compareTo(left, right);
            if (comparison < 0) {
                listComparatorHandler.leftOnly(left);
                left = leftIt.hasNext() ? leftIt.next() : null;
                continue;
            }
            if (comparison > 0) {
                listComparatorHandler.rightOnly(right);
                right = rightIt.hasNext() ? rightIt.next() : null;
                continue;
            }
            listComparatorHandler.both(left, right);
            left = leftIt.hasNext() ? leftIt.next() : null;
            right = rightIt.hasNext() ? rightIt.next() : null;
        }
    }

    public static <T extends Comparable<T>> Stream<ListsComparatorDifference<T>> compareStreams(Stream<T> lefts, Stream<T> rights) {
        return StreamSupport.stream(new SpliteratorComparatorDifference<T>(lefts, rights), false);
    }

    public static <T extends Comparable<T>> void compareStreams(Stream<T> lefts, Stream<T> rights, ListComparatorHandler<T, T> listComparatorHandler) {
        ListsComparator.compareStreams(lefts, rights, (left, right) -> left.compareTo(right), listComparatorHandler);
    }

    private ListsComparator() {
    }
}

