/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ZerosInputStream
extends InputStream {
    private static final int EOF = -1;
    private long bytesLeft;

    public ZerosInputStream(long totalBytes) {
        this.bytesLeft = totalBytes;
    }

    @Override
    public int available() throws IOException {
        if (this.bytesLeft > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)this.bytesLeft;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft == 0L) {
            return -1;
        }
        --this.bytesLeft;
        return 0;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (bytes == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > bytes.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.bytesLeft == 0L) {
            return -1;
        }
        if ((long)len > this.bytesLeft) {
            len = (int)this.bytesLeft;
            this.bytesLeft = 0L;
        } else {
            this.bytesLeft -= (long)len;
        }
        Arrays.fill(bytes, off, off + len, (byte)0);
        return len;
    }

    @Override
    public long skip(long len) throws IOException {
        if (len <= 0L) {
            return 0L;
        }
        if (len > this.bytesLeft) {
            len = this.bytesLeft;
            this.bytesLeft = 0L;
            return len;
        }
        this.bytesLeft -= len;
        return len;
    }
}

