/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.filesystemupdatewatcher;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.filesystemupdatewatcher.FileSystemUpdateHandler;
import com.foilen.smalltools.filesystemupdatewatcher.SystemOutFileSystemUpdateHandler;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.ThreadTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FileSystemUpdateWatcher
implements Closeable {
    private Path basePath;
    private boolean recursive = false;
    private Thread thread;
    private WatchService fsWatchService;
    private List<FileSystemUpdateHandler> fileSystemUpdateHandlers = new ArrayList<FileSystemUpdateHandler>();
    private Map<WatchKey, Path> pathByKey = new HashMap<WatchKey, Path>();

    public static void main(String[] args) {
        FileSystemUpdateWatcher watcher = new FileSystemUpdateWatcher("/");
        watcher.addHandler(new SystemOutFileSystemUpdateHandler());
        watcher.init();
        ThreadTools.sleep(2000L);
        watcher.close();
        ThreadTools.sleep(2000L);
        watcher.init();
        ThreadTools.sleep(2000L);
        watcher.close();
    }

    public FileSystemUpdateWatcher(File basePath) {
        this.basePath = basePath.toPath();
    }

    public FileSystemUpdateWatcher(Path basePath) {
        this.basePath = basePath;
    }

    public FileSystemUpdateWatcher(String basePath) {
        this.basePath = Paths.get(basePath, new String[0]);
    }

    public FileSystemUpdateWatcher addHandler(FileSystemUpdateHandler fileSystemUpdateHandler) {
        this.fileSystemUpdateHandlers.add(fileSystemUpdateHandler);
        return this;
    }

    @Override
    public void close() {
        this.thread = null;
        CloseableTools.close(this.fsWatchService);
    }

    public FileSystemUpdateWatcher init() {
        AssertTools.assertNull(this.thread, "Already initialized");
        AssertTools.assertFalse(this.fileSystemUpdateHandlers.isEmpty(), "There are no handlers");
        try {
            this.fsWatchService = FileSystems.getDefault().newWatchService();
            this.registerRecursively(this.basePath);
        }
        catch (IOException e) {
            throw new SmallToolsException(e);
        }
        this.thread = new Thread(() -> {
            ThreadTools.nameThread().setSeparator("-").clear().appendObjectClassSimple(this).appendText("Started at").appendDate().appendObjectText("Folder").appendObjectText(this.basePath).change();
            while (true) {
                WatchKey key;
                try {
                    key = this.fsWatchService.take();
                }
                catch (ClosedWatchServiceException e) {
                    break;
                }
                catch (InterruptedException e) {
                    throw new SmallToolsException(e);
                }
                Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                while (iterator.hasNext()) {
                    WatchEvent<?> event;
                    WatchEvent<?> pathEvent = event = iterator.next();
                    Path completePath = this.pathByKey.get(key).resolve((Path)pathEvent.context());
                    File completeFile = completePath.toFile();
                    WatchEvent.Kind<?> kind = pathEvent.kind();
                    if (StandardWatchEventKinds.OVERFLOW.equals(kind)) continue;
                    if (StandardWatchEventKinds.ENTRY_CREATE.equals(kind)) {
                        if (this.recursive && Files.isDirectory(completePath, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerRecursively(completePath);
                        }
                        for (FileSystemUpdateHandler handler : this.fileSystemUpdateHandlers) {
                            handler.created(completeFile);
                        }
                        continue;
                    }
                    if (StandardWatchEventKinds.ENTRY_MODIFY.equals(kind)) {
                        for (FileSystemUpdateHandler handler : this.fileSystemUpdateHandlers) {
                            handler.modified(completeFile);
                        }
                        continue;
                    }
                    if (!StandardWatchEventKinds.ENTRY_DELETE.equals(kind)) continue;
                    for (FileSystemUpdateHandler handler : this.fileSystemUpdateHandlers) {
                        handler.deleted(completeFile);
                    }
                }
                if (key.reset()) continue;
                this.pathByKey.remove(key);
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
        return this;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    protected void register(Path path) {
        File directory = path.toFile();
        AssertTools.assertTrue(directory.exists(), "The directory must exists prior to watching. Path: " + path);
        AssertTools.assertTrue(directory.isDirectory(), "The path must be a directory. Path: " + path);
        try {
            WatchKey key = path.register(this.fsWatchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            this.pathByKey.put(key, path);
        }
        catch (IOException e) {
            throw new SmallToolsException(e);
        }
    }

    private void registerRecursively(Path path) {
        this.register(path);
        File file = path.toFile();
        if (this.recursive && file.isDirectory()) {
            for (File sub : file.listFiles()) {
                if (!sub.isDirectory()) continue;
                this.registerRecursively(sub.toPath());
            }
        }
    }

    public FileSystemUpdateWatcher setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }
}

