/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.filesystemupdatewatcher;

import com.foilen.smalltools.filesystemupdatewatcher.FileSystemUpdateHandler;
import com.foilen.smalltools.trigger.SmoothTrigger;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FileSystemUpdateBufferedHandler
implements FileSystemUpdateHandler {
    private static FileState[] matrixExisted = new FileState[]{FileState.MODIFIED, FileState.MODIFIED, FileState.DELETED};
    private static FileState[] matrixNotExisted = new FileState[]{FileState.CREATED, FileState.CREATED, null};
    private SmoothTrigger smoothTrigger;
    private Object lock = new Object();
    private Map<File, FileStatus> buffer = new HashMap<File, FileStatus>();

    public FileSystemUpdateBufferedHandler(FileSystemUpdateHandler wrappedHandler, long delayAfterLastEventMs, long maxDelayMs) {
        this.smoothTrigger = new SmoothTrigger(() -> {
            Map<File, FileStatus> toProcess;
            Iterator<Map.Entry<File, FileStatus>> iterator = this.lock;
            synchronized (iterator) {
                toProcess = this.buffer;
                this.buffer = new HashMap<File, FileStatus>();
            }
            for (Map.Entry<File, FileStatus> entry : toProcess.entrySet()) {
                File file = entry.getKey();
                FileStatus fileStatus = entry.getValue();
                FileState fileState = fileStatus.existed ? matrixExisted[fileStatus.lastEvent.ordinal()] : matrixNotExisted[fileStatus.lastEvent.ordinal()];
                if (fileState == null) continue;
                switch (fileState) {
                    case CREATED: {
                        wrappedHandler.created(file);
                        break;
                    }
                    case DELETED: {
                        wrappedHandler.deleted(file);
                        break;
                    }
                    case MODIFIED: {
                        wrappedHandler.modified(file);
                        break;
                    }
                }
            }
        }).setDelayAfterLastTriggerMs(delayAfterLastEventMs).setMaxDelayAfterFirstRequestMs(maxDelayMs).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bufferEvent(File file, boolean existed, FileState lastEvent) {
        Object object = this.lock;
        synchronized (object) {
            FileStatus fileStatus = this.buffer.get(file);
            if (fileStatus == null) {
                fileStatus = new FileStatus(existed, lastEvent);
                this.buffer.put(file, fileStatus);
            }
            fileStatus.lastEvent = lastEvent;
            this.smoothTrigger.request();
        }
    }

    @Override
    public void created(File file) {
        this.bufferEvent(file, false, FileState.CREATED);
    }

    @Override
    public void deleted(File file) {
        this.bufferEvent(file, true, FileState.DELETED);
    }

    @Override
    public void modified(File file) {
        this.bufferEvent(file, true, FileState.MODIFIED);
    }

    private static class FileStatus {
        private boolean existed;
        private FileState lastEvent;

        public FileStatus(boolean existed, FileState lastEvent) {
            this.existed = existed;
            this.lastEvent = lastEvent;
        }
    }

    private static enum FileState {
        CREATED,
        MODIFIED,
        DELETED;

    }
}

