/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools;

import com.foilen.smalltools.exception.SmallToolsException;

public class TimeoutRunnableHandler {
    private long timeoutInMilliseconds;
    private Runnable runnable;
    private RuntimeException thrownException;

    public TimeoutRunnableHandler(long timeoutInMilliseconds, Runnable runnable) {
        this.timeoutInMilliseconds = timeoutInMilliseconds;
        this.runnable = runnable;
    }

    public void run() {
        Thread callThread = new Thread(() -> {
            try {
                this.runnable.run();
            }
            catch (RuntimeException e) {
                this.thrownException = e;
            }
        }, "TimeoutHandler");
        callThread.start();
        try {
            callThread.join(this.timeoutInMilliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (callThread.isAlive()) {
            callThread.interrupt();
            throw new SmallToolsException("The call is still running and the timeout passed");
        }
        if (this.thrownException != null) {
            throw this.thrownException;
        }
    }
}

